#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Dec 10 15:06:52 2020

@author: jim
"""

# Program to calculae the co-efficients for 
# an efficient arc-tangent approximation
# using a number of straightline segments.
#   This is the Python
# equivalent to the procedures I wrote
# originally in Scilab all those years ago


import numpy as np
import math
import matplotlib.pyplot as plt

def I0(x2, x1):
    t2 = (x2 * math.atan(x2)) - ((math.log(1 + x2*x2))/2)
    t1 = (x1 * math.atan(x1)) - ((math.log(1 + x1*x1))/2)
    return t2 - t1

def I1(x2, x1):
    return x2 - x1

def I2(x2, x1):
    return (x2*x2 -x1*x1)/2.0

def I3(x2, x1):
    t2 = 0.5 * ((math.atan(x2)*(1 + x2 * x2)) - x2)
    t1 = 0.5 * ((math.atan(x1)*(1 + x1 * x1)) - x1)
    return t2 -t1

def I4(x2, x1):
    return ((x2*x2*x2)- (x1*x1*x1)) / 3

def A(x2, x1):
    d=(I1(x2, x1)*I4(x2, x1)) - (I2(x2, x1)*I2(x2, x1))
    n=(I0(x2, x1)*I4(x2, x1)) - (I2(x2, x1)*I3(x2, x1))
    return  n / d

def B(x2, x1):
    d=(I1(x2, x1)*I4(x2, x1)) - (I2(x2, x1)*I2(x2, x1))
    n=(I1(x2, x1)*I3(x2, x1)) - (I2(x2, x1)*I0(x2, x1))
    return  n / d

def at(x2, x1, x):
    return A(x2, x1) + (B(x2, x1)*x)

def difference(x2, x1, x):
    return 57.29578 * (math.atan(x) - at(x2, x1, x))

n = 16
n = int(input("Type number of segments: "))
Fs = 10000
Fs =int(input("Type sample rate: "))

multiplier = Fs / 6.2832   # Fs / 2 pi

plt.xlabel("Value")
plt.ylabel("Degrees")
plt.title("Error in returned value")

for i in range(n + 1):
    a = (1.0 / n) * i
    b = a + (1.0 / n)
    print(i, round(multiplier * A(b, a)), round(multiplier * B(b,a)))
#    xdata = linspace(a, b, 50)
#    plot(xdata, difference(b, a, xdata))
#    xtitle ("Error between atan and approximation", "X value", "Error in degrees")
    x = np.arange(a, b, (b - a) / 50.0)
    y = np.arange(a, b, (b - a) / 50.0)
    for j in range(50):
        y[j] = difference(b, a, x[j])
    plt.plot(x, y)
plt.show()
    
