;----- ADC_LCD_OUTPUT ----------------------------------------------------------
; To be used with Texas Instruments MSP430G2553 microcontroller (MCU).
; To be used with the Newhaven NHD-0216K1Z 16x2 LCD Display.
; Can also use other displays that use the HD44780 or ST7066U driver chips.
; Texas Instruments Code Composer IDE used to program microcontroller.
; Pin connections for the LCD display and the microcontroller in QEX article.
;
; This program is set up to input a small analog voltage into pin #15 of MCU.
; A rotational sensor (5K potentiometer) is used where the center connector is
; wired to pin #15 of the MCU, one of the other connectors is wired to 3.3 volts,
; and the other is wired to ground (a voltage divider configuration). A digital
; number between 0-1023 is stored in the &ADC10MEM register and converted to
; a BCD number, the BCD number is then converted to an ASCII number which and
; sent to the LCD display.

; 1 March 2021 -----------------------------------------------------------------
; James Kretzschmar AE7AX ------------------------------------------------------

;-------------------------------------------------------------------------------
;----- STANDARD SET UP INFORMATION PROVIDED BY CODE COMPOSER TEMPLATE ----------
;-------------------------------------------------------------------------------
            .cdecls C,LIST,"msp430.h"       ; Include device header file
;-------------------------------------------------------------------------------
            .def    RESET                   ; Export program entry-point to
                                            ; make it known to linker.
;-------------------------------------------------------------------------------
            .text                           ; Assemble into program memory.
            .retain                         ; Override ELF conditional linking
                                            ; and retain current section.
            .retainrefs                     ; And retain any sections that have
                                            ; references to current section.
;-------------------------------------------------------------------------------
RESET       mov.w   #__STACK_END,SP         ; Initialize stackpointer
StopWDT     mov.w   #WDTPW|WDTHOLD,&WDTCTL  ; Stop watchdog timer

;-------------------------------------------------------------------------------
;----- SETS CPU CLOCK SPEED, SETS UP I/O PINS, SETS UP ADC ---------------------
;-------------------------------------------------------------------------------

START_HERE:
    mov.b   &CALBC1_16MHZ,&BCSCTL1  ; Factory calibration of 16 MHz
    mov.b   &CALDCO_16MHZ,&DCOCTL   ; Clock at 16 MHz

    mov.b   #00000000b, &P1SEL      ; Port 1 all I/O pins
    mov.b   #00000000b, &P2SEL      ; Port 2 all I/O pins
	mov.b   #00110000b, &P1DIR      ; 2 Bits are OUTPUT (P1.4 and P1.5)
    mov.b   #11111111b, &P2DIR      ; 8 Bits are OUTPUT (P2.0 - P2.7)
	mov.b   #00000000b, &P1OUT      ; Nothing going out on Port 1
	mov.b   #00000000b, &P2OUT      ; Nothing going out on Port 2

	mov.w   #ADC10SHT_2+ADC10ON, &ADC10CTL0 ; Setting up ADC
    mov.w   #INCH_7, &ADC10CTL1             ; Setting up ADC
    bis.b   #BIT7, &ADC10AE0                ; Setting up ADC

;--------------------------------------------------------------------------------
;----- END OF SETTING UP CLOCK, I/O PINS, AND ADC -------------------------------
;--------------------------------------------------------------------------------
;----- INITIALIZATION OF LCD     AFTER POWER ON ... A 50 MILLISECOND DELAY ------
;--------------------------------------------------------------------------------

    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_0:
	dec     R12
    jnz     DELAY_0
    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_00:
	dec     R12
    jnz     DELAY_00
    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_000:
	dec     R12
    jnz     DELAY_000
    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_0000:
	dec     R12
    jnz     DELAY_0000

;-------------------------------------------------------------------------------
;----- END OF 50 MILLISECOND DELAY ---------------------------------------------
;-------------------------------------------------------------------------------

;----- (COMMAND: FIRST INITIALIZATION --- THEN 5 MILLISECOND DELAY) ------------
    mov.b	#00111000b, R13         ; 8-Bit, 2 Line
    call    #SETUP                  ; Routine To Load SETUP
    mov     #26215, R12             ; 5 Millisecond Delay
DELAY_1:
	dec     R12
	jnz     DELAY_1
;----- (COMMAND: SECOND INITIALIZATION --- THEN 100 MICROSECOND DELAY) ----------
    mov.b   #00111000b, R13         ; 8-Bit, 2 Line
	call    #SETUP                  ; Routine To Load SETUP
    mov     #525, R12               ; 100 Microsecond Delay
DELAY_2:
	dec     R12
    jnz     DELAY_2
;----- (COMMAND: THIRD INITIALIZATION --- THEN 100 MICROSECOND DELAY) -----------
	mov.b   #00111000b, R13         ; 8-Bit, 2 Line
	call    #SETUP                  ; Routine To Load SETUP
    mov     #525, R12               ; 100 Microsecond Delay
DELAY_3:
	dec     R12
    jnz     DELAY_3

;--------------------------------------------------------------------------------
;----- END OF INITIALIZATION OF LCD ---------------------------------------------
;--------------------------------------------------------------------------------
;----- SETUP OF LCD -------------------------------------------------------------
;--------------------------------------------------------------------------------

;----- (COMMAND: SELECTS 8-BIT, 2 LINE) -----------------------------------------
    mov.b   #00111000b, R13    ; 8-Bit, 2 Line
    call    #SETUP             ; Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_4:
    dec     R12
    jnz     DELAY_4

;----- (COMMAND: CLEAR DISPLAY) -------------------------------------------------
    mov.b   #00000001b, R13    ; Clear Display (Clearing DDRAM takes long time)
    call    #SETUP             ; Routine To Load SETUP
    mov     #26215, R12        ; 5 Millisecond Delay
DELAY_5:
    dec     R12
    jnz     DELAY_5

;----- (COMMAND: SETS DDRAM ADDRESS) --------------------------------------------
    mov.b   #10000001b, R13    ; DDRAM Address 01 selected. This can be changed
    call    #SETUP             ; Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_6:
    dec     R12
    jnz     DELAY_6

;----- (COMMAND: DISPLAY CONTROL) -----------------------------------------------
    mov.b   #00001100b, R13    ; Display ON, Cursor OFF, Cursor Blinking OFF
    call    #SETUP             ; Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_7:
    dec     R12
    jnz     DELAY_7

;----- (COMMAND: DISPLAY SHIFT/CURSOR MOVE (RIGHT OR LEFT) ----------------------
    mov.b   #00000110b, R13    ; Display Shift OFF, Next character to the right
    call    #SETUP             ; Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_8:
    dec     R12
    jnz     DELAY_8

;----- (COMMAND: CURSOR/DISPLAY SHIFT)(NOT IMPLEMENTED) -------------------------
    ;mov.b   #00010000b, R13   ; Cursor/Display Shift OFF, Shift Left
    ;call    #SETUP            ; Routine To Load SETUP
    ;mov     #525, R12         ; 100 Microsecond Delay
;DELAY_9:
    ;dec     R12
    ;jnz     DELAY_9

;----- (COMMAND: CURSOR HOME)(NOT IMPLEMENTED) ----------------------------------
    ;mov.b   #00000010b, R13   ; Cursor Home (DDRAM address 00)
    ;call    #SETUP            ; Routine To Load SETUP
    ;mov     #525, R12         ; 100 Microsecond Delay
;DELAY_10:
    ;dec     R12
    ;jnz     DELAY_10

    jmp     INPUT_DATA_FOR_LABEL ; Done with setup, goto INPUT_DATA_FOR_LABEL

;--------------------------------------------------------------------------------
;----- SUBROUTINE THAT LOADS SETUP INFORMATION INTO LCD -------------------------
;--------------------------------------------------------------------------------

SETUP:
    mov.b   #00000000b, &P1OUT ; P1.4 (R/S) goes LOW (Selects COMMAND MODE)
    mov     R13, R15           ; Loads contents of R13 into R15

    bis.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes HIGH
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_11:
    dec     R12
    jnz     DELAY_11

    mov.b   R15, &P2OUT        ; Data goes out on Port 2 D0-D7 lines

	bic.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes LOW
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_12:
    dec     R12
    jnz     DELAY_12

    ret                        ; Returns program to whwere it came from

;--------------------------------------------------------------------------------
;----- END OF SUBROUTINE THAT LOADS SETUP INFORMATION INTO LCD ------------------
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;----- END OF SETUP OF LCD ------------------------------------------------------
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;----- THIS SECTION INPUTS DATA FOR LABEL AND ADC DATA --------------------------
;--------------------------------------------------------------------------------

INPUT_DATA_FOR_LABEL:

    mov.b   #10000001b, R13    ; Sets Location at DDRAM "01" for start of label
    call    #SETUP

    mov     #525, R12          ; 100 Microsecond Delay
DELAY_13:
    dec     R12
    jnz     DELAY_13

    mov     #83, R4            ; Loads ASCII number for "S"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #101, R4           ; Loads ASCII number for "e"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #110, R4           ; Loads ASCII number for "n"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #115, R4           ; Loads ASCII number for "s"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #111, R4           ; Loads ASCII number for "o"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #114, R4           ; Loads ASCII number for "r"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #32, R4            ; Loads ASCII number for "Blank Space"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #32, R4            ; Loads ASCII number for "Blank Space"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #79, R4            ; Loads ASCII number for "O"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #117, R4           ; Loads ASCII number for "u"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #116, R4           ; Loads ASCII number for "t"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #112, R4           ; Loads ASCII number for "p"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #117, R4           ; Loads ASCII number for "u"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #116, R4           ; Loads ASCII number for "t"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    jmp     PROCESS_ADC_DATA   ; Goto section to that processes ADC data

;---------------------------------------------------------------------------------
;----- PROCESSING OF ADC DATA SECTION --------------------------------------------
;---------------------------------------------------------------------------------

PROCESS_ADC_DATA:
;---------------------------------------------------------------------------------
;----- This section is a delay which consists of an Outer Delay Loop and an ------
;----- Inner Delay Loop. The Inner Delay Loop is approximately 4 Milliseconds ----
;----- and the Outer Delay Loop is how many times the Inner Delay Loop is run. ---
;----- The number can be changed as needed. With the CPU clock running at 16 MHz -
;----- and no delay the displayed numbers were "jumpy" and needed to be slowed ---
;----- down before they were sent to the LCD for display. ------------------------
;---------------------------------------------------------------------------------
          mov       #75, R14   ; This number can be changed as needed
OUTER_DELAY_LOOP:

          mov       #65535, R12 ; This number provides for a 4 Millisecond delay
INNER_DELAY_LOOP:
          dec       R12
          jnz       INNER_DELAY_LOOP

          dec       R14
          jnz       OUTER_DELAY_LOOP
;-----------------------------------------------------------------------------------
;-------------------------- END OF DELAY SECTION -----------------------------------
;-----------------------------------------------------------------------------------

;-----------------------------------------------------------------------------------
;----- THIS SECTION SETS DDRAM ADDRESS WHERE ADC DATA WILL BE DISPLAYED, -----------
;----- TURNS ON THE ADC TO ACQUIRE A BINARY NUMBER, CONVERTS THE BINARY NUMBER -----
;----- TO A BCD NUMBER, AND THEN CONVERTS THE BCD NUMBER TO AN ASCII NUMBER --------
;----- WHICH IS THEN SENT TO THE LCD TO BE DISPLAYED -------------------------------
;-----------------------------------------------------------------------------------
          mov.b     #11000111b, R13 ; Sets location at DDRAM "71"
          call      #SETUP

          mov       #525, R12       ; 100 Microsecond Delay
DELAY_14:
          dec       R12
          jnz       DELAY_14
;-----------------------------------------------------------------------------------
;----- TURNS ON ADC TO ACQUIRE A BINARY NUMBER -------------------------------------
;-----------------------------------------------------------------------------------
           bis.w     #ENC+ADC10SC, &ADC10CTL0 ; Starts an ADC conversion

           mov.w     #20000, R8 ; Delay, gives time to settle before moving data
DELAY_15:
           dec       R8
           jnz       DELAY_15

           mov.w     &ADC10MEM, R9  ; Move data from ADC Memory Register to R9

           jmp       CONVERT_BINARY_NUMBER_TO_BCD_NUMBER

;-----------------------------------------------------------------------------------
;----- SUBROUTINE TO CONVERT BINARY NUMBER TO BCD NUMBER ---------------------------
;-----------------------------------------------------------------------------------

CONVERT_BINARY_NUMBER_TO_BCD_NUMBER:

           mov        #0, R6  ; Make sure R6 is empty
           rla.w      R9      ;
           dadd.w     R6, R6  ; NOTES FOR THIS SUBROUTINE
           rla.w      R9      ; The assembly statement "dadd" is only available for
           dadd.w     R6, R6  ; use when programming in assembly. These lines take
           rla.w      R9      ; the 16 Bit register R9 and roll off one bit at a
           dadd.w     R6, R6  ; time to the left. The "BCD Conversion" process is
           rla.w      R9      ; accomplished with the "dadd" statement and stored
           dadd.w     R6, R6  ; in R6. These lines of code could be consolidated
           rla.w      R9      ; into a loop process (repeated 16 times), however it
           dadd.w     R6, R6  ; is important to see how the BCD conversion is done.
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6
           rla.w      R9
           dadd.w     R6, R6

           jmp        CONVERT_BCD_NUMBER_TO_ASCII_NUMBER

;------------------------------------------------------------------------------------
;----- END OF SUBROUTINE TO CONVERT BINARY NUMBER TO BCD NUMBER ---------------------
;------------------------------------------------------------------------------------
;----- SUBROUTINE TO CONVERT BCD NUMBER TO ASCII NUMBER -----------------------------
;------------------------------------------------------------------------------------

CONVERT_BCD_NUMBER_TO_ASCII_NUMBER:
           mov      #0, R7   ; Make sure R7 is empty
           mov      #4, R10  ; Place 4 in counter R10
READ_4_BITS:                 ;
           rlc      R6       ; NOTES FOR THIS SUBROUTINE
           jc       EIGHT    ; The BCD number stored in R6 is evaluated 4 bits at a
ROLL_BIT2:                   ; time to create a decimal number which is then stored
           rlc      R6       ; in R7. The appropriate ASCII number is created and
           jc       FOUR     ; sent to the LCD display. This process is done 4 times
ROLL_BIT1:                   ; so that the entire 16 bit register (R6) is read
           rlc      R6       ; (one BCD number per 4-bit block). The process
           jc       TWO      ; repeats itself with a new number from the ADC. The
ROLL_BIT0:                   ; maximum number that a 10-bit ADC can deliver is 1023
           rlc      R6       ; and the 4 digits can easily be represented as a BCD
           jc       ONE      ; number in the "4 blocks" of a 16-bit register. A
           jmp      DIGIT    ; 5 digit number would require modification of this
                             ; program code.
EIGHT:
           add      #8, R7
           jmp      ROLL_BIT2
FOUR:
           add      #4, R7
           jmp      ROLL_BIT1
TWO:
           add      #2, R7
           jmp      ROLL_BIT0
ONE:
           add      #1, R7

DIGIT:
           add      #48, R7
           mov      R7, R4

           call     #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

           mov      #0, R4
           mov      #0, R7
           dec      R10
           cmp      #0, R10
           jeq      PROCESS_ADC_DATA
           jmp      READ_4_BITS

;------------------------------------------------------------------------------
;----- SUBROUTINE THAT SENDS ASCII NUMBER TO LCD DISPLAY ----------------------
;------------------------------------------------------------------------------

SEND_ASCII_NUMBER_TO_LCD_DISPLAY:

    mov.b   #00010000b, &P1OUT ; P1.4 a "1" DATA MODE selected
    mov     R4, R13            ; Whatever the count is in R4
    mov     R13, R15           ; Loads contents of R13 into R15

    bis.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes HIGH
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_16:
    dec     R12
    jnz     DELAY_16

    mov.b   R15, &P2OUT        ; Data goes out on D0-D7 lines

	bic.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes LOW
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_17:
    dec     R12
    jnz     DELAY_17

    ret                        ; Returns program to where it came from

;-------------------------------------------------------------------------------
;----- END OF SUBROUTINE THAT SENDS ASCII NUMBER TO LCD DISPLAY ----------------
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
; Stack Pointer definition
;-------------------------------------------------------------------------------
            .global __STACK_END
            .sect   .stack
;-------------------------------------------------------------------------------
; Interrupt Vectors
;-------------------------------------------------------------------------------
            .sect   ".reset"                ; MSP430 RESET Vector
            .short  RESET
            
