// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================



//===================================================================================================================================
// DISPLAY UPDATE ROUTINES
//===================================================================================================================================


void ChkHmiRx()
{
	//chk for hmi messages

	if (hmiNewMsg)
	{
		//there is a message pending
		return;
	}

	//infoMsg format is 0xfa 0xfa 0xfa {page#} {total# of bytes sent} {info} 0xfb
	bool infoMsg = false; //goes true if msg begins with three 0xfa's, then 0xaf or 0xbf (0xaf is normal info block, bf is string block), then 0xfa. Call Dec_TxInfo() if this is the correct # of bytes and ends with 0xfb
	bool isString = false; //goes true if 0xbf is 4th byte in preamble

	int activeDisp = 0;

	uint32_t waitTmr = millis();

	//wait 100ms for start of rx, then wait up to 20 mS between chrs
	while (100L > millis() - waitTmr)
	{
		if (!hmiRmt)
		{
			activeDisp = HMI.available();
		}
		else
		{
			activeDisp = HMIR.available();
		}
		if (activeDisp)
		{
			goto StartRx;
		}
	}
	return; //nothing to rx


StartRx:

	int hmiMsgCtr = 0; //not using hmiRx[0]
	byte rx = 0;
	uint32_t hmiMsgTimeout = millis();//start interbyte timer

Wait4Chr:
	while (hmiMsgTimeoutDefault > millis() - hmiMsgTimeout)
	{
		//wait for reply		
		if (!hmiRmt)
		{
			activeDisp = HMI.available();
		}
		else
		{
			activeDisp = HMIR.available();
		}
		if (activeDisp)
		{
			if (!hmiRmt)
			{
				rx = HMI.read();
			}
			else
			{
				rx = HMIR.read();
			}
			hmiMsgCtr++; //start on idx 1
			hmiRx[hmiMsgCtr] = rx;
			hmiMsgTimeout = millis();

#ifdef DEBUG_HMI_RX_DATA
			SerialOut(String(hmiRx[hmiMsgCtr], HEX) + " ", false);
#endif

			//look for 0xfa 0xfa 0xfa '0xaf or 0xbf' 0xfa  preamble for block message - if byte 3 = 0xaf this is a normal block, if 0xbf this is a text string, the byte after the byte ctr is the 
			if ((hmiInitialized == true) && (hmiMsgCtr > 4)			
				&& (hmiRx[hmiMsgCtr - 4] == 0xfa && hmiRx[hmiMsgCtr - 3] == 0xfa && hmiRx[hmiMsgCtr - 2] == 0xfa && (hmiRx[hmiMsgCtr - 1] == 0xaf || hmiRx[hmiMsgCtr - 1] == 0xbf) && hmiRx[hmiMsgCtr] == 0xfa))
			{				 
				//start of a txInfo message
#ifdef DEBUG_HMI_RX_DATA
				SerialOut("\nStarting info msg", true),
#endif
					infoMsg = true;
				if (hmiRx[hmiMsgCtr - 1] == 0xbf)
				{
					isString = true;
				}

				hmiMsgCtr = 0; //start at first of msg							

				//next byte will be page # followed by byte ctr
			}
			else if (infoMsg == true)
			{
				//clock in info msg			
				//ignore byte counter if this is a string msg
				if (hmiRx[hmiMsgCtr] == 0xfb && ((hmiMsgCtr == int(hmiRx[2]) && isString == false) || (isString == true)))
				{
					//msg complete, decode it
#ifdef DEBUG_HMI_RX_DATA					
					SerialOut("\nTxInfo msg rcvd", true);
#endif
					if (!isString)
					{
						Dec_TxInfo();
					}
					else
					{
						Dec_StringInfo();
					}

					infoMsg = false;
					isString = false;
					hmiNewMsg = 0;
					hmiMsgCtr = 0;
					if (!HMI.available() && !HMIR.available())
					{
						return; //nothing else waiting
					}
				}
				else if ((hmiMsgCtr > int(hmiRx[2]) && isString == false) || (hmiMsgCtr > 150 && isString == true))
				{
					hmiNewMsg = 0;
					hmiMsgCtr = 0;
					infoMsg = false;
					isString = false;
#ifdef DEBUG_HMI_RX_DATA					
					SerialOut("\nRx Msg overrun\n", true);
#endif
					if (!HMI.available() && !HMIR.available())
					{
						return; //nothing else waiting
					}
				}
				goto Wait4Chr;
			}
			else if ((hmiMsgCtr > 3) && (infoMsg == false) && (hmiRx[hmiMsgCtr - 2] == 0xff) && (hmiRx[hmiMsgCtr - 1] == 0xff) && (hmiRx[hmiMsgCtr] == 0xff))
			{
				//normal message - look for 0xff 0xff 0xff terminator					
				//Debug
#ifdef DEBUG_HMI_RX
				if (hmiWait4Reply != 0)
				{
					SerialOut("<< ", false); //offset if we're expecting a reply
				}
				else
				{
					SerialOut("<- ", false);
				}
				for (int j = 1; j < hmiMsgCtr + 1; j++)
				{
					SerialOut(String(hmiRx[j], HEX) + " ", false);
				}
				SerialOut(" ", true);
#endif

				//rx terminator, process rx command here

				//check for txt data type, it can be any length, decode it in DecHMICmd
				if (hmiRx[1] == 0x70 && hmiInitialized == true)
				{
					hmiNewMsg = 0x70; //trigger text event processing
#ifdef DEBUG_HMI_RX_DATA
					SerialOut(" ", true);
#endif
					return;
				}

				switch (hmiMsgCtr)
				{
				case 4:
					//single command, process msg
					PrintHmiErrMsg();
#ifdef DEBUG_HMI_RX_DATA
					SerialOut(" ", true);
#endif
					return;
					break;
				case 5:
					//current page is async sent every 1/2 sec if we're on a page that needs updating
					if (hmiRx[1] == 0x66 && hmiInitialized == true)
					{
						hmiPage = hmiRx[2];
						Chk4PageChange();
#ifdef DEBUG_HMI_RX_DATA
						SerialOut(" ", true);
#endif
						return;
					}
					break;
				case 6:
					if (hmiRx[1] == 0 && hmiRx[2] == 0 && hmiRx[3] == 0)
					{
						//rest command completed
						hmiInitialized = true;						
						SerialOut("\nHMI Initialized\n", true);
						return;
					}
					break;
				case 7:
					//touch event
					if (hmiRx[1] == 0x65 && hmiInitialized == true)
					{
						hmiNewMsg = 0x65; //trigger event processing	
						hmiPage = hmiRx[2];
						hmiCompID = hmiRx[3];
						hmiUpdateCtr = 0; //update HMI immediately
						hmiLastPage = 0;
						SerialOut("\nComponent Event: Page " + String(hmiPage) + ", CompID " + String(hmiCompID) + ", Event " + String(hmiEvent) + "\n", true);
						return;
					}
					break;
				case 8:
					if (hmiRx[1] == 0x71 && hmiInitialized == true)
					{
						//.val reply
						hmiNewMsg = 0x71;
						hmiLastPage = 0;
#ifdef DEBUG_HMI_RX_DATA
						SerialOut(" ", true);
#endif
						return;
					}
					break;
				case 9:
					//touch coordinate, just wake up if asleep
					if (hmiRx[1] == 0x67 || hmiRx[1] == 0x68)
					{
						hmiWait4Reply = 0;
						Tx2HMI("sleep=0");
						Tx2HMI("sleep=0");
						if (hmiPage == HMI_HOME)
						{
							Tx2HMI("page " + String(hmiPage)); //force page update to update fiber lines
							Tx2HMI("page " + String(hmiPage));
						}
#ifdef DEBUG_HMI_RX_DATA
						SerialOut(" ", true);
#endif
						return;
					}
					break;
				default:

					break;
				}
				SerialOut("ChkHmiRx failed to decode command with " + String(hmiMsgCtr) + " bytes", true);
				for (int j = 1; j < hmiMsgCtr + 1; j++)
				{
					SerialOut(String(hmiRx[j], HEX) + " ", false);
				}
				SerialOut(" ", true);
				hmiWait4Reply = 0;
				Tx2HMI("sleep=0"); //incase we're stuck in sleep mode
				return;
			}
			goto Wait4Chr;
		}
		goto Wait4Chr;
	}

#ifdef DEBUG_HMI_RX_DATA
	SerialOut("Failed out of ChkHMIRx()", true);
#endif

	infoMsg = false;
	isString = false;
}

void DecHMICmd()
{
	//decode hmi rx data
	int msg = hmiNewMsg;
	hmiNewMsg = 0;

	String txt = "";
	String temp = "";

	switch (msg)
	{
	case 0x00:
		return;
		break;
	case 0x65:
		//touch event - these will be button presses		
		switch (hmiPage)
		{
		case HMI_CONFIG:
			switch (hmiCompID)
			{
			case HMI_CONFIG_DEL_LOG:
				if (gDelLogClick == false)
				{
					gDelLogClick = true;
					gDelLogTimer = millis();
				}
				else if (millis() - gDelLogTimer < 5000)
				{
					DeleteLog();
				}
				break;
			}
			break;
		case HMI_EDIT:
			switch (hmiCompID)
			{
			case HMI_EDIT_SAVE:
				//save btn pressed on edit page
				hmiCtrlChange = HMI_EDIT_DOWNLOAD; //start process to get fields from edit page and update record		
				break;
			}
			break;		
		}
		break;
	case 0x66:
		//'sendme' from page - these have been removed

		break;
	case 0x70:
		//text reply
		switch (hmiWait4Reply)
		{
		case HMI_gMyCall:
			if (hmiPage == HMI_HOME)
			{
				DecHMIRxTxt(txt, 22);
				if (txt.length() > 0)
				{
					gMyCall = txt;
				}
			}
			break;
		case HMI_bPwr:
			if (hmiPage == HMI_HOME)
			{
				DecHMIRxTxt(txt, 10);
				if (txt.length() > 0)
				{
					bPwr = txt;
				}
			}
			break;
			
		case HMI_RADIO_gSelTxt:
			if (hmiPage == HMI_RADIO)
			{
				DecHMIRxTxt(txt, 13);
				if (txt.length() > 0)
				{
					gSelTxt = txt;
					if (txt.toUpperCase() == "BYPASS")
					{
						txt = "BYPASS"; //force to ucase because hmi can't test for case
					}
					//SerialOut("Home.gSelTxt= " + txt, true);
				}
			}
			break;
		case HMI_ANT_saveTag:
			if (hmiPage == HMI_ANT)
			{
				//this is the changed tag name from the Ant page. Update radioTag[] and sve array to SD
				DecHMIRxTxt(txt, 10);
				//SerialOut(txt, true);
				if (txt.length() == 0)
				{
					txt = "-- " + String(antSaveTag) + " --"; //back to default
				}
				radioTag[antSaveTag + 15] = txt;
				SaveRadioTags();
			}
		}
		break;
	case 0x71:
		break;

	default:
		break;
	}
	hmiCompID = 0;
}

void DecHMIRxTxt(String & txt, int maxLen)
{
	//pull the txt out of the hmiRx[] array
	for (int i = 2; i < maxLen; i++)
	{
		if (hmiRx[i] != 0xff)
		{
			txt += char(hmiRx[i]);
		}
		else
		{
			break;
		}
	}
	if (txt.length() == 0)
	{
		txt = "";
	}
}


void FindNextMem(int dir)
{
	//inc (1) or dec (-1) to next valid memory slot
	//find first matching freq in list
	//gMSel range is 1 to 100, memory data stored in 0 to 99
	//gMSelPtr is the current position of gMSel, gMSel is set to 0 when freq changes so call to FreqMem page works

	//gMSelPrev = gMSelPtr; //only change if we find a new freq
	uint8_t i = 0;

	if (dir == -1)
	{
		//dec memory ptr to next valid memory slot				
		if (gMSelPtr > 0)
		{
			for (i = gMSelPtr; i > 0; i--)
			{				
				if (freqMemFreqA[i - 1] >= 100000)
				{
					//found one!										
					gMSel = i; //load this rec on exit											
					gMSelPrev = 0; //so we detect change
					//blockHMI = millis() + 1000; //so we don't overwrite gMSel with TxInfo
					return;
				}
			}
		}
		//we didn't find one above, try starting from end
		for (i = freqMemMax + 1; i > gMSelPtr; i--)
		{
			if (freqMemFreqA[i - 1] >= 100000)
			{
				gMSel = i;				
				gMSelPrev = 0; //so we detect change
				//blockHMI = millis() + 1000;
				return;
			}
		}
	}
	else
	{
		if (gMSelPtr < freqMemMax + 1)
		{
			for (i = gMSelPtr + 2; i < freqMemMax + 1; i++)
			{				
				if (freqMemFreqA[i - 1] >= 100000)
				{
					//found one!
					//SerialOut("+ from " + String(gMSelPtr +1) + ", gMsel= " + String(i), true);
					gMSel = i; //load this rec on exit					
					gMSelPrev = 0; //so we detect change
					//blockHMI = millis() + 1000;
					return;
				}
			}
		}		
		//we didn't find one above, try starting from first entry
		for (i = 1; i < gMSelPtr; i++)
		{			
			if (freqMemFreqA[i - 1] >= 100000)
			{
				//SerialOut("+ from start 1, gMsel= " + String(i), true);
				gMSel = i;				
				gMSelPrev = 0; //so we detect change
				//blockHMI = millis() + 1000;
				return;
			}
		}

	}
}


bool SaveLogEntryFromHMI()
{
	//download fields from SaveLog page and append to CTR2_LOG.ADI
	//SerialOut("Updating Log", true);
	//hide Save button - "Saving..." text under it	
	hmiWait4Reply = 0;
	Tx2HMI("bSave.txt=`Saving...`");
	Tx2HMI("bSave.txt=`Saving...`");
	//arrays are loaded in Dec_String() when we're on the SaveLog page

	blockISR = true;
	SaveLog(); //we'll organize the fields here
	blockISR = false;
	if (gLogMode == true)
	{
		gCtstCtr++;
		hmiWait4Reply = 0;
		Tx2HMI("gCtstCtr=" + String(gCtstCtr));
		Tx2HMI("gCtstCtr=" + String(gCtstCtr));
	}
	hmiWait4Reply = 0;
	Tx2HMI("click bClear,0"); //click the clear btn to reset the entry
	delay(100);
	hmiWait4Reply = 0;
	Tx2HMI("Log.h1.val=0");//show the last entry
	Tx2HMI("Log.rtnPg.val=1"); //so we return to Home after viewing log
	Tx2HMI("page Log");
	return true;
	
}

bool SaveEditPgFromHMI()
{
	
	if (editPgTxt[0].toInt() > 0 && editPgTxt[0].toInt() <= freqMemMax)	
	{	
		gMSel = editPgTxt[0].toInt(); //record#
		gMSelPrev = gMSel; //so we don't change radio freq/mode after edit
		freqMemLabel[gMSel - 1] = editPgTxt[1]; 
		freqMemFreqA[gMSel - 1] = uint32_t(editPgTxt[2].toInt());
		freqMemRMode[gMSel - 1] = Dec_RMode_Txt(editPgTxt[3].trim());		
		freqMemOMode[gMSel - 1] = Dec_OMode_Txt(editPgTxt[4].trim());
		freqMemFreqB[gMSel - 1] = uint32_t(editPgTxt[6].toInt());
		if (editPgSplit == 1 && freqMemFreqB[gMSel - 1] >= 100000)
		{
			gSplit = 2; //split vfo
		}
		else
		{
			gSplit = 0; //A vfo
		}
		freqMemSplit[gMSel - 1] = gSplit; //comes from Dec_Edit_Data()
		freqMemTxLev[gMSel - 1] = gTxLev; //save these for the current mode
		freqMemLPFltr[gMSel - 1] = gLPFltr;
		freqMemNFltr[gMSel - 1] = gNFltr;

		Tx2HMI("bSave.txt=`Saving...`");
		Tx2HMI("bSave.txt=`Saving...`");
		SaveFreqList(gRadioSel + 1);
		hmiWait4Reply = 0;
		Tx2HMI("page FreqMem"); //switch pages after we process edit event
		hmiFreqMemStartAtPrev = 0xff; //reset so we update the table in FreqMem				
		hmiUpdateCtr = 0; //immediate display update	
		blockHMI = millis() + 1500;
		return true;
	}
	else
	{
		//clear record# - it's invalid
		Tx2HMI("Edit.b0.txt=`???`");
		Tx2HMI("Edit.b0.txt=`???`");
		return false;
	}	
}

void GetFromHMI(uint8_t cmdNum, String cmd)
{
	//send command to hmi to get value - if it fails, try again	
	//SerialOut(cmd + " #1", true);
	hmiWait4Reply = 0; //clear que
	Tx2HMI("");
	hmiWait4Reply = cmdNum;
	Tx2HMI(cmd);
	if (hmiWait4Reply == 0)
	{
		//no reply or data we asked for has changed, try again
		hmiWait4Reply = cmdNum;
		Tx2HMI(cmd);
		delay(5);
		SerialOut(cmd + "#2, hmiWait4Reply=" + String(hmiWait4Reply), true);
	}
}



void Tx2HMI(String txt)
{
	//if hmiWait4Reply = false, just tx and exit, otherwise it returns true if we got a reply, false if not
	//txt bytes from string and terminator to HMI

	static bool alreadyHr = false;
	static int hmiWaitQue; //holds the hmiWait4Reply flag for the que command

	if (txt == String(char(0)))
	{
		//reset que and send a single null
		hmiWait4Reply = 0;
		hmiTxQue = "";
		hmiWaitQue = 0;
	}

	//chk for que - if waiting cmd send it and que this one
	if (hmiTxQue.length() > 0)
	{
		String temp = txt; //save this command
		txt = hmiTxQue;
		hmiTxQue = temp;
		int wait = hmiWait4Reply; //save this too
		hmiWait4Reply = hmiWaitQue;
		hmiWaitQue = wait;
	}
	else if (txt.length() < 1)
	{
		//called without txt to chk for tx que commands
		if (hmiTxQue.length() > 0)
		{
			txt = hmiTxQue; //see if anything is pending
			hmiTxQue = ""; //reset que
			hmiWait4Reply = hmiWaitQue;
			hmiWaitQue = 0;
		}
		else
		{
			hmiWaitQue = 0;
			return;
		}
	}

	if (hmiTransparentMode == 0xfe || alreadyHr == true || ISRActive == true)
	{
		//we're busy, save cmd in que and try again
		//SerialOut("!!!! -----> Transparent mode enabled <-----", true);
		//SerialOut("transp=" + String(hmiTransparentMode) + ", alreadyHr= " + String(alreadyHr) + ", ISRActive= " + String(ISRActive), true);
		hmiTxQue = txt;
		return;
	}
	alreadyHr = true;

	unsigned int idx = 0;
	String temp = "";

	for (idx = 0; idx < txt.length(); idx++)
	{
		if (txt.charAt(idx) == '`')
		{
			hmiTx[idx] = '"'; //swap ' chr to " (i.e. use ' ' to define text, convert it to " ")
		}
		else
		{
			hmiTx[idx] = txt.charAt(idx);
		}
		temp += String(char(hmiTx[idx]));
	}

	hmiTx[idx] = 0xff;
	idx++;
	hmiTx[idx] = 0xff;
	idx++;
	hmiTx[idx] = 0xff;
	idx++;
	hmiTx[idx] = 0; //terminator

	//debug
#ifdef DEBUG_HMI_TX
	if (hmiWait4Reply != 0)
	{
		SerialOut("->  " + txt + " [" + String(idx) + "] hmiWait4Reply=" + String(hmiWait4Reply), true);
	}
	else
	{

		SerialOut(">>  " + temp + " [" + String(idx) + "] hmiWait4Reply=" + String(hmiWait4Reply), true);
	}

#endif

	if (!hmiRmt)
	{
		HMI.write(hmiTx, idx);
		HMI.flush(); //this blocks if waiting for tx
	}
	else
	{
		HMIR.write(hmiTx, idx);
		HMIR.flush();
	}

#ifdef DEBUG_HMI_TX_DATA
	if (txt.length() <= hmiBufMax && !gComMode)
	{
		Serial.write(hmiTx, idx);
		Serial.flush();
		SerialOut("\n", false);
	}
#endif // 

	delay(10);

	if (hmiWait4Reply == 0)
	{
		hmiNewMsg = 0;
		alreadyHr = false;
		return;
	}
	else
	{
		//wait for reply				
		unsigned long replyTmr = millis(); //start window for rx window

		while (hmiReplyTmrDefault > millis() - replyTmr)
		{
			int oldHMICtrlChange = 0;
			int activeDisp = 0;
			if (!hmiRmt)
			{
				activeDisp = HMI.available();
			}
			else
			{
				activeDisp = HMIR.available();
			}
			if (activeDisp)
			{
			LookAgn:
				delay(1);
				hmiNewMsg = 0;
				ChkHmiRx();//wait for reply								
				if (hmiNewMsg != 0)
				{
					DecHMICmd();
					if (hmiCtrlChange != 0)
					{
						oldHMICtrlChange = hmiCtrlChange;
						//SerialOut("saving hmiCtrlChange=" + String(hmiCtrlChange), true);
					}
					else if (oldHMICtrlChange != 0 && hmiCtrlChange == 0)
					{
						hmiCtrlChange = oldHMICtrlChange; //restore if zeroed out by double call to DecHMICmd()
						//SerialOut("restoring hmiCtrlChange to " + String(hmiCtrlChange), true);
					}
					delay(10);
					if (!hmiRmt)
					{
						activeDisp = HMI.available();
					}
					else
					{
						activeDisp = HMIR.available();
					}
					if (activeDisp)
					{
						if (hmiReplyTmrDefault < millis() - replyTmr)
						{
							replyTmr = millis();
							goto LookAgn;
						}
						hmiNewMsg = 0;
						hmiWait4Reply = 0; //no reply
					}
				}
				alreadyHr = false;
				return;
			}
		}
	}
	alreadyHr = false;
}


void UpdateHMIDisplay()
{
	//called from main loop - every 200 mSec check radio - update display every 600 mS 
	//update the HMI page here

	static uint32_t oldMillis = millis();

	uint8_t val = 0;

	//these detect changes in PCR1000 settings
	static bool oldPCRPwr = false;
	bool oldPCRDSP = gPCRDSP;
	bool oldPCRANtch = gPCRANch;

	String temp_rxM[11]; //string to hold current array
	static String old_rxM[11]; //previously uploaded array - compare to current - only upload if changed

	UpdateHMIEveryPoll(); //immediate actions 

	if (hmiUpdateTimerDefault < millis() - oldMillis)
	{		
		//chk the first part of this block every 150 mSec
		Tx2HMI(""); //chk que

		bool online = true;
		if (gRMode == gRModePrev)
		{
			//check radio if nothing has changed
			online = GetFreqMode(); //update freq & mode from radio
		}

		//if flex, check for ping replies
		if (gRadio == RADIO_TYPE_FLEX && gFlexLastReply < millis() - 5000)
		{
			online = false; //no ping reply in 5 seconds
		}

		//fail off if >3 no replies
		if (online == false)
		{
			radioOnline++;
			if (radioOnline > 254)
			{
				radioOnline = 255;
			}
		}
		else
		{
			radioOnline = 0; //reset counter
		}

		String info2 = ""; //combined data for iInfo2 field

		hmiUpdateCtr--;
		if (hmiUpdateCtr > 0)
		{
			return;
		}

		//Run the rest of this code every 3rd 150 mS poll
		//SerialOut("\n======= start = " + String(millis()) + "\n", true);
		//SerialOut("page =" + String(hmiPage), true);

		//send nulls the size of fft to HMI just in case we were left in transparrent mode when user switched pages
		if (hmiPage != HMI_HOME)
		{
			//this takes 5 mS to send 350 bytes to 5" display
			if (!hmiRmt)
			{
				HMI.write(fftFinal, gSize);
				HMI.flush();
			}
			else
			{
				HMIR.write(fftFinal, gSize);
				HMIR.flush();
			}

			delay(5);
		}
		Tx2HMI(String(char(0))); //this clears out the tx buffer and gives the hmi time to breathe so other commands will send ok

		hmiUpdateCtr = 3; //reset so the following code updates every 3 polls (450 msec)	

		if (gMyCall.length() == 0)
		{
			//keep trying until we get it			
			GetFromHMI(HMI_gMyCall, "get Config.gMyCall.txt");
		}

		//save radio after 60 seconds if anything has changed - this prevents saving radio on fast changing events
		if (gSvRadio != 0)
		{			
			saveRadioCntr++;
			savePrevCntr++;
			//chk for change to prev settings every 5 seconds or so
			if (savePrevCntr > 5)
			{
				ChkFreqModeChng();
				savePrevCntr = 0; // reset
			}

			if (saveRadioCntr > 75)
			{
				//a count of 75 gets us close to 60 seconds +/- 10 seconds
				gRadioSelPrev = gRadioSel; //just save it, no reload
				blockISR = true; //block ISR during file ops				
				SaveRadio(gRadioSel + 1); //gSvRadio will not reset if we exit SaveRadio() because we're in Tx mode	
				if (saveRadioCntr > 75)
				{
					//radio file was saved, saveRadioCtr won't be reset so save band list too
					SaveBandList(gRadioSel + 1);
				}
				saveRadioCntr = 0;
				savePrevCntr = 0;
				blockISR = false;
			}
		}
		else
		{
			saveRadioCntr = 0;
			savePrevCntr = 0;
		}

		//if selected radio is a PCR1000 and it hasn't been initialized yet, do it now
		if (gRadio == RADIO_TYPE_PCR1000 && (hmiPage == HMI_HOME || hmiPage == HMI_PCR))
		{
			val = PCR_Ping();
			if (val == 0)
			{
				//no power
				//Tx2HMI("PCR.gPwrSw.val=0");	//controls pwr button bco	
				//Tx2HMI("PCR.gPwrBtn.val=0");
				oldPCRPwr = false;
				gPCRInit = false;
			}
			else
			{

				//Tx2HMI("PCR.gPwrSw.val=1");				
				if (gPRCPwrBtn == false)
				{
					//powered up but rx is off
					gPCRInit = false;
					if (gPRCPwrBtn != oldPCRPwr)
					{
						PCR_Update(0);
					}
					oldPCRPwr = gPRCPwrBtn;
				}
				else
				{
					if (gPRCPwrBtn != oldPCRPwr)
					{
						//power button change
						PCR_Update(0);
					}
					oldPCRPwr = gPRCPwrBtn;
					if (gPCRInit == false && gPRCPwrBtn == true)
					{
						//just came on, set it up												
						PCR_Initialize();
					}
					else
					{
						//if we were powered up and pwr sw is turned off, turn off radio
						if (gPRCPwrBtn == false && gPCRInit == true)
						{
							PCR_Update(0);
						}
					}
				}
			}
		}

		//update specific items based on selected page
		//if a page doesn't require updating - send NULLS to is in case we called it while in Transparent mode
		switch (hmiPage)
		{
		case HMI_HOME:
			UpdateHomePage();
			break;
		case HMI_BAND:
			if (gRadio != gRadioPrev)
			{
				//selected radio changd by buttons
				SetRadioBaud();					
			}
			hmiWait4Reply = 0;
			Tx2HMI("gRadio=" + String(gRadio));
			Tx2HMI("gRadio=" + String(gRadio));
			delay(10);
			Tx2HMI("Band.tRadio.txt=`" + radioType[gRadio] + "`");
			Tx2HMI("Band.tRadio.txt=`" + radioType[gRadio] + "`");
			delay(10);
			if (gRadio == RADIO_TYPE_ICOM)
			{
				Tx2HMI("gBaud=" + String(radioBaud[gRadio]));
				Tx2HMI("Band.bIcmAdr.txt=`" + String(gIcmAdr, 2) + "`");
			}
			else
			{
				if (radioBaud[gRadio] != 0)
				{
					Tx2HMI("gBaud=" + String(radioBaud[gRadio]));
				}
			}
			//update ant boxes 
			for (int i = 0; i < bandMemMax; i++)
			{
				//convert ant value to ant number
				String temp = "";
				val = bandMemAnt[i];
				for (int j = 0; j < 8; j++)
				{
					if (val & 0x01)
					{
						if (temp.length() == 0)
						{
							temp = String(j + 1) + " " + String(bandMemAnt[i]); //save gAnt value for this band in last three digits
						}
						else
						{
							temp = "+ " + String(bandMemAnt[i]); //save gAnt value for this band in last three digits - multiple ants
							goto GetNext;
						}
					}
					val = val >> 1; //get next bit to check
				}
			GetNext:			Tx2HMI("Band.t" + String(i) + ".txt=`" + temp + "`");
			}
			break;
		case HMI_MODE:
			break;
		case HMI_CW:
			break;
		case HMI_RTTY:
			break;
		case HMI_DIG:
			break;
		case HMI_TXMEM:
			UpdateTxMem(hmiTxMemMode);
			break;
		case HMI_FREQMEM:			
			if (hmiFreqMemStartAt != hmiFreqMemStartAtPrev)
			{
				Tx2HMI("FreqMem.startAt.val=" + String(hmiFreqMemStartAt));
				Tx2HMI("FreqMem.startAt.val=" + String(hmiFreqMemStartAt));
				uint8_t temp = hmiFreqMemStartAt / 10; //calc hFrMem slider value - it's inverted from normal count
				temp = 10 - temp;
				Tx2HMI("FreqMem.hFrMem.val=" + String(temp));
				Tx2HMI("FreqMem.hFrMem.val=" + String(temp));

				//upload freq/mode to FreqMem page	
				int ptr = 0;
				int strt = (round((hmiFreqMemStartAt & 0xff) / 10) * 10); //make sure we start on a block; 
				for (int i = strt; i < strt + 10; i++)
				{
					String f = "";
					String r = "";
					String o = "";
					if (freqMemFreqA[i] > 100000)
					{
						if (freqMemSplit[i] == RADIO_VFO_SPLIT)
						{
							//split mode, load A and B into f
							f = String(freqMemFreqA[i]) + "+" + String(freqMemFreqB[i]);
						}
						else
						{
							f = String(freqMemFreqA[i]); //just main freq
						}
						r = radioRMdShort[freqMemRMode[i]]; //use shortend prefixes for radio and op mode
						o = radioOMdShort[freqMemOMode[i]];
					}
					//SerialOut(String(i + 1) + ": " + freqMemLabel[i], true);
					hmiWait4Reply = 0;
					Tx2HMI("FreqMem.t" + String(ptr) + ".txt=`" + String(i + 1) + "`");
					Tx2HMI("FreqMem.fL" + String(ptr) + ".txt=`" + freqMemLabel[i] + "`");
					Tx2HMI("FreqMem.fF" + String(ptr) + ".txt=`" + f + "`");
					Tx2HMI("FreqMem.fR" + String(ptr) + ".txt=`" + r + "`");
					Tx2HMI("FreqMem.fO" + String(ptr) + ".txt=`" + o + "`");
					ptr++;
				}
				hmiFreqMemStartAtPrev = hmiFreqMemStartAt; 
			}
			hmiUpdateCtr = 1;//force immediate updates
			break;
		case HMI_LOG:
			DisplayLog();
			break;
		case HMI_CONFIG:			
			hmiWait4Reply = 0;
			Tx2HMI("codeRev.txt=`" + version + "`");
			if (millis() - gDelLogTimer < 5000)
			{
				if (gDelLogClick == true)
				{
					Tx2HMI("bDelLog.txt=`Confirm DEL`");
				}
				else
				{
					Tx2HMI("bDelLog.txt=`Deleting Log`");
				}
			}
			else
			{
				Tx2HMI("bDelLog.txt=`Delete Log`");
				gDelLogClick = false; //reset 
			}

			if (gWiFi == 0)
			{
				Tx2HMI("bWiFi.txt=`Enable WiFi`");
				Tx2HMI("bWiFi.bco=BASEBCO");
			}
			else if (gWiFi == 1)
			{
				Tx2HMI("bWiFi.txt=`WiFi Enabled`");
				Tx2HMI("bWiFi.bco=HIBCO");
			}
			break;
		case HMI_KEYPAD:

			break;
		case HMI_RXMSG:
			blockISR = true;
			//save to temp so it doesn't get changed during ISR				
			for (int i = 0; i < 11; i++)
			{
				temp_rxM[i] = hmi_rxM[i];
			}
			blockISR = false;
			for (int i = 0; i < 11; i++)
			{
				if (temp_rxM[i] != old_rxM[i])
				{
					hmiWait4Reply = 0;
					Tx2HMI("rxM" + String(i) + ".txt=`" + temp_rxM[i] + "`");
					old_rxM[i] = temp_rxM[i];
					delay(20);
				}
			}
			break;
		case HMI_INPUT:
			ChkTxBuffer(); //see if we're transmitting chrs from keyboard
			break;
		case HMI_SAVELOG:
			break;
		case HMI_AUTOLOG:
			//update fields every 10 seconds
			if (hmiAutoLogUpdateDefault < millis() - hmiAutoLogUpdate)
			{
				UpdateAutoLog(); //update autolog fields from rx msg
				hmiAutoLogUpdate = millis();
			}
			break;
		case HMI_RADIO:
			ChkRJ45SwitchBoards(); //update radio boards

			if (gRadioSelNum > 15)
			{
				if (gShareDB != gShareDBPrev)
				{
					//update db		
					SaveRadioTags(); //save status change to file								
					Chk4FreqListFile();
					Chk4BandListFile(false); //don't erase band data
					Chk4TxMem();
					gShareDBPrev = gShareDB;
				}
				//write labels and change color of label to red if using shared DB				
				if (gRadioPopup == 0)
				{
					String txt = "";
					hmiWait4Reply = 0;
					for (int i = 0; i < 16; i++)
					{
						//SerialOut("radioTag " + String(i + 1) + "=" + radioTag[i], true);
						txt = radioTag[i];
						if (txt.charAt(0) == '*')
						{
							Tx2HMI("Radio.t" + String(i) + ".pco=RED");
						}
						else
						{
							Tx2HMI("Radio.t" + String(i) + ".pco=61277"); //non-shared is light gray
						}
						txt = txt.substring(1); //remove first chr - used to flag shared with '*' or not shared with ' '
						Tx2HMI("Radio.t" + String(i) + ".txt=`" + txt + "`");
						//SerialOut(txt, true);
					}
				}
				if (gRadioChange == 0xff)
				{
					EraseRadio();
					SaveRadio(gRadioSel + 1);
					gRadioSelPrev = gRadioSel + 1;//force reload to set hmi properties
					LoadRadio();
					hmi_bRx = "Rx:";
					Tx2HMI("Home.bRx.txt=`Rx:`");
					Tx2HMI("Home.bRx.txt=`Rx:`");
					Tx2HMI("page Home");
				}
				else if (gRadioChange > 0 && gRadioChange < 17)
				{
					//copy currently selected radio's setting to this radio
					Tx2HMI("page Home");//open hope page so user can see bRx.txt being updated with save info					
					//SerialOut("Saving Radio " + String(gRadioSel + 1) + " to Radio " + String(gRadioChange), true);
					radioTag[gRadioChange - 1] = radioTag[gRadioSel]; //match labels
					SaveRadioTags();
					SaveRadio(gRadioChange);
					delay(2000); //so user sees the saving radio note on bRx
					SaveBandList(gRadioChange);
					SaveFreqList(gRadioChange);
					SaveTxMem(gRadioChange);
					gRadioChange = 0;
					Tx2HMI("Radio.gChange.val=0");
					Tx2HMI("Radio.gChange.val=0");
					Tx2HMI("Radio.gChange.val=0");
				}
			}
			else
			{
				//label changed, update it and save array				
				GetFromHMI(HMI_RADIO_gSelTxt, "get Radio.gSelTxt.txt");
				if (gSelTxt.length() > 0)
				{
					//new label, update and save				
					if (gShareDB == true)
					{
						gSelTxt = "*" + gSelTxt; //flag shared db
					}
					else
					{
						gSelTxt = " " + gSelTxt; //not shared
					}
					//SerialOut("gSelTxt= " + gSelTxt, true);
					radioTag[gRadioSelNum] = gSelTxt;
					SaveRadioTags();
					gRadioSelNum = 0xff; //reset 
					gSelTxt = "";
					Tx2HMI("Radio.gSelNum.val=255"); //update labels next scan
					Tx2HMI("Radio.gSelNum.val=255");
					Tx2HMI("Radio.gSelTxt.txt=``");
					Tx2HMI("Radio.gSelTxt.txt=``");
				}
			}
			break;
		case HMI_PCR:
			//note: freq, mode, and bandwidth are set in TxFreq2Radio			
			if (gPCRInit == true)
			{
				String reply = "";

				//chk for changes by encoder before getting values from hmi
				if (gPCRVol != gPCRVolPrev && gPCREncoderChng == HMI_PCR_PG_VOL)
				{
					Tx2HMI("PCR.gVol.val=" + String(gPCRVol));
					Tx2HMI("PCR.gVol.val=" + String(gPCRVol));
					PCR_Update(1);
					gPCREncoderChng = 0;
					return; //let hmi catch up
				}
				if (gPCRSq != gPCRSqPrev && gPCREncoderChng == HMI_PCR_PG_SQ)
				{
					Tx2HMI("PCR.gSq.val=" + String(gPCRSq));
					Tx2HMI("PCR.gSq.val=" + String(gPCRSq));
					PCR_Update(2);
					gPCREncoderChng = 0;
					return; //let hmi catch up
				}
				if (gPCRIF != gPCRIFPrev && gPCREncoderChng == HMI_PCR_PG_IF)
				{
					Tx2HMI("PCR.gIF.val=" + String(gPCRIF));
					Tx2HMI("PCR.gIF.val=" + String(gPCRIF));
					PCR_Update(3);
					gPCREncoderChng = false;
					return; //let hmi catch up
				}
				if (gPCRDSPNR != gPCRDSPNRPrev && gPCREncoderChng == HMI_PCR_PG_DSPNR)
				{
					Tx2HMI("PCR.gDSPNR.val=" + String(gPCRDSPNR));
					Tx2HMI("PCR.gDSPNR.val=" + String(gPCRDSPNR));
					PCR_Update(4);
					gPCREncoderChng = false;
					return; //let hmi catch up
				}
				if (gPCRBW != gPCRBWPrev && gPCREncoderChng == HMI_PCR_PG_BW)
				{
					Tx2HMI("PCR.gBW.val=" + String(gPCRBW));
					Tx2HMI("PCR.gBW.val=" + String(gPCRBW));
					TxFreq2Radio(gFreqRadio); //this updates freq, mode, and bw on PCR																				
					SetOutputSource(0, true);
					gPCRBWPrev = gPCRBW;
					gPCREncoderChng = 0;
					return; //let hmi catch up
				}
				gPCREncoderChng = 0;

				if (gPCRVol != gPCRVolPrev)
				{
					PCR_Update(1);
					gPCRVolPrev = gPCRVol;
				}
				if (gPCRSq != gPCRSqPrev)
				{
					PCR_Update(2);
					gPCRSqPrev = gPCRSq;
				}
				if (gPCRIF != gPCRIFPrev)
				{
					PCR_Update(3);
					gPCRIFPrev = gPCRIF;
				}
				if (gPCRDSP != oldPCRDSP || gPCRANch != oldPCRANtch || gPCRDSPNR != gPCRDSPNRPrev)
				{
					PCR_Update(4);
					gPCRDSPNRPrev = gPCRDSPNR;
				}

				if (gPCRBW != gPCRBWPrev)
				{
					TxFreq2Radio(gFreqRadio); //this updates freq, mode, and bw on PCR	
					delay(50);
					SetOutputSource(0, true); //update audio path if bw changes						
					gPCRBWPrev = gPCRBW;
				}

				if (gPCRInit == false)
				{
					//return to normal scan
					//SerialOut("PCR Init finished", true);
					gPCRInit = true;
				}
				PCR_Update(0xff); //always update these				
			}
			break;
		case HMI_ANT:
			hmiWait4Reply = 0;
			Tx2HMI("Ant.bRadio.txt=`" + radioTag[gRadioSel] + "`");
			Tx2HMI("Ant.bRadio.txt=`" + radioTag[gRadioSel] + "`");

			if (!antSaveTag)
			{
				//update tags if nothing pending
				for (int i = 0; i < 8; i++)
				{
					Tx2HMI("Ant.b" + String(i) + ".txt=`" + radioTag[16 + i] + "`");
					delay(10);
				}
			}
			break;
		}
		//SerialOut("\n=== end = " + String(millis()) + "\n", true);

	//AUDIO PROCESSING TIME - UNCOMMENT TO VIEW DSP PROCESSING TIME ============================================
		//enable this code to check for max audio processing time in % of CPU time
		//int i = AudioProcessorUsageMax();
		//SerialOut("Max Audio Processing= " + String(i) + "%", true);

	//===========================================================================================================

		//reset timer for next update
		oldMillis = millis();
	}
}

void UpdateHMIEveryPoll()
{
	//update these data every poll

	static bool usingPTT; //goes true if using PTT to trigger audio record/playback so we can turn if off when PTT clears

	if (espTxQue.length() > 0)
	{
		//just check the que
		SerialOut("===================> Sending expTxQue: " + espTxQue, true);
		Tx2ESP(ESP_FLEX, "");
	}

	if (gVocal == true && hmiAnnounce != VOICE_SAY_None)
	{
		//this sequence is blocking - blockISR is turned on during playback
		//gVocal is set when encoder is clicked
		if (hmiAnnounce & VOICE_SAY_Freq)
		{
			Say_Freq();
		}
		if (hmiAnnounce & VOICE_SAY_gRMode)
		{
			Say_gRMode();
		}
		if (hmiAnnounce & VOICE_SAY_gOMode)
		{
			Say_gOMode();
		}
		blockISR = false; //make sure this is off
	}
	hmiAnnounce = VOICE_SAY_None; //always reset after speaking

	ChkRxSquelch(false); //chk to see if we're in rx mode and rx level below gSqGain

	//chk for expired PTT watchdog - turn it off if expired and set tx mode to idle	
	if (gTxModeSet2 > RADIO_TX_ENAB && (pttWatchDogDefault < (millis() - pttWatchDog)))
	{
		//turn off ptt but don't reset pttWatchDog, let next PTT action do that
		Tx2HMI("Home.bRx.txt=`PTT 3-Minute Timer Exceeded    `");
		digitalWrite(PTT_OUT, HIGH);
		gTxModeSet2 = RADIO_TX_ENAB;
		//SerialOut("pttWatchdog= " + String(pttWatchDog), true);
	}

	Chk4PageChange();

	if (hmiPage == HMI_HOME)
	{
		//check for changes

		if (gRadio != gRadioPrev)
		{
			//radio changed, set baud if needed			
			SetRadioBaud();			
		}

		if (gMSel != gMSelPrev && gLock == false)
		{
			if (gMSel == 0)
			{
				SerialOut("Resetting gMSel", true);
				//reset selected mem
				Tx2HMI("gMSel=0");
				Tx2HMI("gMSel=0");
				gMSelPrev = 0;				
			}
			else if (freqMemFreqA[gMSel - 1] < 100000)
			{
				//ignore bad values
				gMSel = gMSelPrev;
				SerialOut("Open memory slot - ignore", true);
			}
			else
			{				
				blockHMI = millis() + 2000; //let hmi settle
				//selected mem changed, update to new freq settings				
				gMSelPtr = gMSel; //so buttons work
				SerialOut("Updating Freq/Mode from record " + String(gMSel), true);
				gFreqRadio = freqMemFreqA[gMSel - 1];
				gFreqRadioPrev = 0; //force update
				ChkFreqChange();
				gVFOA = gFreqRadio;				
				if (freqMemFreqB[gMSel - 1] >= 100000)
				{
					gVFOB = freqMemFreqB[gMSel - 1];
					hmiWait4Reply = 0;
					Tx2HMI("gVFOB=" + String(gVFOB));
					Tx2HMI("gVFOB=" + String(gVFOB));
					Tx2HMI("gSplit=2"); //enable split
					Tx2HMI("gSplit=2");
					gSplit = RADIO_VFO_SPLIT;
					gLock = true;
					Tx2HMI("Home.btLock.val=1"); //lock radio in split mode
					Tx2HMI("Home.btLock.val=1");
				}

				//calculate band
				String txt = CalcBand();
				hmiWait4Reply = 0;			

				Tx2HMI("gBand=" + String(gBand));
				Tx2HMI("gBand=" + String(gBand));
				Tx2HMI("Home.bBand.txt=`" + txt + "`");
				Tx2HMI("Home.bBand.txt=`" + txt + "`");

				gOMode = freqMemOMode[gMSel - 1];
				SetOMode();

				gRMode = freqMemRMode[gMSel - 1];
				SetRMode();

				if (gOMode != MODE_CW && gOMode != MODE_BEACON)
				{
					gTxLev = freqMemTxLev[gMSel - 1];
					Tx2HMI("gTxLev=" + String(gTxLev));
					Tx2HMI("gTxLev=" + String(gTxLev));
				}

				gLPFltr = freqMemLPFltr[gMSel - 1];
				Tx2HMI("gLPFltr=" + String(gLPFltr));
				Tx2HMI("gLPFltr=" + String(gLPFltr));

				gNFltr = freqMemNFltr[gMSel - 1];
				Tx2HMI("gNFltr=" + String(gNFltr));
				Tx2HMI("gNFltr=" + String(gNFltr));

				//send mode to radio
				TxMode2Radio();

				SetTxPath();
				SetOutputSource(0, true); //revert to rx routing				
												
				SetFilterFreq(1); //set tone decoder for new mode				
				hmiWait4Reply = 0;
				if (freqMemSplit[gMSel - 1] == RADIO_VFO_SPLIT)
				{
					//force lock in split mode
					Tx2HMI("gSplit=2");
					Tx2HMI("gSplit=2");
				}
				//erase Home.bRx buffer - it may have beacon info in it
				hmi_bRx = "Rx:";
				Tx2HMI("Home.bRx.txt=`Rx:`");
				Tx2HMI("Home.bRx.txt=`Rx:`");
				delay(50);

				if (Vox_Det.available())
				{
					Vox_Det.read(); //burn first read so we don't key up on noise				
				}

				gMSel = 0;
				gMSelPrev = 0;

				//reset selected mem
				Tx2HMI("gMSel=0");
				Tx2HMI("gMSel=0");

				hmiAnnounce = VOICE_SAY_Freq + VOICE_SAY_gRMode + VOICE_SAY_gOMode; //say freq & modes				
			}
		}

		//keep radio, processor, and hmi in sync
		//radio has priority		
		if (gFreqRadio != gFreqRadioPrev && gFreqRadio >= 100000 && gLock == false)
		{			
			//don't change freq if split is selected			
			ChkFreqChange();
			gMSel = 0; //zero this so future calls to FreqMem page will work
			gMSelPrev = 0;
			if (radioOnline > 3 && gRadio != RADIO_TYPE_NONE)
			{
				//radio is offline - post msg
				hmiWait4Reply = 0;
				Tx2HMI("tInfo1.txt=`RADIO`");
				Tx2HMI("tInfo2.txt=`OFFLINE`");
			}
			hmiWait4Reply = 0;
			Tx2HMI("sleep=0"); //make sure it's awake
			Tx2HMI("sleep=0");

			//calculate band
			String txt = CalcBand();
			hmiWait4Reply = 0;
			Tx2HMI("gBand=" + String(gBand));
			Tx2HMI("gBand=" + String(gBand));
			//SerialOut("gBand= " + String(gBand), true);
			Tx2HMI("Home.bBand.txt=`" + txt + "`");
			Tx2HMI("Home.bBand.txt=`" + txt + "`");
			gFreqRadioPrev = gFreqRadio;

		}
		else if (gLock == true && gFreqRadio != gFreqRadioPrev)
		{
			//if we're locked, keep radio on locked freq
			uint32_t temp = gFreqRadio;//swap freqs
			gFreqRadio = gFreqRadioPrev;
			gFreqRadioPrev = temp;
			ChkFreqChange();
			gFreqRadioPrev = gFreqRadio;
		}

		if (gRadioSel != gRadioSelPrev)
		{
			blockISR = true; //block isr during file ops
			gSvRadio = 1; //use to see if we acutally saved the radio
			SaveRadio(gRadioSelPrev + 1); //save the previous radio before w load the new one
			if (gSvRadio == 0)
			{
				//we did, reset flag
				gRadioSelPrev = gRadioSel; //match them up
			}
			blockISR = false;
		}

		bool ptt = digitalRead(PTT_OUT);
		//chk for mode change or stuck txMode button
		if (gTxMode != gTxModeSet2 || (ptt == HIGH && gTxModeSet2 > RADIO_TX_ENAB))
		{
			if (ptt == HIGH && gTxModeSet2 > RADIO_TX_ENAB && gOMode != 0)
			{
				//button stuck, reset it if we're not in CW mode
				SerialOut("Stuck Tx button - resetting it", true);
				gTxModeSet2 = RADIO_TX_ENAB;
			}
			//mode changed, send new state to HMI
			gTxMode = gTxModeSet2; //set2 has the value we're changing to
			blockHMI = millis() + 1000; //so we don't bounce
			Tx2HMI("gTxMode=" + String(gTxMode));
			Tx2HMI("gTxMode=" + String(gTxMode));
			if (Vox_Det.available())
			{
				Vox_Det.read(); //burn first read so we don't key up on noise				
			}
		}

		//chk for stuck split mode
		if (gSplit == RADIO_VFO_SPLIT)
		{
			uint32_t temp = 0;
			if (gTxMode == RADIO_TX_ENAB)
			{
				temp = gVFOA; //we're normal in split, use vfoA
			}
			else if (gTxMode > RADIO_TX_ENAB)
			{
				temp = gVFOB; //we're txing split, use vfoB
			}
			if (temp != 0 && temp != gFreqRadio)
			{
				SerialOut("Changing freq from split", true);
				TxFreq2Radio(temp);
				Tx2HMI("gFreq=" + String(temp));
				Tx2HMI("gFreq=" + String(temp));
				gFreqRadio = temp;
			}
		}

		if (gAudioRecRx == true && gAudioMode == AUDIO_IDLE)
		{	
			SD_StartRecording();		
		}
	}

	if (hmiPage != HMI_CW)
	{
		//make sure this is always off unless we're on the CW page and btTuneTx is pressed
		btTuneTx = false;
	}

	if (gWiFi != gWiFiPrev && hmiInitialized == true)
	{
		SetESPState(gWiFi); //bWiFi button pressed, start wifi station
		SerialOut("Returned from setting ESP", true);

		if (gWiFi == true && gRadio == RADIO_TYPE_FLEX)
		{
			//go back to Flex page if we just opened WiFi
			Tx2HMI("page Flex");
		}
	}

	if (gCtstCtr != gCtstCtrPrev)
	{
		//SerialOut("Updating gCtstCtr to " + String(gCtstCtr), true);
		hmiWait4Reply = 0;
		Tx2HMI("gCtstCtr=" + String(int(gCtstCtr)));
		Tx2HMI("gCtstCtr=" + String(int(gCtstCtr)));
		gCtstCtrPrev = gCtstCtr;
	}

	//chk for changes to encoder every update
	if (hmiPage == HMI_HOME || hmiPage == HMI_BAND || hmiPage == HMI_CW || hmiPage == HMI_VOICE || hmiPage == HMI_RTTY || hmiPage == HMI_DIG || hmiPage == HMI_TXMEM
		|| hmiPage == HMI_FREQMEM || hmiPage == HMI_LOG || hmiPage == HMI_HELP || hmiPage == HMI_PCR || hmiPage == HMI_FLEX || hmiPage == HMI_AUDIO 
		|| hmiPage == HMI_ANT || hmiPage == HMI_LEVELS) 
	{

		//reset encoder if no activity
		if (gEncoder != 0 && (hmiEncoderTimeoutDefault < millis() - hmiEncoderTimeout))
		{
			gEncoder = 0; //revert back to idle	
			gEncoderPrev = 0xff; //force update below
		}

		if (gEncoder != gEncoderPrev && hmiPage != HMI_HELP)
		{
			//encoder press in help exits back to home
			hmiWait4Reply = 0;
			Tx2HMI("gEncoder=" + String(gEncoder));
			Tx2HMI("gEncoder=" + String(gEncoder));
			gEncoderPrev = gEncoder;
			hmiEncoderTimeout = millis();
		}

		if (hmiHelpPageDir != 0)
		{
			//help page changed by encoder
			hmiWait4Reply = 0;
			if (gEncoder == 1)
			{
				//encoder pressed, exit home
				gEncoder = 0;
				gEncoderPrev = 0xff; //force update
				Tx2HMI("page Home");
			}
			else if (hmiHelpPageDir == 1)
			{
				Tx2HMI("click bInc,0");
			}
			else
			{
				Tx2HMI("click bDec,0");
			}
			hmiHelpPageDir = 0;
		}

		if (hmiPage == HMI_AUDIO)
		{
			//update and execute audio control options			
			if (gAudioStartBtn == gAudioStartBtnPrev && gAudioStartBtn == false && (gAudioRecBtn == true || gAudioPlayBtn == true))
			{
				//use ptt to start recording or playback if we're idle
				if (!digitalRead(PDL_LEFT))
				{
					usingPTT = true;
					gAudioStartBtn = true;
					Tx2HMI("Audio.btStart.val=1");
					Tx2HMI("Audio.btStart.val=1");
				}
				else
				{
					usingPTT = false;
				}
			}
			if (gAudioStartBtn == true && usingPTT == true && digitalRead(PDL_LEFT))
			{
				//we are using PTT to control start button - it's off now so shut down
				usingPTT = false;
				gAudioStartBtn = false;
				Tx2HMI("Audio.btStart.val=0");
				Tx2HMI("Audio.btStart.val=0");
			}
			if (gAudioStartBtn != gAudioStartBtnPrev)
			{
				//start changed state
				if (gAudioStartBtn == true && gAudioPlayBtn == true)
				{
					//play on
					SerialOut("gAudioMode=" + String(gAudioMode), true);
					if (gAudioStartBtn == true && gAudioMode == AUDIO_IDLE)
					{
						String temp = "";
						if (gShareDB == false)
						{
							temp = String((gRadioSel + 1), HEX) + "-"; //add selected radio to file name
						}
						SD_StartPlaying("/TXMEM/VMSG" + temp + String(gAudioVMsg) + ".wav");
					}
				}
				else
				{
					//start button off
					if (gAudioMode == AUDIO_RECORD)
					{
						SD_StopRecording();					
					}
					else if (gAudioMode == AUDIO_PLAYBACK)
					{						
						SD_StopPlaying();
					}
					Tx2HMI("Audio.btStart.val=0");
					Tx2HMI("Audio.btStart.val=0");
				}
				gAudioStartBtnPrev = gAudioStartBtn;

			}
			//done playing selected, reset start btn
			if (gAudioMode == AUDIO_PLAYBACK && gAudioStartBtn == true && !playSdWav.isPlaying())
			{				
				Tx2HMI("Audio.btStart.val=0");
				Tx2HMI("Audio.btStart.val=0");
				Tx2HMI("Audio.btStart.txt=`Start`");
				Tx2HMI("Audio.btStart.txt=`Start`");
			}
		}
		if (hmiPage == HMI_FLEX)
		{
			if (gFlexPO != gFlexPOPrev)
			{
				//send new power to radio and update log power
				gFlexPOPrev = gFlexPO;
				String reply = Tx2ESP(ESP_FLEX, "|transmit s rfpower=" + String(gFlexPO));
				Tx2HMI("Flex.gFlexPO.val=" + String(gFlexPO));
				Tx2HMI("Flex.gFlexPO.val=" + String(gFlexPO));
				Tx2HMI("Home.bPwr.txt=`" + bPwr + "`");
				Tx2HMI("Home.bPwr.txt=`" + bPwr + "`");
			}
			if (gFlexTO != gFlexTOPrev)
			{
				//send new power to radio and update log power
				gFlexTOPrev = gFlexTO;
				String reply = Tx2ESP(ESP_FLEX, "|transmit s tunepower=" + String(gFlexTO));
				Tx2HMI("Flex.gFlexTO.val=" + String(gFlexTO));
				Tx2HMI("Flex.gFlexTO.val=" + String(gFlexTO));
			}
			if (gFlexLO != gFlexLOPrev)
			{
				//send new power to radio and update log power
				gFlexLOPrev = gFlexLO;
				String reply = Tx2ESP(ESP_FLEX, "|mixer lineout gain " + String(gFlexLO));
				Tx2HMI("Flex.gFlexLO.val=" + String(gFlexLO));
				Tx2HMI("Flex.gFlexLO.val=" + String(gFlexLO));
			}
			if (gFlexWNB != gFlexWNBPrev)
			{
				//update wide noise blanker
				if ((gFlexWNB & 0x7f) == 0)
				{
					gFlexWNB = 0;
					String reply = Tx2ESP(ESP_FLEX, "|slice s 0 wnb=0 wnb_level=0"); //turn it off
				}
				else
				{
					gFlexWNB |= 0x80; //force on					
					String reply = Tx2ESP(ESP_FLEX, "|slice s 0 wnb=1 wnb_level=" + String(gFlexWNB & 0x7f));
				}
				gFlexWNBPrev = gFlexWNB;
				Tx2HMI("Flex.gFlexWNB.val=" + String(gFlexWNB));
				Tx2HMI("Flex.gFlexWNB.val=" + String(gFlexWNB));
			}
			if (gFlexNB != gFlexNBPrev)
			{
				//update wide noise blanker
				if ((gFlexNB & 0x7f) == 0)
				{
					gFlexNB = 0;
					String reply = Tx2ESP(ESP_FLEX, "|slice s 0 nb=0 nb_level=0"); //turn it off
				}
				else
				{
					gFlexNB |= 0x80; //force on					
					String reply = Tx2ESP(ESP_FLEX, "|slice s 0 nb=1 nb_level=" + String(gFlexNB & 0x7f));
				}
				gFlexNBPrev = gFlexNB;
				Tx2HMI("Flex.gFlexNB.val=" + String(gFlexNB));
				Tx2HMI("Flex.gFlexNB.val=" + String(gFlexNB));
			}
			if (gFlexNR != gFlexNRPrev)
			{
				//update wide noise blanker
				if ((gFlexNR & 0x7f) == 0)
				{
					gFlexNR = 0;
					String reply = Tx2ESP(ESP_FLEX, "|slice s 0 nr=0 nr_level=0"); //turn it off
				}
				else
				{
					gFlexNR |= 0x80; //force on					
					String reply = Tx2ESP(ESP_FLEX, "|slice s 0 nr=1 nr_level=" + String(gFlexNR & 0x7f));
				}

				gFlexNRPrev = gFlexNR;
				Tx2HMI("Flex.gFlexNR.val=" + String(gFlexNR));
				Tx2HMI("Flex.gFlexNR.val=" + String(gFlexNR));
			}
			if (gFlexAF != gFlexAFPrev)
			{
				//update auto peaking filter								
				if ((gFlexAF & 0x7f) == 0)
				{
					gFlexAF = 0;
					if (gRMode < 2)
					{
						String reply = Tx2ESP(ESP_FLEX, "|slice s 0 apf=0 apf_level=0"); //turn it off
					}
					else
					{
						String reply = Tx2ESP(ESP_FLEX, "|slice s 0 anf=0 anf_level=0"); //turn it off
					}
				}
				else
				{
					gFlexAF |= 0x80; //force on					
					if (gRMode < 2)
					{
						String reply = Tx2ESP(ESP_FLEX, "|slice s 0 apf=1 apf_level=" + String(gFlexAF & 0x7f));
					}
					else
					{
						String reply = Tx2ESP(ESP_FLEX, "|slice s 0 anf=1 anf_level=" + String(gFlexAF & 0x7f));
					}
				}
				gFlexAFPrev = gFlexAF;
				Tx2HMI("Flex.gFlexAF.val=" + String(gFlexAF));
				Tx2HMI("Flex.gFlexAF.val=" + String(gFlexAF));
			}
		}
		if (hmiPage == HMI_ANT)
		{
			//watch for antenna and tag changes
			if (gAnt != gAntPrev)
			{
				SetAntSwitch(false);
				gAntPrev = gAnt;
			}
			if (antSaveTag > 0)
			{
				//antSaveTag has the # of the tag that changed (ones based), save Radio Labels
				SerialOut("antSaveTag=" + String(antSaveTag), true);
				GetFromHMI(HMI_ANT_saveTag, "get Ant.b" + String(antSaveTag - 1) + ".txt"); //tags will be saved when DecHMICmd() decodes this message
				/* this is done in Ant.tm0 event if saveTag=0
				Tx2HMI("Ant.b" + String(antSaveTag - 1) + ".bco=BASEBCO"); //reset highlight color
				Tx2HMI("Ant.b" + String(antSaveTag - 1) + ".bco=BASEBCO");
				//delay(10);
				Tx2HMI("Ant.b" + String(antSaveTag - 1) + ".pco=BASEPCO");
				Tx2HMI("Ant.b" + String(antSaveTag - 1) + ".pco=BASEPCO");
				*/
				antSaveTag = 0;
				Tx2HMI("Ant.saveTag.val=0"); //reset it now
				Tx2HMI("Ant.saveTag.val=0");
			}
		}
		if (hmiPage == HMI_LEVELS)
		{
			//update levels if encoder changes them
			if (uint8_t(gLnInLv) != gLnInLvPrev)
			{				
				hmiWait4Reply = 0;
				Tx2HMI("gLnInLv.val=" + String(uint8_t(gLnInLv)));
				Tx2HMI("gLnInLv.val=" + String(uint8_t(gLnInLv)));
				gLnInLvPrev = uint8_t(gLnInLv);
				//set line in amp				
				float g = gLnInLv - 49; //50 is unity
				if (g < 1.0)
				{
					//if less than 1 add attenuation
					g = ((g+50) * 2) / 100; //get % of how far below 1 we are
				}		
				Amp_In.gain(g);
				Amp_In.update();
			}
			if (uint8_t(gMicInLv) != gMicInLvPrev)
			{
				hmiWait4Reply = 0;
				Tx2HMI("gMicInLv.val=" + String(uint8_t(gMicInLv)));
				Tx2HMI("gMicInLv.val=" + String(uint8_t(gMicInLv)));
				gMicInLvPrev = uint8_t(gMicInLv);
				//going below 0 inverts the phase and amplifies
				float g = gMicInLv - 49; //50 is unity
				if (g < 1.0)
				{
					//if less than 1 add attenuation
					g = ((g + 50) * 2) / 100; //get % of how far below 1 we are
				}				
				Amp_Mic_In.gain(g);
				Amp_Mic_In.update();
			}
			if (uint8_t(gLnOutLv) != gLnOutLvPrev)
			{
				//SerialOut("Updating Output Level", true);
				hmiWait4Reply = 0;
				Tx2HMI("gLnOutLv.val=" + String(uint8_t(gLnOutLv)));
				Tx2HMI("gLnOutLv.val=" + String(uint8_t(gLnOutLv)));
				gLnOutLvPrev = uint8_t(gLnOutLv);
			}
			if (uint8_t(gUSBInLv) != gUSBInLvPrev)
			{
				hmiWait4Reply = 0;
				Tx2HMI("gUSBInLv.val=" + String(uint8_t(gUSBInLv)));
				Tx2HMI("gUSBInLv.val=" + String(uint8_t(gUSBInLv)));
				gUSBInLvPrev = uint8_t(gUSBInLv);
				float g = gUSBInLv - 49; //50 is unity
				if (g < 1.0)
				{
					//if less than 1 add attenuation
					g = ((g + 50) * 2) / 100; //get % of how far below 1 we are
				}				
				Amp_USB_In.gain(g);
				Amp_USB_In.update();
			}
			if (uint8_t(gUSBOutLv) != gUSBOutLvPrev)
			{
				hmiWait4Reply = 0;
				Tx2HMI("gUSBOutLv.val=" + String(uint8_t(gUSBOutLv)));
				Tx2HMI("gUSBOutLv.val=" + String(uint8_t(gUSBOutLv)));
				gUSBOutLvPrev = uint8_t(gUSBOutLv);
			}		
			if (uint8_t(gFFTLv) != gFFTLvPrev)
			{
				hmiWait4Reply = 0;
				Tx2HMI("gFFTLv.val=" + String(uint8_t(gFFTLv)));
				Tx2HMI("gFFTLv.val=" + String(uint8_t(gFFTLv)));
				gFFTLvPrev = uint8_t(gFFTLv);
				//change fft gain
				float g = gFFTGain + (gFFTLv - 50.0);
				if (g < 0)
				{
					g = LEV_OFF;
				}
				Amp_FFT.gain(g);
				Amp_FFT.update();	
				gFFTGainPrev = gFFTGain;
			}
		}
	}
}


void UpdateTxMem(uint8_t txMemMode)
{
	//update TxMem buffers to the op mode we're editing

	if (hmiTxMemCtr || txMemMode > 3)
	{
		//one or more of the buffers have changed, don't overwrite the group
		//or we're in beacon mode (4)
		return;
	}

	uint8_t offset = txMemMode * 10;

	if (txMemMode != 0xff)
	{
		for (int i = 0; i < 10; i++)
		{
			String temp = hmiTxMem[offset + i];
			hmiWait4Reply = 0;
			Tx2HMI("TxMem.gBuff" + String(i) + ".txt=`" + temp.trim() + "`"); //trim spaces
			//SerialOut("gBuff" + String(i) + ".txt=`" + temp.trim() + "`", true);
			delay(20);
		}
	}
}


void UpdateHomePage()
{
	bool match = false;
	String info2 = "";
	uint32_t infoBCO = 0; //background of tInfo labels
		
	if (hmi_bRx.length() > 0)
	{
		hmiWait4Reply = 0;
		Tx2HMI("bRx.txt=`" + hmi_bRx + "`");
	}

	//inc watchdog timer count
	hmiWait4Reply = 0;
	Tx2HMI("gWDog=" + String(gWDog));
	gWDog++;
	if (gWDog > 200)
	{
		gWDog = 1;
	}

	if (gShareDB != gShareDBPrev)
	{
		//load new settings - load new radio if needed, otherwise just update db	
		blockISR = true; //block decoding during file operations
		if (gRadioSel != gRadioSelPrev)
		{
			//SerialOut("Loading radio from Home - gRadioSel=" + String(gRadioSel) + ", gRadioSelPrev=" + String(gRadioSelPrev), true);
			LoadRadio();
		}
		else
		{
			Chk4FreqListFile(); //Chk4xxxx routines create a new file if none exist, or load the existing one
			Chk4BandListFile(false); //don't erase band data
			Chk4TxMem();
		}
		gShareDBPrev = gShareDB;
		blockISR = false;
	}

	ChkTxBuffer(); //see if we're transmitting from bTx.txt

	if (gAudioRecRx == true)
	{
		//we're recording, just service info1 & 2 and ignore the rest
		Tx2HMI("Home.tInfo1.txt=`STOP`");
		Tx2HMI("Home.tInfo2.txt=`RECORDING`");
		infoBCO = 63488; //red if recording
		goto ChkEncoderState;
	}
		
	//chk to see if the freq matches any stored memories				
	for (int i = 0; i < freqMemMax; i++)
	{
		if (freqMemFreqA[i] == gFreqRadio && freqMemOMode[i] == gOMode && freqMemRMode[i] == gRMode)
		{
			//on the selected memory freq, display label
			hmiWait4Reply = 0;
			Tx2HMI("tInfo1.txt=`" + freqMemLabel[i] + "`");
			hmiFreqMemStartAt = (round(i / 10) * 10) + 1; //move to top of list segment this freq is on						
			Tx2HMI("FreqMem.startAt.val=" + String(hmiFreqMemStartAt));
			match = true;
			gMSelPtr = i; //so mem btns work from this freq
			break;
		}
	}
	if (match == false)
	{
		hmiWait4Reply = 0;
		Tx2HMI("Home.tInfo1.txt=`" + radioTag[gRadioSel] + "`"); //display radio label
	}

	switch (gOMode)
	{
	case MODE_CW:
		if (decodeWPM == 0)
		{
			decodeWPM = 15;
		}
		info2 = String(gFFTFreq, 0) + "hz " + (String(decodeWPM) + "wpm");
		hmiWait4Reply = 0;
		Tx2HMI("tInfo2.txt=`" + info2 + "`");
		break;
	case MODE_VOICE:
		hmiWait4Reply = 0;
		Tx2HMI("tInfo2.txt=` `");
		break;
	case MODE_RTTY:
		hmiWait4Reply = 0;
		Tx2HMI("tInfo2.txt=`" + String(1000 / rttyBaud[gRtyBaud], 0) + " Baud`");
		break;
	case MODE_DIG:
		hmiWait4Reply = 0;
		Tx2HMI("tInfo2.txt=`Digital`");
		break;
	case MODE_BEACON:
		//chk for proper freq for band, calc time slot and update bRx to show location
		if (gFreqRadio != 14100000 && gFreqRadio != 18110000 && gFreqRadio != 21150000 && gFreqRadio != 24930000 && gFreqRadio != 28200000)
		{
			//we've moved off the beacon frequency - default to CW decode
			gOMode = 0;
			SetTxPath();
			gOModePrev = gOMode;
			hmiWait4Reply = 0;
			Tx2HMI("gOMode=0");
			Tx2HMI("gOMode=0");
			hmi_bRx = "Rx:";
			Tx2HMI("Home.bRx.txt=`Rx:`");//reset rx buffer
			Tx2HMI("Home.bRx.txt=`Rx:`");//reset rx buffer
			SetFilterFreq(2);
		}
		else
		{
			UpdateBeacon();
		}
		break;
	}		
		
ChkEncoderState:
	Tx2HMI("Home.tInfo1.bco=" + String (infoBCO)); //update info background incase they changed above
	Tx2HMI("Home.tInfo2.bco=" + String(infoBCO));

	if (gEncoder == HMI_HOME_PG_SPEED)
	{
		//option presented based on operating mode
		hmiWait4Reply = 0;
		switch (gOMode)
		{
		case MODE_VOICE:
TxLvl:		Tx2HMI("Home.bEncdr.txt=`TxLv" + String(gTxLev) + "`");
			Tx2HMI("Home.bEncdr.txt=`TxLv" + String(gTxLev) + "`");
			break;
		case MODE_RTTY:
			goto TxLvl;
			break;
		case MODE_DIG:
			goto TxLvl;
			break;
		default:
			//change encoder label for cw speed					
			Tx2HMI("Home.bEncdr.txt=`CWSp" + String(cTxSpeed) + "`");
			Tx2HMI("Home.bEncdr.txt=`CWSp" + String(cTxSpeed) + "`");
			break;
		}
	}
	else if (gEncoder == HMI_HOME_PG_LPFLTR)
	{
		//change encoder label for LP filter freq
		hmiWait4Reply = 0;
		Tx2HMI("Home.bEncdr.txt=`LP:" + String(gLPFltr * 100) + "`");
		Tx2HMI("Home.bEncdr.txt=`LP:" + String(gLPFltr * 100) + "`");

	}
	else if (gEncoder == HMI_HOME_PG_NFLTR)
	{
		//change encoder label for notch freq
		hmiWait4Reply = 0;
		Tx2HMI("Home.bEncdr.txt=`N:" + String(gNFltr * 100) + "`");
		Tx2HMI("Home.bEncdr.txt=`N:" + String(gNFltr * 100) + "`");
	}

	//Tx2HMI("Home.bRx.txt=`AudioMemMax=" + String(AudioMemoryUsageMax()) + "`");
}



void UpdateFFT()
{
	uint waitTmr = 0ul; //use in place of delay()

	if (fft1024_1.available() && hmiPage == HMI_HOME)
	{
		//always update the fftD array so it's current		
		hmiTransparentMode = 0; //so Tx2HMI() works
		for (int i = 0; i < 1024; i++)
		{
			if (gFFTAvg)
			{
				//average last three samples
				//took this out - too long of a delay to detect CW signals
				float temp = (fft2[i] + fft1[i] + fft1024_1.read(i)) / 3;
				fft2[i] = fft1[i]; // move down
				fft1[i] = temp;
			}
			else
			{
				//no averaging
				fft1[i] = fft1024_1.read(i);
			}
		}

		if (gEncoderChng)
		{
			ChkEncoderChng();
		}

		ChkChr2HMI(); //chk if decoded chr is ready for hmi

		ChkPCCmd();//chk for rx data on USB port - process incoming request from PC software

		ChkTxVox(); //chk for digital mode & tone

		Tx2HMI(""); //chks que

		//smooth the data by using 3 or 5 pixels per bin		
		//move converted real values into first array
		//for digital mode offset to start at 4th sample to align tones with WSJT-X
		int offset = 0;
		if (gOMode == MODE_DIG)
		{
			offset = 2;
		}
		for (int i = offset; i < 70 + offset; i++)
		{
			fftWave0[i - offset] = uint8_t(fft1[i] * 2000) & 0xff; //convert to drive waveform vertical and limit to 255 counts;
		}

		//now calculate the adjacent pixels 
		int diff = 0; //difference between the first real value and the second real value - plot the slope between them
		if (gSize == 35)
		{
			//use two smoothing values for fft with 210 pixels on 3.5" display
			for (int i = 0; i < 70; i++)
			{
				diff = (fftWave0[i + 1] - fftWave0[i]) / 3;
				fftWave1[i] = fftWave0[i] + diff;
				fftWave2[i] = fftWave1[i] + diff;
			}
		}
		else
		{
			//use four smoothing values for fft with 350 pixels on 5" display
			for (int i = 0; i < 70; i++)
			{
				diff = (fftWave0[i + 1] - fftWave0[i]) / 5;
				fftWave1[i] = fftWave0[i] + diff;
				fftWave2[i] = fftWave1[i] + diff;
				fftWave3[i] = fftWave2[i] + diff;
				fftWave4[i] = fftWave3[i] + diff;
			}
		}

		if (hmiFFTUpdateDefault <= millis() - hmiFFTUpdate)
		{
			hmiWait4Reply = 0;
			waitTmr = millis();
			while (20 > millis() - waitTmr)
			{
				//wait for 20 mS
			}
			if (HMI.available() || HMIR.available())
			{
				//get async block messege before continuing
				ChkHmiRx();
				hmiFFTUpdate = 0; //try again after we decode rx data
				return;
			}

			hmiTransparentMode = 0;
			hmiWait4Reply = HMI_ADDT;
			if (gSize == 35)
			{

				Tx2HMI("addt " + fftID + ",0,210"); //setup to send 210 bytes in transparent mode to 3.5" display- then send it 20 extra to make sure we get out of transparent mode
			}
			else
			{
				Tx2HMI("addt " + fftID + ",0,350"); //setup to send 350 bytes in transparent mode then send it 20 extra
			}
			
			waitTmr = millis();
			while (20 > millis() - waitTmr)
			{
				//wait for 20 mS for display to get ready for fft data
			}

			hmiNewMsg = 0;
			ChkHmiRx();
			if (hmiTransparentMode != 0xfe)
			{
				//not in transparent mode, wait another 100 mS
				hmiNewMsg = 0;
				ChkHmiRx();
			}

			if (hmiTransparentMode == 0xfe)
			{
				if (gSize == 35)
				{
					//build and send final array to 3.5" display
					{
						int ptr = 0;
						for (int i = 0; i < 70; i++)
						{
							fftFinal[ptr] = fftWave0[i];
							fftFinal[ptr + 1] = fftWave1[i];
							fftFinal[ptr + 2] = fftWave2[i];
							ptr += 3;
						}
						if (!hmiRmt)
						{
							HMI.write(fftFinal, 210); //send 20 more chrs than transparent mode is expecting to make sure we get out of it
							HMI.flush();
						}
						else
						{
							HMIR.write(fftFinal, 210);
							HMIR.flush();
						}

					}
				}
				else
				{
					//build and send final array to 5" display
					{
						int ptr = 0;

						for (int i = 0; i < 70; i++)
						{
							fftFinal[ptr] = fftWave0[i];
							fftFinal[ptr + 1] = fftWave1[i];
							fftFinal[ptr + 2] = fftWave2[i];
							fftFinal[ptr + 3] = fftWave3[i];
							fftFinal[ptr + 4] = fftWave4[i];
							ptr += 5;
						}
						if (!hmiRmt)
						{
							HMI.write(fftFinal, 350); //send 20 extra chrs to make sure we get out of transparent mode
							HMI.flush();
						}
						else
						{
							HMIR.write(fftFinal, 350);
							HMIR.flush();
						}
					}
				}				
				waitTmr = millis();
				while (50ul > millis() - waitTmr)
				{
					//wait for 50 mS to start
				}
			}		

			hmiNewMsg = 0;
			ChkHmiRx();
			if (hmiTransparentMode == 0xfe)
			{
				//still in transparent mode, wait another 100 mS
				hmiNewMsg = 0;
				ChkHmiRx();
			}
			ChkPCCmd();//chk for rx data on USB port - process incoming request from PC software
			ChkTxVox(); //chk for digital mode & tone							
			hmiFFTUpdate = millis();
			hmiTransparentMode = 0; //so Tx2HMI() works
		}
	}
}

void CalcFFTMarkers()
{
	//calculate cursor positions when changing modes
	//Calibration of fft pixels = (Tone Freq * (# pixeles / max fft freq)) - not sure why I had to use 220 and 366 for # of pixels to get alignment correct

	hmiFFTMarker1 = -1;
	hmiFFTMarker2 = -1; //out of range
	float scale = 0; //scale for display width
	if (gSize == 35)
	{
		scale = .06875; // 220/3200 centers 700 hz sidetone on cursor
	}
	else
	{
		scale = .114375; // 366/3200 centers 700 hz sidetone on cursor
	}
	if (gOMode == MODE_CW || gOMode == MODE_BEACON)
	{
		hmiFFTMarker1 = (gFFTFreq * scale); //compensate for width of control						
	}
	else if (gOMode == MODE_RTTY)
	{
		hmiFFTMarker1 = (rttyFreq[gRtyFrq] * scale) + 4; //add padding to fine tune					
		if (gRtyFrq == RTTY_FREQ_2125)
		{
			hmiFFTMarker2 = hmiFFTMarker1 + (rttyShift[gRtySft] * scale);
		}
		else
		{
			hmiFFTMarker2 = hmiFFTMarker1 - (rttyShift[gRtySft] * scale);
		}
	}
}


void UpdateFFTMarkers()
{
	//draw freq cursors and filter marks on FFT
	//update freq detect markers if in CW or RTTY mode			
	uint32_t waitTmr = millis();

	if ((hmiFFTMarkerUpdateTimerDefault <= (millis() - hmiFFTMarkerUpdate)) && hmiPage == HMI_HOME)
	{
		hmiTransparentMode = 0; //so Tx2HMI() works
		hmiWait4Reply = 0;

		CalcFFTMarkers();


		if (gEncoder == HMI_HOME_PG_LPFLTR)
		{
			Tx2HMI("Home.bEncdr.txt=`LP:" + String(gLPFltr * 100) + "`");
		}
		else if (gEncoder == HMI_HOME_PG_NFLTR)
		{
			Tx2HMI("Home.bEncdr.txt=`N:" + String(gNFltr * 100) + "`");
		}


		//redraw decode freq pointer	
		if (HMI.available() || HMIR.available())
		{
			//get async block messege before continuing
			ChkHmiRx();
			hmiFFTMarkerUpdate = 0; //try again after we decode rx data
			return; //don't continue
		}
		hmiFFTMarkerUpdate = millis(); //reset time for next update
		hmiTransparentMode = 0;
		if (gOMode == MODE_VOICE || gOMode == MODE_DIG)
		{
			//just erase the decoder marker			
			Tx2HMI("cle " + fftID + ",1");
		}
		else
		{
			//plot decoder markers
			hmiWait4Reply = HMI_ADDT;
			if (gSize == 35)
			{
				//load fftFinal[] so we can send it with one command
				for (int i = 0; i < 210; i++)
				{
					if (i == hmiFFTMarker1 || i == hmiFFTMarker2) // tuning indicators - 2 pixels wide
					{
						fftFinal[i] = 70;
					}
					else
					{
						fftFinal[i] = 0;
					}
				}
				//now add 20 additional 0's to make sure we clear transparent mode
				Tx2HMI("addt " + fftID + ",1,210"); //update freq detect marker for 3.5" display then send 20 extra chrs to make sure we exit transparent mode
			}
			else
			{
				for (int i = 0; i < 350; i++)
				{
					if (i == hmiFFTMarker1 || i == hmiFFTMarker2) // tuning indicators - 2 pixels wide
					{
						fftFinal[i] = 116;
					}
					else
					{
						fftFinal[i] = 0;
					}
				}
				Tx2HMI("addt " + fftID + ",1,350"); //update freq detect marker for 5" display
			}

			waitTmr = millis();
			while (20 > millis() - waitTmr)
			{
				//wait for 20 mS for display to get ready for fft data
			}

			hmiNewMsg = 0;
			ChkHmiRx();

			if (hmiTransparentMode != 0xfe)
			{
				//still in transparent mode, wait another 100 mS
				hmiNewMsg = 0;
				ChkHmiRx();			
			}

			if (gSize == 35)
			{
				//3.5" display
				if (!hmiRmt)
				{
					HMI.write(fftFinal, 210);
					HMI.flush();
				}
				else
				{
					HMIR.write(fftFinal, 210);
					HMIR.flush();
				}
			}
			else
			{
				//5" display
				if (!hmiRmt)
				{
					HMI.write(fftFinal, 350);
					HMI.flush();
				}
				else
				{
					HMIR.write(fftFinal, 350);
					HMIR.flush();
				}

			}

			//wait for transparent flag to clear
			if (hmiTransparentMode == 0xfe)
			{
				//still in transparent mode, wait another 100 mS				
				hmiNewMsg = 0;
				ChkHmiRx();	
			}
		}

		// *****************************************************************************************************************************

		//redraw notch marker (chan2) if notch is < 30 (3000 hz)	
		if (HMI.available() || HMIR.available())
		{
			//get async block messege before continuing
			ChkHmiRx();
			hmiFFTMarkerUpdate = 0; //try again after we decode rx data
			return; //don't continue
		}


		if ((gLPFltr == 32 && gNFltr == 32) || (gOMode == MODE_DIG && gDigProc == false ))
		{
			//just erase the filter markers	if out of range or we're not using them in Dig	
			Tx2HMI("cle " + fftID + ",2");
		}
		else
		{
			//plot filter markers
			hmiTransparentMode = 0;
			hmiWait4Reply = HMI_ADDT;

			if (gSize == 35)
			{
				int roof = (gLPFltr * 7) - 6; //try to line up with vertial lines
				int notch = gNFltr * 7;
				for (int i = 0; i < 210; i++)
				{
					if (i == notch - 6 || i == notch - 3 || i == notch || i == roof) // roof = single line, notch = 3 lines
					{
						fftFinal[i] = 70;
					}
					else
					{
						fftFinal[i] = 0;
					}
				}
				Tx2HMI("addt " + fftID + ",2,210"); //update notch freq marker for 3.5" display
			}
			else
			{
				int roof = (gLPFltr * 11) + 4; //try to line up with vertial lines
				int notch = (gNFltr * 11) + 8;
				for (int i = 0; i < 350; i++)
				{
					if (i == notch - 6 || i == notch - 3 || i == notch || i == roof) // roof = single line, notch = 3 lines
					{
						fftFinal[i] = 116;
					}
					else
					{
						fftFinal[i] = 0;
					}
				}
				Tx2HMI("addt " + fftID + ",2,350"); //update notch freq marker for 5" display
			}	

			waitTmr = millis();
			while (20 > millis() - waitTmr)
			{
				//wait for 20 mS for display to get ready for fft data
			}

			hmiWait4Reply = 0;
			ChkHmiRx();
			if (hmiTransparentMode != 0xfe)
			{
				//still in transparent mode, wait another 100 mS
				hmiNewMsg = 0;
				ChkHmiRx();				
			}

			if (gSize == 35)
			{
				if (!hmiRmt)
				{
					HMI.write(fftFinal, 210); //see decoder marker
					HMI.flush();
				}
				else
				{
					HMIR.write(fftFinal, 210);
					HMIR.flush();
				}
			}
			else
			{
				if (!hmiRmt)
				{
					HMI.write(fftFinal, 350);
					HMI.flush();
				}
				else
				{
					HMIR.write(fftFinal, 350);
					HMIR.flush();
				}

			}

			hmiNewMsg = 0;
			ChkHmiRx();
			if (hmiTransparentMode == 0xfe)
			{			
				//still in transparent mode, wait another 100 mS
				hmiNewMsg = 0;
				ChkHmiRx();			
			}
			hmiTransparentMode = 0; //so Tx2HMI() works
		}
	}
}

void UpdateAutoLog()
{
	//search rx msg and extract any call sign or rst found. Send them to AutoLog
	String rx = ""; //load all hmi_rxMx() buffers into this string then search it for anything that looks like a call or RST
	int callPtr = 0;
	int rstPtr = 0;
	String txt = "";
	String temp = "";
	String call[9] = { "", "", "", "", "", "", "", "","" };
	String rst[9] = { "", "", "", "", "", "", "", "","" };


	//combine hmi_rxM array into one so we can work with it
	for (int i = 0; i < 11; i++)
	{
		txt = hmi_rxM[i];
		if (txt.length() > 0)
		{
			rx += txt;
		}
	}

	//SerialOut(rx, true);

	//look for call signature - must be chrs with at least on number brackedt by spaces
	//ignore '5nn' as a call
	for (unsigned int i = 0; i < rx.length(); i++)
	{
		//must be number or alpha cr or /, otherwise, ignore
		char chr = rx.charAt(i);
		if ((chr >= '0' && chr <= '9')
			|| (chr >= 'a' && chr <= 'z')
			|| (chr == '/')
			|| (chr == ' '))
		{
			//start at space
			if (chr == ' ' && callPtr < 9)
			{
				txt = "";
				temp = "";
				for (unsigned int j = i + 1; j < i + 16; j++)
				{
					if (j < rx.length())
					{
						chr = rx.charAt(j);
						temp = chr;
						temp.toLowerCase();
						if (chr != ' '
							&& ((chr >= '0' && chr <= '9')
								|| (chr >= 'a' && chr <= 'z')
								|| (chr == '/')))
						{
							txt += temp;
						}
						else
						{
							//SerialOut("found " + txt, true);
							break;
						}
					}
				}
				if (txt.length() > 2)
				{
					//call must be 3 or more chrs and have at least one number
					//SerialOut("checking " + txt + " ", true);
					unsigned int numCtr = 0;
					for (unsigned int j = 0; j < txt.length(); j++)
					{
						if (txt.charAt(j) >= '0' && txt.charAt(j) <= '9')
						{
							numCtr++;
						}
					}
					//SerialOut("numCtr= " + String(numCtr), true);
					//call must have one or two numbers and have at least 2 alpha chrs
					if (numCtr > 0 && numCtr < 4 && (numCtr + 2) <= txt.length())
					{
						bool dup = false;
						//check for existing dup
						for (int j = 0; j < callPtr + 1; j++)
						{
							if (txt == call[j])
							{
								dup = true;
								//SerialOut("dup with #" + String(j) + " - " + txt, true);
							}
						}
						//if not a dup, accept this one if it's not an abreviated RST
						if (dup == false && txt != "5nn")
						{
							call[callPtr] = txt;
							callPtr++;
							i += txt.length();
						}
					}
				}
			}
		}
	}


	//for RST we're looking for just three numbers bracketed by spaces
	//ignore spaces between numbers	
	char chr = 0;
	String rx1 = ""; //stripped out extra spaces between numbers
	bool lastWasNum = false; //true when last digit saved was a number
	txt = "";

	//strip out spaces between numbers
	for (unsigned int i = 0; i < rx.length(); i++)
	{
		chr = rx.charAt(i);
		if (chr == ' ' && lastWasNum == false)
		{
			rx1 += chr;
			txt = "";
		}
		else if (lastWasNum == false && chr >= '1' && chr <= '5')
		{
			lastWasNum = true;
			rx1 += chr;
			txt += chr;
		}
		else if (chr >= '1' && chr <= '9' && lastWasNum == true)
		{
			rx1 += chr;
			txt += chr;
			if (txt.length() == 3)
			{
				txt = "";
				rx1 += " "; //add a space
				lastWasNum = false;
			}
		}
		else if (chr != ' ')
		{
			if (lastWasNum == true && chr == 'n' && txt.length() < 3)
			{
				//convert 'n' to 9 if last digit was a number
				rx1 += "9"; //leave lastWasNum true
				txt += "9";
				if (txt.length() == 3)
				{
					txt = "";
					rx1 += " "; //add a space
					lastWasNum = false;
				}
			}
			else
			{
				rx1 += chr;
				txt = "";
				lastWasNum = false;
			}
		}

	}

	if (rx1.length() > 4)
	{
		for (unsigned int i = 0; i < (rx1.length() - 2); i++)
		{
			chr = rx1.charAt(i);
			if (chr == ' ' && txt.length() == 0)
			{
				//look for three numbers in a row - first number is 1-5, others are 1-9
				i++;
				chr = rx1.charAt(i);
				if ((chr >= '1' && chr <= '5'))
				{
					txt += chr; //first number
					i++;
					chr = rx1.charAt(i);
					if ((chr >= '1' && chr <= '9'))
					{
						txt += chr; //second number						
						i++;
						chr = rx1.charAt(i); //look for third number
						if ((chr >= '1' && chr <= '9'))
						{
							txt += chr; //third number
							i++;
						}
					}
				}
			}

			//now check to see if this is a dup
			if (txt.length() == 3)
			{
				bool dup = false;
				for (int j = 0; j < rstPtr; j++)
				{
					if (txt == rst[j])
					{
						//ignore this one
						dup = true;
					}
				}
				if (dup == false)
				{
					rst[rstPtr] = txt; //save it
					rstPtr++;
				}

			}
			txt = "";
		}
	}

	//now update AutoLog files with found RSTs	
	for (int i = 0; i < callPtr; i++)
	{
		if (call[i].length() > 0)
		{
			Tx2HMI("AutoLog.bS" + String(i) + ".txt=`" + call[i] + "`");
			Tx2HMI("vis bS" + String(i) + ",1"); //turned off by hmi when page opens			
		}
	}

	for (int i = 0; i < rstPtr; i++)
	{
		if (rst[i].length() > 0)
		{
			Tx2HMI("AutoLog.bRS" + String(i) + ".txt=`" + rst[i] + "`"); //send to both lists since we don't know which list it belongs to
			Tx2HMI("AutoLog.bRR" + String(i) + ".txt=`" + rst[i] + "`");
			Tx2HMI("vis bRS" + String(i) + ",1"); //turned off by hmi when page opens			
			Tx2HMI("vis bRR" + String(i) + ",1");
		}
	}
}

void UpdateEditPage()
{
	//We just opened the Edit page from the Home page using V>M
	//save current freq & mode to radioMemXXXX[] if not already the in last mem ptr				
	int saveAt = -1;
	for (int i = 0; i < freqMemMax; i++)
	{
		if ((freqMemFreqA[i] == gFreqRadio) && (freqMemRMode[i] == gRMode) && (freqMemOMode[i] == gOMode))
		{
			//if dup of existing memory, select that ptr
			//dup = true;
			saveAt = i;
			goto SaveMem;
			break;
		}
	}

	//find next empty mem bin					
	for (int i = 0; i < freqMemMax; i++)
	{
		if (freqMemFreqA[i] == 0)
		{
			saveAt = i;
			break;
		}
	}
	if (saveAt >= freqMemMax)
	{
		//save to end
		saveAt = freqMemMax - 1;
	}
SaveMem:
	if (saveAt != -1)
	{
		hmiFreqMemStartAt = saveAt;
	}

	SerialOut("Record#=" + String(hmiFreqMemStartAt + 1), true);
	//add current settings to Edit page and set up to save

	//Edit.tm0 copies these values to global variablesin FreqMem page
	hmiWait4Reply = 0;
	Tx2HMI("FreqMem.startAt.val=" + String(hmiFreqMemStartAt)); //so we know where to start the table at on exit from Edit page
	Tx2HMI("FreqMem.startAt.val=" + String(hmiFreqMemStartAt));
	delay(100);
	if (gShareDB == false)
	{
		Tx2HMI("Edit.tHdr.txt=`Add/Edit Entry to Radio " + String(gRadioSel + 1) + " Freq List`");
		Tx2HMI("Edit.tHdr.txt=`Add/Edit Entry to Radio " + String(gRadioSel + 1) + " Freq List`");
	}
	else
	{
		Tx2HMI("Edit.tHdr.txt=`Add/Edit Entry to Shared Freq List`");
		Tx2HMI("Edit.tHdr.txt=`Add/Edit Entry to Shared Freq List`");
	}
	delay(100);
	Tx2HMI("Edit.rtnPg.val=" + String(HMI_FREQMEM)); //set return page to freqmem
	Tx2HMI("Edit.rtnPg.val=" + String(HMI_FREQMEM));
	delay(100);
	Tx2HMI("Edit.b0.txt=`" + String(hmiFreqMemStartAt + 1) + "`"); //record #
	Tx2HMI("Edit.b0.txt=`" + String(hmiFreqMemStartAt + 1) + "`");
	delay(100);
	String txt = freqMemLabel[hmiFreqMemStartAt];
	if (txt.length() == 0)
	{
		Tx2HMI("Edit.b1.txt=``"); //no label
		Tx2HMI("Edit.b1.txt=``");
	}
	else
	{
		Tx2HMI("Edit.b1.txt=`" + txt + "`");
		Tx2HMI("Edit.b1.txt=`" + txt + "`");
	}
	delay(100);
	Tx2HMI("Edit.b2.txt=`" + String(gFreqRadio) + "`"); //freq
	Tx2HMI("Edit.b2.txt=`" + String(gFreqRadio) + "`");
	delay(100);
	Tx2HMI("Edit.b3.txt=`" + radioRMdShort[gRMode] + "`"); //radio mode
	Tx2HMI("Edit.b3.txt=`" + radioRMdShort[gRMode] + "`");
	delay(100);
	Tx2HMI("Edit.b4.txt=`" + radioOMdShort[gOMode] + "`");
	Tx2HMI("Edit.b4.txt=`" + radioOMdShort[gOMode] + "`");
	delay(100);
	Tx2HMI("Edit.b6.txt=`" + String(gVFOB) + "`"); //split tx freq in case we need it
	Tx2HMI("Edit.b6.txt=`" + String(gVFOB) + "`");
	delay(100);
	//set split button
	if (gSplit == RADIO_VFO_SPLIT)
	{
		Tx2HMI("Edit.bt5.val=1");
		Tx2HMI("Edit.bt5.val=1");
	}
	else
	{
		Tx2HMI("Edit.bt5.val=0");
		Tx2HMI("Edit.bt5.val=0");
	}
}


void UpdateBeacon()
{
	//update beacon info
	//chk for proper freq first
	uint32_t beaconFreq = 14100000; //default - change depending on band
	static int oldSlot = 0; //tracks last slot displayed, change display if slot changes
	static uint32_t oldMin = hmiRTCMin;
	static uint32_t oldSec = hmiRTCSec;

	if (hmiRTCMin == 0xff || hmiRTCSec == 0xff || (oldMin == hmiRTCMin && oldSec == hmiRTCSec))
	{
		return; //wait for TxHome info to update
	}

	oldMin = hmiRTCMin;
	oldSec = hmiRTCSec;

	//update info2 line to show code speed and fft freq (we are in CW mode)
	String info2 = String(gFFTFreq, 0) + "hz " + (String(decodeWPM) + "wpm");
	hmiWait4Reply = 0;
	Tx2HMI("tInfo2.txt=`" + info2 + "`");

	float ts = float((hmiRTCMin * 60) + hmiRTCSec) / 180;
	int slot = fmod(ts, 1) * 18; //get remainder multiplied by # of time slots
	//SerialOut("Min= " + String(hmiRTCMin) + ", Sec= " + String(hmiRTCSec) + ", ts= " + String(ts)+", slot= " + String(slot), true);

	if (gFreqRadio >= 18068000 && gFreqRadio <= 18168000)
	{
		beaconFreq = 18110000;
		slot -= 1;
	}
	else if (gFreqRadio >= 21000000 && gFreqRadio <= 21450000)
	{
		beaconFreq = 21150000;
		slot -= 2;
	}
	else if (gFreqRadio >= 24890000 && gFreqRadio <= 24990000)
	{
		beaconFreq = 24930000;
		slot -= 3;
	}
	else if (gFreqRadio >= 28000000 && gFreqRadio <= 29700000)
	{
		beaconFreq = 28200000;
		slot -= 4;
	}

	if (beaconFreq != gFreqRadio)
	{
		//set freq
		gFreqRadio = beaconFreq; //this will cause an update on the next HMI disply update	
	}
	if (slot < 0)
	{
		slot = slot + 18;
	}

	//only update station if slot changes - so we can display decoded call sign if rxd
	if (slot != oldSlot)
	{
		hmi_bRx = " Active Beacon: " + beaconList[slot] + ": "; //append new beacon name to bRx
		if (hmi_bRx.length() > hmi_bRx_max)
		{
			//trim it to fit
			hmi_bRx = hmi_bRx.substring(hmi_bRx.length() - hmi_bRx_max);
		}

		Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
		Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
	}

	oldSlot = slot;
}




void DisplayLog()
{
	//we're on the Log page, display 10 lines depending on position of h1 slider
	int start = 0;

	hmiWait4Reply = 0;
	if (gLogNumEntries < 11)
	{
		Tx2HMI("Log.h1.maxval=1");
	}
	else
	{
		Tx2HMI("Log.h1.maxval=" + String(gLogNumEntries));
	}

	if (gLogNumEntries <= 10)
	{
		hmiLogOffset = 0; //no need to scroll		
		goto List;
	}
	start = gLogNumEntries - hmiLogOffset - 10;
	if (start > 10)
	{
		start = start - 10; //start 9 entry's behind 
		if (start < 0)
		{
			start = 0;
		}
	}
	else if (start < 0)
	{
		start = 10 + start;
	}


List:

	int j = 0;
	for (int i = start; i < start + 10; i++)
	{
		Tx2HMI("Log.t" + String(j) + ".txt=`" + logList[i] + "`");
		j++;
	}
	if (hmiLogOffset == 0)
	{
		Tx2HMI("Log.t10.txt=`========================= End of Log =========================`");
	}
	else
	{
		Tx2HMI("Log.t10.txt=`====================== Scroll for More =======================`");
	}
}



void Chk4BandChange()
{
	//do this if band changes from hmi
	if (gBand != gBandPrev && gLock == false)
	{
		//NOTE:
		//  Band settings will only be changed when a new band is selected on the HMI because CalcBand overwrites the gBandPrev setting
		//  This is by design to minimize the amount of writes to the SD card
		//
		SerialOut("\nChk4Bandhange(): gBand=" + String(gBand) + ", gBandPrev=" + String(gBandPrev), true);
		//save current band freq and load freq for new band
		if (gTxModeSet2 > RADIO_TX_ENAB)
		{
			gTxModeSet2 = RADIO_TX_ENAB; //turn off tx if it was on
		}
		bandMemFreq[gBandPrev] = gFreqRadio;
		bandMemOMode[gBandPrev] = gOMode;
		bandMemRMode[gBandPrev] = gRMode;
		bandMemTxLev[gBandPrev] = gTxLev;
		bandMemLPFltr[gBandPrev] = gLPFltr;
		bandMemNFltr[gBandPrev] = gNFltr;
		//now load new band params		
		gFreqRadio = bandMemFreq[gBand];
		//gFreqRadioPrev = 0; //force update		
		SerialOut("gFreqRadio=" + String(gFreqRadio) + ", gBand=" + String(gBand) + ", gBandPrev=" + String(gBandPrev), true);
		//check freq is within the band - if not, load default freq		
		gBandPrev = gBand;
		String txt = CalcBand(); //calc gBand for this freq
		if (gBand != gBandPrev)
		{
			SerialOut("WRONG BAND - SETTING TO " + String(gBandPrev), true);
			//if freq in band register is out of band, something's wrong, load default freq for this band
			gBand = gBandPrev; //get default freq new band
			gFreqRadio = defaultMemFreq[gBand];
			txt = CalcBand();
		}
		SerialOut("Updating radio from band change to " + txt, true);
		Tx2HMI("gBand=" + String(gBand));
		Tx2HMI("gBand=" + String(gBand));
		Tx2HMI("Home.bBand.txt=`" + txt + "`");
		Tx2HMI("Home.bBand.txt=`" + txt + "`");
		ChkFreqChange();
		gOMode = bandMemOMode[gBand];
		SetOMode();
		gTxModeSet2 = RADIO_TX_OFF; //disable tx mode
		gRMode = bandMemRMode[gBand];
		SetRMode();
		gSvRadio = 0;		
		gTxLev = bandMemTxLev[gBand];
		gLPFltr = bandMemLPFltr[gBand];
		gNFltr = bandMemNFltr[gBand];
		SaveBandList(gRadioSel + 1);			
		SetTxPath();
		SetFilterFreq(5);
		SetOutputSource(0, true);
		gBandPrev = gBand;
		hmiUpdateCtr = 0;		

		if (Vox_Det.available())
		{
			Vox_Det.read(); //burn first read so we don't key up on noise				
		}

		blockHMI = millis() + 1000;

		hmiAnnounce = VOICE_SAY_Freq + VOICE_SAY_gRMode + VOICE_SAY_gOMode;
	}
}

void DeleteLog()
{
	//delete both log files
	gDelLogClick = false;
	gDelLogTimer = 0;
	hmiWait4Reply = 0;

	Tx2HMI("bDelLog.txt=`Deleting Log`");

	if (SD.exists("/LOG/CTR2_LOG.ADI"));
	{
		SD.remove("/LOG/CTR2_LOG.ADI");
		delay(1000);
	}
	if (SD.exists("/LOG/CTR2_LOG.TXT"));
	{
		SD.remove("/LOG/CTR2_LOG.TXT");
	}
	blockISR = true;
	Chk4LogFiles();
	LoadTxtLog();
	blockISR = false;
	gCtstCtr = 1; //reset contest counter
	hmiWait4Reply = 0;
	Tx2HMI("page Log"); //display cleared log
	Tx2HMI("Log.rtnPg.val=12"); //return to config page
	Tx2HMI("Log.rtnPg.val=12");
}


void Chk4PageChange()
{
	//if page changes, process change events						
	if (hmiPage != hmiPagePrev)
	{
		//new page, chk what needs to be done
		gEncoder = 0; //reset encoder if enabled
		gEncoderPrev = 0xff; //force update to be sent to HMI
		hmiUpdateCtr = 0; //force immediate page update
		hmiFFTMarkerUpdate = 0; //

		if (gAudioMode == AUDIO_PLAYBACK)
		{				
			SD_StopPlaying();
			gAudioStartBtn = false;
			SetTxPath(); //restore normal tx audio path
		}			

		//just switched to TxMem page, update if needed, but not if we just edited an entry		
		if (hmiPage == HMI_EDIT && hmiPagePrev == HMI_HOME)
		{
			//V>M button pressed, Edit page is open, fill it up
			SerialOut("Fill Edit Page", true);
			UpdateEditPage();
		}
		else if (hmiPage == HMI_TXMEM && hmiPagePrev != HMI_INPUT && hmiPagePrev != HMI_AUDIO)
		{
			//update memory list if we're not returning from the input or audio pages
			//these are buffers we're editing, not necessarily the gOMode buffers - so don't load them from UpdateTxMem()
			if (hmiTxMemMode != 0xff)
			{				
				UpdateTxMem(hmiTxMemMode);
			}
			else
			{
				SerialOut("Resetting hmiPage to hmiPagePrev, hmiTxMemMode= " + String(hmiTxMemMode, HEX), true);
				hmiPage = hmiPagePrev; //reset so we try again
			}
		}
		else if (hmiPage == HMI_FREQMEM && (hmiPagePrev == HMI_HOME || hmiPagePrev == HMI_EDIT))
		{
			hmiFreqMemStartAtPrev = 0xff; //force freq list update
		}
		else if (hmiPage == HMI_HOME && (hmiPagePrev == HMI_CW || hmiPagePrev == HMI_VOICE || hmiPagePrev == HMI_RTTY || hmiPagePrev == HMI_DIG))
		{
			//update route			
			SetOutputSource(0xff, false); //use last mode we set
			//update tx memory buffers to current mode
			UpdateTxMem(gOMode);
		}
		else if (hmiPage == HMI_AUDIO && gTxModeSet2 != RADIO_TX_OFF)
		{
			gTxModeSet2 = RADIO_TX_OFF; //force if off if we're recording audio
		}


		switch (hmiPagePrev)
		{
		case HMI_HOME:
			if (gAudioRecRx == true || gAudioMode == AUDIO_RECORD)
			{
				//we're recording, turn it off
				gAudioRecRx = false;
				SD_StopRecording();				
				SetTxPath(); //restore normal tx audio path
				Tx2HMI("Audio.btStart.val=0");
				Tx2HMI("Audio.btStart.val=0");
				gAudioStartBtn = false;
			}
			break;
		case HMI_AUDIO:
			//exited Audio page, turn off any playback running
			if (gAudioMode == AUDIO_PLAYBACK)
			{
				SD_StopPlaying();			
				SetTxPath(); //restore normal tx audio path
				gAudioStartBtn = false;
			}
			break;
		}

		hmiAutoLogUpdate = millis() + hmiAutoLogUpdateDefault;
		if (hmiPage == HMI_HOME)
		{
			hmiFFTMarkerUpdate = 0; //update markers on fft
		}
	}

	hmiPagePrev = hmiPage;
}


void ChkChr2HMI()
{
	// 1. send decoded chars from demodulators to Home.bRx on hmi if there are any
	// 2. process keyboard input	
	if (chr2HMICtr > 0 && chr2HMICtr <= 31)
	{
		String txt = "";
		//block irq so ChkDecoder routines can't overwrite chr2HMI
		noInterrupts();
		for (uint8_t i = 0; i < chr2HMICtr; i++)
		{
			if (chr2HMI[i] != 0)
			{
				txt += String(chr2HMI[i]);
			}
		}
		interrupts();

		//normal rx - route incoming data to Home.bRx()
		if (txt.length() > 0)
		{
			//add new chrs to bRx on home page
			if (hmi_bRx.length() + chr2HMICtr <= hmi_rxM_len)
			{
				hmi_bRx += txt;
			}
			else
			{
				hmi_bRx = hmi_bRx.substring(chr2HMICtr) + txt;
			}
			
			//add new chrs to RxMsg array
			if (hmi_rxM[hmi_rxM_ptr].length() + chr2HMICtr <= hmi_rxM_len)
			{
				hmi_rxM[hmi_rxM_ptr] += txt; //add it to current line in RxMsg page
			}
			else
			{
				hmi_rxM_ptr++;
				if (hmi_rxM_ptr > 10)
				{
					for (int i = 1; i < 11; i++)
					{
						hmi_rxM[i - 1] = hmi_rxM[i];
					}
					hmi_rxM_ptr = 10; //stop at the bottom and move the other strings up
					hmi_rxM[10] = "";//clear new line					
				}
				hmi_rxM[hmi_rxM_ptr] = txt; //add it to current line in RxMsg page													
			}						
		}
		//trim strings if too long		

		if (hmi_bRx.length() > hmi_bRx_max)
		{
			//trim if too long			
			hmi_bRx = hmi_bRx.substring(hmi_bRx.length() - hmi_bRx_max);
		}

		hmiUpdateCtr = 0; //update HMI immediately
	}
	chr2HMICtr = 0;

	//process keyboard input

	if (keyboardChr != 0)
	{
		//send chr from KeyboardPress_ISR()
		SerialOut("keyboard chr=" + String(keyboardChr), true);
		int kChr = keyboardChr; //shorter :)
		keyboardChr = 0;

		//functions common to all pages
		switch (kChr)
		{
		case 27: //esc - return home
			if (hmiPage != HMI_INPUT)
			{
				Tx2HMI("page Home"); //just return home				
			}
			else
			{
				Tx2HMI("click bCancel,0"); //return to calling page				
			}
			kChr = 0;
			break;
		case 194: //f1 - open help page
			Tx2HMI("page Help");
			kChr = 0;
			break;
		}

		//these pages use the encoder - process those keys first
		if (hmiPage == HMI_HOME || hmiPage == HMI_BAND || hmiPage == HMI_CW || hmiPage == HMI_VOICE || hmiPage == HMI_RTTY || hmiPage == HMI_DIG || hmiPage == HMI_FLEX || hmiPage == HMI_PCR || hmiPage == HMI_AUDIO)
		{
			int curDir = 0;
			switch (kChr)
			{
			case 195: //f2 - disable Tx mode
				Tx2HMI("gTxMode=" + String(RADIO_TX_OFF));
				kChr = 0;
				break;
			case 196: //f3 - enable Tx mode
				Tx2HMI("gTxMode=" + String(RADIO_TX_ENAB)); //this is PTT in Voice mode
				kChr = 0;
				break;
			case 197: //f4 - enter keyboard keyer mode
				Tx2HMI("btPlay.val=1");
				Tx2HMI("click btPlay,0");
				kChr = 0;
				break;
			case 210: //home - reset encoder selected ctrl
				gEncoder = 0;
				gEncoderPrev = 0xff; //force update to be sent to HMI
				kChr = 0;
				break;
			case 211: //pgUp = inc gEncoder
				SetEncoder(gEncoder + 1);
				kChr = 0;
				break;
			case 214: //pgDown = inc gEncoder
				SetEncoder(gEncoder - 1);
				kChr = 0; //so routine below doesn't use it
				break;
			case 217: //down arrow - dec selected control value
				curDir = -1;
				SetEncoderCtrl(curDir);
				kChr = 0;
				break;
			case 218: //up arrow = inc selected control value
				curDir = 1;
				SetEncoderCtrl(curDir);
				kChr = 0;
				break;
			}
		}

		//now process other keys
		hmiWait4Reply = 0;
		switch (hmiPage)
		{
		case HMI_HOME:
			switch (kChr)
			{
			case 9: //tab key - list log
				ListLog();
				break;
			case 17: //ctrl+1 - tx #1 buffer
				//NOTE: the Terminal connection can't send ctrl+# chrs, use alt+# instead - translated in ProcessTerminalCmd()
				Tx2HMI("click b0,0");
				break;
			case 18: //ctrl+2
				Tx2HMI("click b1,0");
				break;
			case 19: //ctrl+3
				Tx2HMI("click b2,0");
				break;
			case 20: //ctrl+4
				Tx2HMI("click b3,0");
				break;
			case 21: //ctrl+5
				Tx2HMI("click b4,0");
				break;
			case 22: //ctrl+6
				Tx2HMI("click b5,0");
				break;
			case 23: //ctrl+7
				Tx2HMI("click b6,0");
				break;
			case 24: //ctrl+8
				Tx2HMI("click b7,0");
				break;
			case 25: //ctrl+9
				Tx2HMI("click b8,0");
				break;
			case 16: //ctrl+10
				Tx2HMI("click b9,0");
				break;
			case 198: //f5 - edit called station
				Tx2HMI("click bCall,0");
				break;
			case 199: //f6 - edit RST sent
				Tx2HMI("click bRSTs,0");
				break;
			case 200: //f7 - edit RST rcvd
				Tx2HMI("click bRSTr,0");
				break;
			case 201: //f8 - edit power
				Tx2HMI("click bPwr,0");
				break;
			case 202: //f9 - edit contest ctr
				Tx2HMI("click bCtr,0");
				break;
			case 203: //f10 - edit exchange
				Tx2HMI("click bExch,0");
				break;
			case 204: //f11- save log
				Tx2HMI("click bSave,0");
				break;
			case 205: //f12 - show RxMsg page
				Tx2HMI("click bRx,0");
				break;
			case 209: //insert - pause the current tx buffer			
				Tx2HMI("Home.btPlay.val=0");
				Tx2HMI("Home.btPlay.val=0");
				break;
				//case 211: pgUp - inc gEncoder - code is above
			case 212:
				break; //del - future
			case 213: //end - delete current bTx buffer				
				hmi_bTx = char(0xff);
				ChkTxBuffer();
				break;
				//case 214: pgDown - dec gEncoder - code is above
			case 215: //right arrow - dec selected gUnit digit (move to right)
				if (gUnit > 1)
				{
					gUnit /= 10;
				}
				else
				{
					gUnit = 100000000; //roll to max
				}
				gEncoder = 0; //reset if active				
				gEncoderPrev = 0xff; //force update to be sent to HMI
				break;
			case 216: //left arrow - inc selected gUnit digit (move to left)
				gUnit *= 10;
				if (gUnit > 100000000)
				{
					gUnit = 1;
				}
				gEncoder = 0;
				gEncoderPrev = 0xff; //force update to be sent to HMI
				break;
			}
			break;
		case HMI_KEYPAD:
			//future support - need to make all controls global
			break;
		case HMI_INPUT:
			switch (kChr)
			{
			case 10:
				Tx2HMI("click bOk,0"); //click OK btn
				break;
			case 13:
				Tx2HMI("click bOk,0"); //click OK btn
				break;
			case 127:
				Tx2HMI("click bDel,0"); //back space -click back space btn (<)
				break;
			case 197: //f4 - restart play
				Tx2HMI("Home.btPlay.val=1");
				Tx2HMI("click btPlay,0");
				break;
			case 198: //f5 their call 
				Tx2HMI("bShift.val=1"); //switch to upper case
				Tx2HMI("click b40,0"); //click >= button
				break;
			case 199: //f6 my call
				Tx2HMI("bShift.val=1"); //switch to upper case
				Tx2HMI("click b41,0"); //click =< button
				break;
			case 209: //insert - pause the current tx buffer
				Tx2HMI("Home.btPlay.val=0");
				Tx2HMI("Home.btPlay.val=0");
				break;
			case 212:
				Tx2HMI("tData.txt=``"); //del - erase entire tData buffer (<<)
				break;
			case 213: //end - delete current bTx buffer
				Tx2HMI("bTx.txt=`Tx:`");
				hmi_bTx = char(0xff);
				ChkTxBuffer();
				break;
			default:
				if (kChr >= 0x20 && kChr <= 0x7e)
				{
					//only send normal chrs to tData	
					Tx2HMI("Input.kybdInp.txt=`" + String(char(kChr)) + "`");
				}
				break;
			}
			break;
		case HMI_RXMSG:
			switch (kChr)
			{
			case 195: //f2 - disable Tx mode
				Tx2HMI("gTxMode=" + String(RADIO_TX_OFF));
				break;
			case 196: //f3 - enable Tx mode
				Tx2HMI("gTxMode=" + String(RADIO_TX_ENAB)); //this is tx mode in Voice
				break;
			case 197: //f4 - enter keyboard keyer mode
				Tx2HMI("Home.btPlay.val=1");
				Tx2HMI("Home.click btPlay,0");
				break;
			case 212: //delete - delete current bRx buffer
				Tx2HMI("click b2,0");
				gEncoder = 0;
				gEncoderPrev = 0xff; //force update to be sent to HMI
				break;
			}
			break;
		case HMI_HELP:
			switch (kChr)
			{
			case 216: //left cursor
				Tx2HMI("click bDec,0");
				break;
			case 217: //down cursor
				Tx2HMI("click bDec,0");
				break;
			case 215: //right cursor
				Tx2HMI("click bInc,0");
				break;
			case 218: //up cursor
				Tx2HMI("click bInc,0");
				break;
			}
			break;
		case HMI_SAVELOG:
			switch (kChr)
			{
			case 10:
				SaveLogEntryFromHMI();
				break;
			case 13:
				SaveLogEntryFromHMI();
				break;
			case 212: //del - erase all
				Tx2HMI("click bClear,0");
				break;
			}
			break;
		case HMI_AUTOLOG:
			break;
		}
		hmiUpdateCtr = 0; //immediate display update		
	}
}

void ShowInitializing()
{
	//show red initialing label on hmi
	Tx2HMI("Home.tInfo1.bco=RED");
	Tx2HMI("Home.tInfo1.bco=RED");
	Tx2HMI("Home.tInfo2.bco=RED");
	Tx2HMI("Home.tInfo2.bco=RED");
	Tx2HMI("Home.tInfo1.txt=`Initializing`");
	Tx2HMI("Home.tInfo1.txt=`Initializing`");
	Tx2HMI("Home.tInfo2.txt=`Please wait...`");
	Tx2HMI("Home.tInfo2.txt=`Please wait...`");

}
