/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;

import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;


public class SetGen_A_FM_Dev extends Activity{

		private static final String TAG = "NimbleSig.SetGen_A_FM_Dev";
	    private static final boolean D = true;
	    
	    
		private Button mFM_DevHzA_SetButton;

		private float fmDevHz_Flt=0; 
		private int fmDevHz_Int=0; 
	    private String newFM_DevHzA_Str="0";
	    private String currentFM_DevHzA_Str="0";
		private float start_posCrs_Flt=0; 
		private int start_posCrs_Int=0; 
		private float lastFineCorrection=0;
		private float fineCorrection=0;
		private boolean fineBarAutoCentre=false;
		private boolean courseBarAutoAdj=false;
		
		
		@Override
		public void onCreate(Bundle icicle) {
	    super.onCreate(icicle);
	    	if(D) Log.e(TAG, "+++ SET GEN A FM DEVIATION +++");

	        Intent currentValIntent = getIntent();
	        if(currentValIntent.hasExtra("valFM_DevHzA")){
	            currentFM_DevHzA_Str = currentValIntent.getStringExtra("valFM_DevHzA");
	            currentFM_DevHzA_Str = stripSpaces(currentFM_DevHzA_Str);
	        }
	    	// Set up the window layout
	    	setContentView(R.layout.activity_nimble_sig_rfgen_set_fm_dev);
	        TextView FM_DevHzAValStr =(TextView) findViewById(R.id.fmDevHzValue);
	        FM_DevHzAValStr.setText(currentFM_DevHzA_Str);            
	    	TextView FM_DevHzAdjTitle = (TextView) findViewById(R.id.titleFM_Dev_Adjust); 
	    	FM_DevHzAdjTitle.setText("Generator 'A' FM Deviation - Hz.");
	    	
	    	
	        start_posCrs_Flt=Float.parseFloat(currentFM_DevHzA_Str);    //you need to give starting position value of SeekBar 
	        start_posCrs_Int=(int) (start_posCrs_Flt); 
	        fmDevHz_Flt=start_posCrs_Flt; 
	        SeekBar crsFM_DevHzA_Bar=(SeekBar) findViewById(R.id.courseDevHzAdj_Bar); 
	        crsFM_DevHzA_Bar.setProgress(start_posCrs_Int); 
	        SeekBar medFM_DevHzA_Bar=(SeekBar) findViewById(R.id.medDevHzAdj_Bar); 
	        medFM_DevHzA_Bar.setProgress(2500); 
	        SeekBar fineFM_DevHzA_Bar=(SeekBar) findViewById(R.id.fineDevHzAdj_Bar); 
	        fineFM_DevHzA_Bar.setProgress(250); 
	        SeekBar extraFineFM_DevHzA_Bar=(SeekBar) findViewById(R.id.extraFineDevHzAdj_Bar); 
	        extraFineFM_DevHzA_Bar.setProgress(10); 

	        
	        crsFM_DevHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
	/*
	            	if (fmDevHz_Flt >= 0){
	            		milliDegrees *= (int)1000;
	            	}
	            	if (fmDevHz_Flt < 0){
	            		milliDegrees = (int)(360-fmDevHz_Flt)*1000;
	            	}
	            	
	                newFM_DevHzA_mDeg = String.valueOf(milliDegrees);
//	            	sendMessage("pa"+newFM_DevHzA_mDeg);
	*/
	            	lastFineCorrection = 0;
//	                SeekBar fineFM_DevHzA_Bar=(SeekBar) findViewById(R.id.fineDevHzAdj_Bar);
//	                fineFM_DevHzA_Bar.setProgress(2500);
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!courseBarAutoAdj){//skip if adjustment from finer seek bars
		            	// To convert it as fmDevHz_Flt value 
		                fmDevHz_Flt=((int)progress/1000)*1000; 
		                newFM_DevHzA_Str = String.valueOf(fmDevHz_Flt);
		                upDateFM_DevHzAVal(fmDevHz_Flt);
	            	}else courseBarAutoAdj=false;
	            } 
	        }); 
	 
	        fineFM_DevHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
	                // To convert it as fmDevHz_Flt value 
	                SeekBar crsFM_DevHzA_Bar=(SeekBar) findViewById(R.id.courseDevHzAdj_Bar);
	                int newProgress = (int)fmDevHz_Flt;
	                courseBarAutoAdj=true;
	                crsFM_DevHzA_Bar.setProgress(newProgress);
	                fineBarAutoCentre=true;
	                SeekBar fineFM_DevHzA_Bar=(SeekBar) findViewById(R.id.fineDevHzAdj_Bar);
	                fineFM_DevHzA_Bar.setProgress(2500);
	                lastFineCorrection = 0;
	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!fineBarAutoCentre){
	            		fineCorrection=progress-2500;
	            		fineCorrection=((int)fineCorrection/100)*100;
		                fmDevHz_Flt += (fineCorrection-lastFineCorrection);            
		                lastFineCorrection = fineCorrection;
		                float test1 = fmDevHz_Flt;
		                newFM_DevHzA_Str = String.valueOf(fmDevHz_Flt);
		                upDateFM_DevHzAVal(fmDevHz_Flt);
	            	}
	                else fineBarAutoCentre = false;
	            } 
	        }); 
	 
	        medFM_DevHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
	                // To convert it as fmDevHz_Flt value 
	                SeekBar crsFM_DevHzA_Bar=(SeekBar) findViewById(R.id.courseDevHzAdj_Bar);
	                int newProgress = (int)fmDevHz_Flt;
	                courseBarAutoAdj=true;
	                crsFM_DevHzA_Bar.setProgress(newProgress);
	                fineBarAutoCentre=true;
	                SeekBar fineFM_DevHzA_Bar=(SeekBar) findViewById(R.id.medDevHzAdj_Bar);
	                fineFM_DevHzA_Bar.setProgress(2500);
	                lastFineCorrection = 0;
	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!fineBarAutoCentre){
	            		fineCorrection=progress-2500;
	            		fineCorrection=((int)fineCorrection/100)*100;
	            		fmDevHz_Flt=((int)((fmDevHz_Flt+.5)/100))*100;
		                fmDevHz_Flt += (fineCorrection-lastFineCorrection);            
		                lastFineCorrection = fineCorrection;
		                float test1 = fmDevHz_Flt;
		                newFM_DevHzA_Str = String.valueOf(fmDevHz_Flt);
		                upDateFM_DevHzAVal(fmDevHz_Flt);
	            	}
	                else fineBarAutoCentre = false;
	            } 
	        }); //medFM_DevHzA_Bar
	 
	        fineFM_DevHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
	                // To convert it as fmDevHz_Flt value 
	                SeekBar crsFM_DevHzA_Bar=(SeekBar) findViewById(R.id.courseDevHzAdj_Bar);
	                int newProgress = (int)fmDevHz_Flt;
	                courseBarAutoAdj=true;
	                crsFM_DevHzA_Bar.setProgress(newProgress);
	                fineBarAutoCentre=true;
	                SeekBar fineFM_DevHzA_Bar=(SeekBar) findViewById(R.id.fineDevHzAdj_Bar);
	                fineFM_DevHzA_Bar.setProgress(250);
	                lastFineCorrection = 0;
	                
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!fineBarAutoCentre){
	            		fineCorrection=progress-250;
	            		fineCorrection=((int)fineCorrection/10)*10;
	            		fmDevHz_Flt=((int)((fmDevHz_Flt+.5)/10))*10;
		                fmDevHz_Flt += (fineCorrection-lastFineCorrection);            
		                lastFineCorrection = fineCorrection;
		                float test1 = fmDevHz_Flt;
		                newFM_DevHzA_Str = String.valueOf(fmDevHz_Flt);
		                upDateFM_DevHzAVal(fmDevHz_Flt);
	            	}
	                else fineBarAutoCentre = false;
	            } 
	        }); //fineFM_DevHzA_Bar
	 
	        extraFineFM_DevHzA_Bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

	            @Override 
	            public void onStopTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 
	                // To convert it as fmDevHz_Flt value 
	                SeekBar crsFM_DevHzA_Bar=(SeekBar) findViewById(R.id.courseDevHzAdj_Bar);
	                int newProgress = (int)fmDevHz_Flt;
	                courseBarAutoAdj=true;
	                crsFM_DevHzA_Bar.setProgress(newProgress);
	                fineBarAutoCentre=true;
	                SeekBar fineFM_DevHzA_Bar=(SeekBar) findViewById(R.id.extraFineDevHzAdj_Bar);
	                fineFM_DevHzA_Bar.setProgress(10);
	                lastFineCorrection = 0;
	            } 

	            @Override 
	            public void onStartTrackingTouch(SeekBar seekBar) { 
	                // TODO Auto-generated method stub 

	            } 

	            @Override 
	            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
	                // TODO Auto-generated method stub 
	            	if(!fineBarAutoCentre){
		            	if(!fineBarAutoCentre){
		            		fineCorrection=progress-10;
			                fmDevHz_Flt += (fineCorrection-lastFineCorrection);            
			                lastFineCorrection = fineCorrection;
			                float test1 = fmDevHz_Flt;
			                newFM_DevHzA_Str = String.valueOf(fmDevHz_Flt);
			                upDateFM_DevHzAVal(fmDevHz_Flt);
		            	}
	            	}
	                else fineBarAutoCentre = false;	           
	            }
	        }); //extraFineFM_DevHzA_Bar
	        
	 
	    }//onCreate 
		
		
	    public void upDateFM_DevHzAVal(float val) {
	        TextView FM_DevHzA_ValLabel = (TextView) findViewById(R.id.fmDevHzValue);
	        fmDevHz_Int = (int)(val);
	        FM_DevHzA_ValLabel.setText(String.valueOf(fmDevHz_Int));
	    }

	    @Override
	    public synchronized void onResume() {
	        super.onResume();
	    	if(D) Log.e(TAG, "+++ ON RESUME +++");
	       

	        //VFO A fmDevHz SET button with a listener that for click events
	        mFM_DevHzA_SetButton = (Button) findViewById(R.id.updateDevHzBtn);
	        mFM_DevHzA_SetButton.setOnClickListener(new OnClickListener() {
	        	public void onClick(View v) {
	                TextView FM_DevHzA_Value=(TextView) findViewById(R.id.fmDevHzValue);
	                newFM_DevHzA_Str = FM_DevHzA_Value.getText().toString();
	            	Intent newFM_DevHzA_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
	            	newFM_DevHzA_Val.putExtra("valFM_DevHzA",newFM_DevHzA_Str);
	        		finish ();
	        	}
	        });
	        
	    }//onResume
	    
	    private String stripSpaces(String str){
	        int l=str.length();
	        int i=0;
	        char tempChr[]=str.toCharArray();
	        String tempStr="";
	        while(i<l){
	        	if(tempChr[i] !=' '){
	        		tempStr+=String.valueOf(tempChr[i]);
	        	}
	        	i++;
	        }
	    	return tempStr;
	    }

	    @Override
	    public void finish() {
	      // Prepare data intent 
	      Intent newFM_DevHzA_ValIntent = new Intent();
	      newFM_DevHzA_ValIntent.putExtra("valFM_DevHzA", newFM_DevHzA_Str);
	      // Activity finished ok, return the data
	      setResult(RESULT_OK, newFM_DevHzA_ValIntent);
	      super.finish();
	    } 
	   
	    @Override
	    public synchronized void onPause() {
	        super.onPause();
//		        if(D) Log.e(TAG, "- ON PAUSE -");
	    }

	    @Override
	    public void onStop() {
	        super.onStop();
//		        if(D) Log.e(TAG, "-- ON STOP --");
	    }

	    @Override
	    public void onDestroy() {
	        super.onDestroy();
//		        if(D) Log.e(TAG, "--- ON DESTROY ---");
	    }


	}

