;                            Software License Agreement
;
; The software supplied herewith by Dick Lichtel is intended 
; for use solely and exclusively with the Quantum VFO
;
; The software is owned by the Company and/or its supplier, and is protected under
; applicable copyright laws. All rights are reserved. Any use in violation of the
; foregoing restrictions may subject the user to criminal sanctions under applicable
; laws, as well as to civil liability for the breach of the terms and conditions of
; this license.
;
; THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, WHETHER EXPRESS,
; IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE
; COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
; CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;
;###############################################################################
; filename:	MAIN.ASM
;		Sample USB firmware
;		Note: the E4_OSC_ config bit must be set for thing to work properly
;
; The USB implementation is based upon the source code supplied by MicroChip
; This implementation simply reads 8 bytes from the and returns them
; 
; USB Commands:
;	
;   ?V        Returns Version info (in descript.asm)

;###############################################################################
;
;	$Author:  $			
;	Company:		
;
;	$Revision:$	
;	$Date:  $		
;	Assembled using:	MPASM 3.20.08
;	Configuration Bits:	E4 Oscillator, WDT Off, Power up timer off
;	$History: $
; 

;################################################################################
;
;    include files:
;        P16C745.inc    Rev 1.00
;        usb_defs.inc   Rev 1.10
;
;################################################################################
#include <p16c745.inc>
#include "usb_defs.inc"
;              External Clk with CLKOUT on OSC2, Watchdog timer off, Power-up Timer off, no Code protected
	__CONFIG  _E4_OSC & _WDT_OFF & _PWRTE_OFF & _CP_OFF

unbanked	udata_shr
W_save		res	1	; register for saving W during ISR
Index		res 1	; Index for copying code string to ram
Source_PCL	res 1	; pointer to code string
Source_PCLATH res 1	; pointer to code string

bank0	    udata
Status_save	res	1	; registers for saving context 
PCLATH_save	res	1	;  during ISR
FSR_save	res	1
INNER		res	1
OUTER		res	1
PIRmasked	res	1

; User registers
ByteCount 	res 1	; Number of bytes in Buffer
Buffer		res	8	; Location for data to be sent to host & data from host

	

	extern	InitUSB
	extern	PutEP1
	extern	GetEP1
	extern	ServiceUSBInt
	extern	String3_l1





;************************************************
    errorlevel -302  ; supress "register not in bank0, check page bits" message

STARTUP	code
	pagesel	Main
	goto	Main
	nop
InterruptServiceVector
	movwf	W_save		; save W
	movf	STATUS,W
	clrf	STATUS		; force to page 0
	movwf	Status_save	; save STATUS
	movf	PCLATH,w
	movwf	PCLATH_save	; save PCLATH
	movf	FSR,w
	movwf	FSR_save	; save FSR
	pagesel TMR0TEST

; *************************************************************
; Interrupt Service Routine
; First we step through several stages, attempting to identify the source 
; of the interrupt.
; ******************************************************************

Process_ISR
TMR0TEST
	btfsc	INTCON,T0IE
	btfss	INTCON,T0IF
	goto	INTTEST
	nop			; insert TMR0 code call here
INTTEST
	btfsc	INTCON,INTE
	btfss	INTCON,INTF
	goto	RBTEST
	nop			; insert RB0/INT code call here
RBTEST
	btfsc	INTCON,RBIE
	btfss	INTCON,RBIF
	goto	PERIPHERALTEST
	nop			; insert PORTB Change code call here

PERIPHERALTEST
	btfss	INTCON,PEIE	; is there a peripheral interrupt?
	goto	EndISR		; all done....

TEST_PIR1
	banksel	PIR1
	movf	PIR1,w
	banksel	PIE1
	andwf	PIE1,w		; mask the enables with the flags
	banksel	PIRmasked
	movwf	PIRmasked
	pagesel	ServiceUSBInt
	btfsc	PIRmasked,USBIF	; USB interrupt flag
	call	ServiceUSBInt	; Service USB interrupt
	btfsc	PIRmasked,ADIF	; AD Done?
	nop
	btfsc	PIRmasked,RCIF
	nop
	btfsc	PIRmasked,TXIF
	nop
	btfsc	PIRmasked,CCP1IF
	nop
	btfsc	PIRmasked,TMR2IF
	nop
	btfsc	PIRmasked,TMR1IF
	nop
TEST_PIR2
	banksel	PIR2
	movf	PIR2,w
	banksel	PIE2
	andwf	PIE2,w
	banksel	PIRmasked
	movwf	PIRmasked
	btfsc	PIRmasked,CCP2IF
	nop

; ******************************************************************
; End ISR, restore context and return to the Main program
; ******************************************************************
EndISR
	clrf	STATUS		; select bank 0
	movf	FSR_save,w	; restore the FSR
	movwf	FSR
	movf	PCLATH_save,w	; restore PCLATH
	movwf	PCLATH
	movf	Status_save,w	; restore Status
	movwf	STATUS
	swapf	W_save,f	; restore W without corrupting STATUS
	swapf	W_save,w
	retfie

	code

Main

; ******************************************************************
; Sets the probe control register to output the UCTRL register and
; USBDPRAM databus onto the probepins.  
; ******************************************************************
	
  	movlw	.128      	; delay 16 uS to wait for USB to reset
	movwf	W_save		; SIE before initializing registers
	decfsz	W_save,f	; inner is merely a convienient register
	goto	$-1	    	; to use for the delay counter.
	
	pagesel	InitUSB		; These six lines of code show the appropriate
	call	InitUSB		;  way to initialize the USB. First, initialize

	bsf	OPTION_REG,NOT_RBPU  ; disable portb weak pull-up
 	bcf	STATUS,RP0   	; Make sure you include all pagesels and return to
	bcf	STATUS,RP1  	; the desired bank (in this case Bank 0.)
 	ConfiguredUSB		; until the enumeration process to complete.
	
 
    
	
;******************************************************************		
;Now wait for something to arrive
;Data will be in Buffer
;******************************************************************
CheckEP1:		; Check Endpoint 1 for an OUT transaction
	bankisel 	Buffer	; point to lower banks
	pagesel  	GetEP1
    banksel     Buffer
	movlw		Buffer	; Data to be recvd will be put in Buffer
	movwf		FSR		; point FSR to our buffer
	call		GetEP1	; If data is ready, it will be copied.
	pagesel 	CheckEP1
	btfss		STATUS,C	; was there any data for us?
	goto		CheckEP1	; Nope, check again.
	
;if we receive a ?V, return the Firmware version
; otherwise just return what we received
	movf		Buffer,w
	sublw		'?'
	btfss		STATUS,Z
	goto		PutBuffer
	movf		Buffer+1,w
	sublw		'V'
	btfss		STATUS,Z
	goto		PutBuffer
	
	pagesel		GetVersion
	call		GetVersion
	

PutBuffer
	bankisel 	Buffer	; point to lower banks
	pagesel  	PutEP1
	movlw		Buffer
	movwf		FSR		; point FSR to our buffer
	movlw		0x08		; send 8 bytes to the Host
	call		PutEP1
	pagesel 	PutBuffer
	btfss		STATUS,C	; was it successful?
	goto		PutBuffer	; No: try again until successful
	pagesel 	CheckEP1
	goto		CheckEP1	; Yes: restart loop

 

	
;***************************************************
;GetVersion
; Parses the Version string in 	descript.asm
; and sends it back to the calling APP 
;**************************************************
GetVersion:
    pagesel		ZeroBuffer		;Clear out our buffer
    call		ZeroBuffer
    
 	pagesel		String3_l1		;Get the number of characters
  	call		String3_l1		; in the version string
  	
 	banksel		ByteCount
 	movwf		ByteCount
 	bcf			STATUS,C
  	rrf			ByteCount,f		;#of characters is ByteCount/2 -1
  	decf		ByteCount,f
  	
   	bankisel	Buffer
 	movlw		Buffer
  	movwf		FSR
  	
 	movlw		high (String3_l1+2)		;remember, that String3_l1 is a bunch of retlw statments
  	movwf		Source_PCLATH
  	movlw		low	(String3_l1+2)
  	movwf		Source_PCL
  	
VerCharLoop:
  	pagesel		GetVerChar
  	call		GetVerChar			;Fetch the next character
 	pagesel		VerCharLoop
  	movwf		INDF					
  	incf		Source_PCL,f		;Skip over every other char
  	incf		Source_PCL,f		;since they are NULL
  	incf		FSR,f
   	decfsz		ByteCount,f
  	goto		VerCharLoop
 	goto		VersionExit
GetVerChar:
  	movf		Source_PCLATH,w	  ;Set up PCL & PCLATH to get the character
  	movwf		PCLATH
  	movf		Source_PCL,w
  	movwf       PCL	 
  	
VersionExit:	
 	return

;****************************************
; Zeros the Buffer
;****************************************
ZeroBuffer:

   banksel	Buffer
 variable i=0;
    while(i<8)
    clrf	Buffer+i
i++
	endw
	return;	

 end
