#
# Makefile for KE5FX DDS/PLL hybrid synthesizer development
#

all: nstest.exe \
     astest.exe \
     avrstest.hex

#
# Win32 test programs for NatSemi- and Analog Devices-based synthesizers
#

nstest.exe: stest.cpp synth.cpp
   cl /DPLLATINUM stest.cpp gpiblib.lib winmm.lib /Fonstest.obj

astest.exe: stest.cpp synth.cpp
   cl stest.cpp gpiblib.lib winmm.lib /Foastest.obj

#
# Atmel test program for Analog Devices-based synthesizer
#
# Build with -DPLLATINUM for NatSemi compatibility
#

MCU = atmega128

avrstest.hex: avrstest.cpp avr232.cpp synth.cpp
   avr-gcc -g -mmcu=$(MCU) -Wall -O2 -c -Wstrict-prototypes avrstest.cpp
   avr-gcc -g -mmcu=$(MCU) -Wall -o avrstest.out -W1,-Map,avrstest.map avrstest.o
   avr-objcopy -R .eeprom -O ihex avrstest.out avrstest.hex
   \avr4\stk500\stk500 -d$(MCU) -ms -ifavrstest.hex -e -pf

