#ifndef GPIBLIB_H
#define GPIBLIB_H

#include "typedefs.h"

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef BUILDING_GPIBLIB
   #define GPIBDEF __declspec(dllexport)
#else
   #define GPIBDEF __declspec(dllimport)
#endif

typedef void (WINAPI *GPIBERR)(C8 *msg, S32 ibsta, S32 iberr, S32 ibcntl);

GPIBDEF S32    WINAPI GPIB_startup  (S32 address, GPIBERR handler);
GPIBDEF S32    WINAPI GPIB_shutdown (void);
GPIBDEF S32    WINAPI GPIB_online   (void);
GPIBDEF S32    WINAPI GPIB_offline  (void);
GPIBDEF S32    WINAPI GPIB_write    (C8 *string, S32 len=-1);
GPIBDEF C8 *   WINAPI GPIB_read     (void);
GPIBDEF C8 *   WINAPI GPIB_query    (C8 *string);

#ifdef __cplusplus
}
#endif

#endif
