/*  Increment Histogram INCHIST.C  */

void inchist(int nbins, float bins[],
	     float hpitch, float hshift, float incr)

/*  nbins   Number of histogram bins                */
/*  bins    The array of histogram bins             */
/*  hpitch  Est spkr pitch in num of bins spanned   */
/*  hshift  One poss freq shift in histogram units  */
/*  incr    Amount to increment each selected bin   */

/*  For lowf=min freq of bin 0 (lowf may be < 0),   */
/*  And hif=min freq of bin (nbins-1),              */
/*  hpitch = pitch*nbins/(hif-lowf) and             */
/*  hshift =(shift-lowf)*nbins/(hif-lowf).          */

{
   float fidx;  /*  Floating point histogram index  */
   int   idx;   /*  Integer histogram index         */

   if(hpitch>=1.0  && 0.0<=hshift && hshift<nbins && incr>0.0)
   {
      fidx=hshift;
      while(fidx>=0.0)
      {
	 idx=fidx;
	 bins[idx]=bins[idx]+incr;
	 fidx=fidx-hpitch;
      }
      fidx=hpitch+hshift;
      while(fidx<nbins)
      {
	 idx=fidx;
	 bins[idx]=bins[idx]+incr;
	 fidx=fidx+hpitch;
      }
   }
}