/*  AARETUN.C  */
#include <stdio.h>
#include <math.h>
#include "c:\turboc\ssb\hilb.c"
#define SNGL_LEN 1024

void aafilt(int remember, float rel_shift, 
            int n, float in[], float out[]);

void retune(int remember, float rel_shift,
            int n, float in[], float out[])
/*
 *  Anti-aliasing SSB retuner.
 *  Use -1.<rel_shift<0.5.  Fraction of sampling rate to shift.
 *  Example:  rel_shift==-0.5 inverts frequencies.
 *  n is num points in and out.  Need 15 < n <= SNGL_LEN.
 *  Anti-alias filter, attach imag part, retune.
 *  Calls aafilt for anti-aliasing.  Calls hilb to null neg freqs.
 */
{
    static float inbuf[SNGL_LEN];  /* input anti-alias filtered */
    static float rbuf[SNGL_LEN], hilbuf[SNGL_LEN], ibuf[SNGL_LEN];
    static float oldrbuf[15];  /* static so preserved between calls */
    /*  hilbuf=Hilbert transform output buffer==minus imag part.
     *  oldrbuf=old reals buffer for 15-sample delay to line up with
     *          Hilbert transform output.
     */
    float pi=3.14159265358979, twstr, twsti, turnr, turni;
    /*  twst=unit-magnitude complex number with angle in radians
     *       2*pi*rel_shift=phase angle advance per sample
     *  turn=repeatedly twisted unit-magnitude complex number.
     */
    int idx;
    float tmp;

    if(remember==0)
    {  for(idx=0;idx<15;idx++)
       {  oldrbuf[idx]=0.;
       }
       turnr=1.;
       turni=0.;
    }
    twstr=cos(2.0*pi*rel_shift);
    twsti=sin(2.0*pi*rel_shift);
    
    /* prefilter to prevent postshift aliasing */
    aafilt(remember, rel_shift, n, in, inbuf);

    for(idx=0;idx<15;idx++)
    {  rbuf[idx]=oldrbuf[idx];
       oldrbuf[idx]=inbuf[n-15+idx];
    }
    for(idx=0;idx<n-15;idx++)
    {  rbuf[15+idx]=inbuf[idx];
    }

    hilb(remember, n, inbuf, hilbuf);
    for(idx=0;idx<n;idx++)
    {  /*  Imaginary part is minus Hilbert transform of real part  */
       ibuf[idx]=-hilbuf[idx];
    }

    for(idx=0; idx<n; idx++)
    {  /*  Mult by complex exponential to shift freq.  Save reals.  */
       out[idx]=rbuf[idx]*turnr - ibuf[idx]*turni;
       tmp=twstr*turnr - twsti*turni;
       turni=twstr*turni + twsti*turnr;
       turnr=tmp;
    }
}

#ifdef MAIN
int main()

/*  Timing test of retuner via 1000 point blocks  */

{
   int remember, nblks, idx, jdx;
   static float dat[SNGL_LEN], out[SNGL_LEN];
   float rel_shift;

   for(idx=0;idx<SNGL_LEN;idx+=32)
   {  /* fill input data buffer with dummy data for test purposes  */
      for(jdx=0;jdx<32;jdx++)
      {  if(idx+jdx<SNGL_LEN)
         {  dat[idx+jdx]=15-jdx;
         }
      }
   }

   nblks=1;
   while(nblks>0)
   {  printf("Enter no-resamp relative frequency shift.\n");
      scanf("%f",&rel_shift);
      printf("Enter number of 1000-point blocks to retune.\n");
      scanf("%d",&nblks);
      remember=0;
      for(idx=0;idx<nblks;idx++)
      {  retune(remember,rel_shift,1000,dat,out);
         remember=1;
      }
      printf("Done.\n");
   }
}
#endif
