 10 REM FILE NAME: 'QEXBSF.ASC' FOR USE IN QEX BSF ARTICLE. DATE: 01 NOV 95.
 20 REM Program writes RC%, RET LOSS & OTHER PARAMETERS OF 3rd-ORDER BSF.
 30 PI=4*ATN(1) : Z=50 : N=3    : REM  Z = SOURCE & LOAD IMPEDANCE IN OHMS.
 40 PRINT: INPUT "ENTER FC, C1 & C2 in MHz and pF";FC,C1,C2 : PRINT
 50 RA = C1*C2*((2*PI*FC*Z)^2)*1E-12 : REM RA=LOWPASS G2/G1 RATIO FOR RC CALCS.
 60 IF RA>1.6 GOTO 370 : IF RA<.8 GOTO 370 : REM  OMITS OUT-OF-RANGE RATIOS.
 70 FOR C=1 TO 4       : REM START OF CALCS TO FIND %R.C. FOR CALC'D RA.
 80 A(C) = SIN(.5*PI*(2*C-1)/N) : B(C)=SIN(PI*C/N)^2 : NEXT C
 90 K2 =A(2)/(RA*A(1))          : REM  RA IS LOWPASS G2/G1 RATIO FOR %RC CALC.
 100  M =SQR(B(1)/(K2-1))       : X =M+SQR((M^2)+1)
 110 AP=8.68589*LOG(((X^(2*N))+1)/(((X^(2*N))-1))) : REM AP = Ap(dB)
 120 R1=100*SQR(1-(.1^(.1*AP)))       : REM  REFLECTION COEFF (%)
 130 RC = R1/100 : VS = (1+RC)/(1-RC) : REM VS = VSWR BASED ON RC (REFL COEFF).
 140 RL = -20*(1/LOG(10))*LOG(R1/100) : REM RL = RETURN LOSS IN dB.
 150 REM  START OF CALCS TO FIND G1 AND G2 BASED ON PREVIOUSLY CALC'D R.C.
 160 A = AP/17.3718 : B=LOG((EXP(A)+EXP(-A))/(EXP(A)-EXP(-A)))
 170 D = (EXP(B/(2*N))-EXP(-B/(2*N)))/2
 180 FOR K=1 TO N   : A(K)=SIN((((2*K)-1)*PI)/(2*N))
 190 B(K) = ((D)^2)+(1-COS((2*K*PI)/N))/2 : NEXT K
 200 G(1) = 2*A(1)/D             : REM G(1) = NORMALIZED VALUE OF FIRST ELEMENT
 210 FOR K=2 TO N : G(K) = 4*A(K-1)*A(K)/(B(K-1)*G(K-1)) : NEXT K
 220 G1 =G(1) : G2 =G(2)  : REM  LP G-VALUES (USE RECIPROCALS FOR HP G-VALUES)
 230 L2 = 25330.3/(FC^2*C2)      : REM BASED ON GIVEN FC & C2.
 240 L1 = 25330.3/(FC^2*C1)      : REM BASED ON GIVEN FC & C1.
 250 E=SQR(RC^2/(1-(RC^2)))      : REM RIPPLE FACTOR 'E' BASED ON RC.
 260 V=1/N*LOG(1/E+SQR(1/E^2-1)) : F3=(EXP(V)+EXP(-V))/2 : REM F3=F3/FAp RATIO
 270 BW =1000000!/(C1*G1*Z*2*PI) : B3=BW/F3 : REM BASED ON C1 AND CALC'D G1.
 280 BL =SQR(FC^2 + (BW^2)/4) -BW/2   : REM CALCS LOWER BAND EDGE FOR FC & BW.
 290 BU =BL + BW        : REM CALCS UPPER BAND EDGE BASED ON BL AND BW
 300 PRINT "F-CENTR BW(Ap) BW(3dB) + FAp   R.C.  R.L.  C1,3   C2    L1,3    L2    LP G2/G1"
 310 PRINT " (MHz)  (MHz)   (MHz)  (MHz)   (%)   (dB)  (pF)  (pF)   (uH)   (uH)    RATIO"
 320 PRINT USING " #.## ";FC;  : PRINT USING "  #.####";BW; : PRINT USING "   #.### ";B3;
 330 PRINT USING " #.### ";BU; : PRINT USING " ##.##";R1;   : PRINT USING "   ##.#";RL;
 340 PRINT USING " ##### ";C1; : PRINT USING " ####";C2;
 350 PRINT USING "  ##.## ";L1;: PRINT USING " ##.##";L2; : PRINT USING "    #.#####";G2/G1
 360 PRINT : PRINT "      END OF RUN." : END
 370 PRINT "RA=";RA; : PRINT "    G2/G1 RATIO (RA) MUST BE BETWEEN .8 & 1.6."
 380 PRINT "                 TRY AGAIN WITH DIFFERENT CAP VALUES." : GOTO 40
