﻿
Imports System.Math

Module filter_coefficients


    Public raw_coefficients(1024), window_coefficients(1024), final_coefficients(2049) As Double
    Public odd_order_filter As Boolean
    Public sample_frequency, stop_band, coefficients, raw_size, fl, fh As Integer
    Public integer_coefficients(2049) As Integer

    Dim pi, low_frequency, high_frequency As Double

    REM  Bessi0  -  Returns in0, Modified Bessel function Io(x) for any real x.
    REM  From Press, et. al., Numerical Recepies in C, 2nd Ed. p237.

    Function bessi0(ByVal value As Double) As Double

        Dim abs_value, answer As Double
        Dim y, a, b, c, d, e As Double

        abs_value = Abs(value)
        If (abs_value < 3.75) Then

            y = value / 3.75
            y *= y
            a = 0.0360768 + (y * 0.0045813)
            b = 0.2659732 + (y * a)
            c = 1.2067492 + (y * b)
            d = 3.0899424 + (y * c)
            e = 3.5156229 + (y * d)
            answer = (1 + (y * e))

        Else

            y = 3.75 / abs_value
            a = y * (-0.01647633 + (y * 0.00392377))
            b = y * (-0.02057706 + (y * (0.02635537 + a)))
            c = -0.00157565 + (y * (0.00916281 + b))
            d = y * (0.00225319 + (y * c))
            e = 0.39894228 + (y * (0.01328592 + d))
            answer = (Exp(abs_value) / Sqrt(abs_value)) * e
        End If
        Return answer
    End Function

    REM   This function calculates a one sided set of coefficients based on the 
    REM general form of a rectangular response of a general "bandpass" filter.

    Sub calculate_coefficients(ByVal low_frequency As Double, ByVal high_frequency As Double)
        Dim array_start As Integer
        Dim filter_width, angle, normalized_angle, index As Double

        filter_width = high_frequency - low_frequency
        If (odd_order_filter) Then
            raw_coefficients(0) = 2.0 * filter_width
            array_start = 1
        Else
            array_start = 0
        End If

        For i As Integer = array_start To raw_size Step 1
            If (odd_order_filter) Then
                index = i
            Else
                index = i + 0.5
            End If

            angle = pi * index
            REM normalize the angle
            normalized_angle = angle * filter_width
            REM calculate the sine contribution
            raw_coefficients(i) = Sin(normalized_angle) / angle
            REM calculate the cosine contribution
            raw_coefficients(i) = raw_coefficients(i) * 2.0 * Cos(angle * (low_frequency + high_frequency))
        Next

        Exit Sub
    End Sub


    Sub adjust_coefficients()

        Dim beta, x, bessel, beta_bessel, db, xi, xind As Double
        Dim j As Integer

        db = stop_band
        REM Find beta, a parameter that determines the out-of-band attenuation.
        If (db > 50) Then
            beta = 0.1102 * (db - 8.7)
        Else
            If ((db > 20.96) And (db <= 50)) Then
                beta = 0.58417 * Pow((db - 20.96), 0.4)
                beta += 0.07886 * (db - 20.96)
            Else
                beta = 0.0
            End If
        End If
        REM Find Kaiser window factors window_coefficients[j) that limit the out-of-band response.
        x = beta
        beta_bessel = bessi0(x)

        xind = ((coefficients - 1) * (coefficients - 1))
        For array_index As Integer = 0 To raw_size Step 1
            If (odd_order_filter) Then
                xi = array_index
            Else
                xi = array_index + 0.5
            End If
            xi = 4.0 * xi * xi
            x = beta * Sqrt(1.0 - (xi / xind))
            bessel = bessi0(x)
            window_coefficients(array_index) = bessel / beta_bessel
        Next

        REM Window the ideal filter response:
        For array_index As Integer = 0 To raw_size - 1 Step 1
            raw_coefficients(array_index) *= window_coefficients(array_index)
        Next
        REM Rearrange to be causal filter coefficients:
        For array_index As Integer = 0 To raw_size - 1 Step 1
            final_coefficients(array_index) = raw_coefficients(raw_size - array_index - 1)
        Next
        If (odd_order_filter) Then
            j = 1
        Else
            j = 0
        End If
        For array_index As Integer = raw_size To coefficients Step 1
            final_coefficients(array_index) = raw_coefficients(j)
            j += 1
        Next
    End Sub
    Sub filter_calculation()

        pi = 3.14159265359
        odd_order_filter = False
        low_frequency = fl / sample_frequency
        high_frequency = fh / sample_frequency
        If ((coefficients And 1) = 1) Then
            odd_order_filter = True
        End If
        raw_size = coefficients >> 1
        If (odd_order_filter) Then
            raw_size += 1
        End If
        REM Calculate the raw coefficients
        calculate_coefficients(low_frequency, high_frequency)

        REM Adjust the coefficients for a kaiser window
        adjust_coefficients()

        For i As Integer = 0 To coefficients - 1 Step 1
            integer_coefficients(i) = (32767.9 * final_coefficients(i))
        Next


    End Sub
End Module
