/*******************************************************************************
* File Name: PWMI.h  
* Version 1.10
*
* Description:
*  Contains the prototypes and constants for the functions available to the 
*  PWM user module.
*
* Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/



#include "cytypes.h"
#include "cyfitter.h"

#if !defined(CY_PWM_PWMI_H)
#define CY_PWM_PWMI_H

#define PWMI_Resolution 8
#define PWMI_UsingFixedFunction 0
#define PWMI_DeadBandMode 0
#define PWMI_KillModeMinTime 0
#define PWMI_KillMode 0
#define PWMI_PWMMode 0
#define PWMI_PWMModeIsCenterAligned 0
#define PWMI_DeadBandUsed 0
#define PWMI_DeadBand2_4 0
#if !defined(PWMI_PWMUDB_sSTSReg_stsreg__REMOVED)
    #define PWMI_UseStatus 1
#else
    #define PWMI_UseStatus 0
#endif
#if !defined(PWMI_PWMUDB_sCTRLReg_ctrlreg__REMOVED)
    #define PWMI_UseControl 1
#else
    #define PWMI_UseControl 0
#endif
#define PWMI_UseOneCompareMode 1
#define PWMI_MinimumKillTime 1
#define PWMI_EnableMode 0

#define PWMI_CompareMode1SW 0
#define PWMI_CompareMode2SW 0

/* Use Kill Mode Enumerated Types */
#define PWMI__B_PWM__DISABLED 0
#define PWMI__B_PWM__ASYNCHRONOUS 1
#define PWMI__B_PWM__SINGLECYCLE 2
#define PWMI__B_PWM__LATCHED 3
#define PWMI__B_PWM__MINTIME 4


/* Use Dead Band Mode Enumerated Types */
#define PWMI__B_PWM__DBMDISABLED 0
#define PWMI__B_PWM__DBM_2_4_CLOCKS 1
#define PWMI__B_PWM__DBM_256_CLOCKS 2


/* Used PWM Mode Enumerated Types */
#define PWMI__B_PWM__ONE_OUTPUT 0
#define PWMI__B_PWM__TWO_OUTPUTS 1
#define PWMI__B_PWM__DUAL_EDGE 2
#define PWMI__B_PWM__CENTER_ALIGN 3
#define PWMI__B_PWM__DITHER 5
#define PWMI__B_PWM__HARDWARESELECT 4


/* Used PWM Compare Mode Enumerated Types */
#define PWMI__B_PWM__LESS_THAN 1
#define PWMI__B_PWM__LESS_THAN_OR_EQUAL 2
#define PWMI__B_PWM__GREATER_THAN 3
#define PWMI__B_PWM__GREATER_THAN_OR_EQUAL_TO 4
#define PWMI__B_PWM__EQUAL 0
#define PWMI__B_PWM__FIRMWARE 5


/***************************************
 *   Function Prototypes
 **************************************/
void    PWMI_Start(void);
void    PWMI_Stop(void);
void    PWMI_SetInterruptMode(uint8 interruptMode);
uint8   PWMI_GetInterruptSource(void);
#if (PWMI_UseStatus || PWMI_UsingFixedFunction)
	uint8   PWMI_ReadStatusRegister(void);
#endif
#if (PWMI_UseControl)
	uint8   PWMI_ReadControlRegister(void);
	void    PWMI_WriteControlRegister(uint8 control);
#endif
#if PWMI_UseOneCompareMode
	#if PWMI_CompareMode1SW
	void    PWMI_SetCompareMode(uint8 comparemode);
	#endif
#else
	#if PWMI_CompareMode1SW
	void    PWMI_SetCompareMode1(uint8 comparemode);
	#endif
	#if PWMI_CompareMode2SW
	void    PWMI_SetCompareMode2(uint8 comparemode);
	#endif
#endif

#if (!PWMI_UsingFixedFunction)
uint8   PWMI_ReadCounter(void);
uint8  PWMI_ReadCapture(void);
#if (PWMI_UseStatus)
void PWMI_ClearFIFO(void);
#endif
#endif

void    PWMI_WriteCounter(uint8 counter);
void    PWMI_WritePeriod(uint8 period);
uint8   PWMI_ReadPeriod(void);
#if PWMI_UseOneCompareMode
    void    PWMI_WriteCompare(uint8 compare);
    uint8   PWMI_ReadCompare(void);
#else
    void    PWMI_WriteCompare1(uint8 compare);
    uint8   PWMI_ReadCompare1(void);
    void    PWMI_WriteCompare2(uint8 compare);
    uint8   PWMI_ReadCompare2(void);
#endif


#if (PWMI_DeadBandUsed)
	void    PWMI_WriteDeadTime(uint8 deadtime);
	uint8   PWMI_ReadDeadTime(void);
#endif

#if ( PWMI_KillModeMinTime)
	void PWMI_WriteKillTime(uint8 killtime);
	uint8 PWMI_ReadKillTime(void);
#endif

/***************************************
 *    Initialization Values
 **************************************/
#define PWMI_INIT_PERIOD_VALUE        1
#define PWMI_INIT_COMPARE_VALUE1      1
#define PWMI_INIT_COMPARE_VALUE2      63
#define PWMI_INIT_INTERRUPTS_MODE     ((0 << PWMI_STATUS_TC_INT_EN_MASK_SHIFT) | (0 << PWMI_STATUS_CMP2_INT_EN_MASK_SHIFT) | (0 << PWMI_STATUS_CMP1_INT_EN_MASK_SHIFT ) | (0 << PWMI_STATUS_KILL_INT_EN_MASK_SHIFT ))
#define PWMI_DEFAULT_COMPARE2_MODE    (1 << PWMI_CTRL_CMPMODE2_SHIFT)
#define PWMI_DEFAULT_COMPARE1_MODE    (1 << PWMI_CTRL_CMPMODE1_SHIFT)
#define PWMI_INIT_DEAD_TIME           1

/********************************
 ******     Registers       *****
 ******************************** */

#if (PWMI_UsingFixedFunction)
   #define PWMI_PERIOD_LSB      (*(reg16 *) PWMI_PWMHW__PER0)
   #define PWMI_PERIOD_LSB_PTR   ((reg16 *) PWMI_PWMHW__PER0)
   #define PWMI_COMPARE1_LSB    (*(reg16 *) PWMI_PWMHW__CNT_CMP0)
   #define PWMI_COMPARE1_LSB_PTR ((reg16 *) PWMI_PWMHW__CNT_CMP0)
   #define PWMI_COMPARE2_LSB     0x00u
   #define PWMI_COMPARE2_LSB_PTR 0x00u
   #define PWMI_COUNTER_LSB     (*(reg16 *) PWMI_PWMHW__CNT_CMP0)
   #define PWMI_COUNTER_LSB_PTR  ((reg16 *) PWMI_PWMHW__CNT_CMP0)
   #define PWMI_CAPTURE_LSB     (*(reg16 *) PWMI_PWMHW__CAP0)
   #define PWMI_CAPTURE_LSB_PTR  ((reg16 *) PWMI_PWMHW__CAP0)
   
#else
   #if(PWMI_PWMModeIsCenterAligned)
       #define PWMI_PERIOD_LSB      (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__D1_REG)
       #define PWMI_PERIOD_LSB_PTR   ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__D1_REG)
   #else
       #define PWMI_PERIOD_LSB      (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__F0_REG)
       #define PWMI_PERIOD_LSB_PTR   ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__F0_REG)
   #endif
   #define PWMI_COMPARE1_LSB    (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__D0_REG)
   #define PWMI_COMPARE1_LSB_PTR ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__D0_REG)
   #define PWMI_COMPARE2_LSB    (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__D1_REG)
   #define PWMI_COMPARE2_LSB_PTR ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__D1_REG)
   #define PWMI_COUNTERCAP_LSB   *(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__A1_REG)
   #define PWMI_COUNTERCAP_LSB_PTR ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__A1_REG)
   #define PWMI_COUNTER_LSB     (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__A0_REG)
   #define PWMI_COUNTER_LSB_PTR  ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__A0_REG)
   #define PWMI_CAPTURE_LSB     (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__F1_REG)
   #define PWMI_CAPTURE_LSB_PTR  ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__F1_REG)
   #define PWMI_AUX_CONTROLDP0      (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__DP_AUX_CTL_REG)
   #define PWMI_AUX_CONTROLDP0_PTR  ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u0__DP_AUX_CTL_REG)
   #if (PWMI_Resolution == 16)
       #define PWMI_AUX_CONTROLDP1    (*(reg8 *) PWMI_PWMUDB_sP8_pwmdp_u1__DP_AUX_CTL_REG)
       #define PWMI_AUX_CONTROLDP1_PTR  ((reg8 *) PWMI_PWMUDB_sP8_pwmdp_u1__DP_AUX_CTL_REG)
   #endif
#endif
   
#if(PWMI_KillModeMinTime )
    #define PWMI_KILLMODEMINTIME      (*(reg8 *) PWMI_PWMUDB_sKM_killmodecounterdp_u0__D0_REG)
    #define PWMI_KILLMODEMINTIME_PTR   ((reg8 *) PWMI_PWMUDB_sKM_killmodecounterdp_u0__D0_REG)
    /* Fixed Function Block has no Kill Mode parameters because it is Asynchronous only */
#endif

#if(PWMI_DeadBandMode == PWMI__B_PWM__DBM_256_CLOCKS)
    #define PWMI_DEADBAND_COUNT        (*(reg8 *) PWMI_PWMUDB_sDB255_deadbandcounterdp_u0__D0_REG)
    #define PWMI_DEADBAND_COUNT_PTR     ((reg8 *) PWMI_PWMUDB_sDB255_deadbandcounterdp_u0__D0_REG)
#elif(PWMI_DeadBandMode == PWMI__B_PWM__DBM_2_4_CLOCKS)
    /* In Fixed Function Block these bits are in the control blocks control register */
    #if (PWMI_UsingFixedFunction)
        #define PWMI_DEADBAND_COUNT        (*(reg8 *) PWMI_PWMHW__CFG0) 
        #define PWMI_DEADBAND_COUNT_PTR     ((reg8 *) PWMI_PWMHW__CFG0)
        #define PWMI_DEADBAND_COUNT_MASK    (0x03u << PWMI_DEADBAND_COUNT_SHIFT) 
        #define PWMI_DEADBAND_COUNT_SHIFT   0x06u /* As defined by the Register Map as DEADBAND_PERIOD[1:0] in CFG0 */ 
    #else
        /* Lower two bits of the added control register define the count 1-3 */
        #define PWMI_DEADBAND_COUNT        (*(reg8 *) PWMI_PWMUDB_sDB3_dbctrlreg__CONTROL_REG)
        #define PWMI_DEADBAND_COUNT_PTR     ((reg8 *) PWMI_PWMUDB_sDB3_dbctrlreg__CONTROL_REG)
        #define PWMI_DEADBAND_COUNT_MASK    (0x03u << PWMI_DEADBAND_COUNT_SHIFT) 
        #define PWMI_DEADBAND_COUNT_SHIFT   0x00u /* As defined by the verilog implementation of the Control Register */
    #endif
#endif



#if (PWMI_UsingFixedFunction)
    #define PWMI_STATUS                (*(reg8 *) PWMI_PWMHW__SR0)
    #define PWMI_STATUS_MASK           (*(reg8 *) PWMI_PWMHW__SR0)
    #define PWMI_CONTROL               (*(reg8 *) PWMI_PWMHW__CFG0)
    #define PWMI_CONTROL2              (*(reg8 *) PWMI_PWMHW__CFG1)
    #define PWMI_GLOBAL_ENABLE         (*(reg8 *) PWMI_PWMHW__PM_ACT_CFG)

    /***********************************
    *     Constants
    ***********************************/
    /* Fixed Function Block Chosen */
    #define PWMI_BLOCK_EN_MASK          PWMI_PWMHW__PM_ACT_MSK
    /* Control Register definitions */
    #define PWMI_CTRL_ENABLE_SHIFT      0x00u
    #define PWMI_CTRL_RESET_SHIFT       0x00u   /* Not available in Fixed Function Block */
    #define PWMI_CTRL_CMPMODE2_SHIFT    0x00u   /* Not available in Fixed Function Block */
    #define PWMI_CTRL_CMPMODE1_SHIFT    0x01u   /* As defined by Register map as MODE_CFG bits in CFG1*/
    #define PWMI_CTRL_DEAD_TIME_SHIFT   0x06u   /* As defined by Register map */
    /* Fixed Function Block Only CFG register bit definitions */
    #define PWMI_CFG0_MODE              0x03u   /* Enable the block to run and set to compare mode */
    #define PWMI_CFG0_DB                0x20u   /* As defined by Register map as DB bit in CFG0 */

    /* Control Register Bit Masks */
    #define PWMI_CTRL_ENABLE            (0x01u << PWMI_CTRL_ENABLE_SHIFT)
    #define PWMI_CTRL_RESET             (0x01u << PWMI_CTRL_RESET_SHIFT)
    #define PWMI_CTRL_CMPMODE2_MASK     (0x07u << PWMI_CTRL_CMPMODE2_SHIFT)
    #define PWMI_CTRL_CMPMODE1_MASK     (0x07u << PWMI_CTRL_CMPMODE1_SHIFT)
    
    /* Control2 Register Bit Masks */
    #define PWMI_CTRL2_IRQ_SEL_SHIFT    0x00u       /* As defined in Register Map, Part of the TMRX_CFG1 register */
    #define PWMI_CTRL2_IRQ_SEL          (0x01u << PWMI_CTRL2_IRQ_SEL_SHIFT)  
    
    /* Status Register Bit Locations */
    #define PWMI_STATUS_KILL_SHIFT          0x00u   /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFONEMPTY_SHIFT    0x00u   /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFOFULL_SHIFT      0x00u   /* Not available in Fixed Function Block */
    #define PWMI_STATUS_TC_SHIFT            0x07u   /* As defined by Register map as TC in SR0 */
    #define PWMI_STATUS_CMP2_SHIFT          0x00u   /* Not available in Fixed Function Block */
    #define PWMI_STATUS_CMP1_SHIFT          0x06u   /* As defined by the Register map as CAP_CMP in SR0 */
    /* Status Register Interrupt Enable Bit Locations */
    #define PWMI_STATUS_KILL_INT_EN_MASK_SHIFT          (0x00u)    /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFONEMPTY_INT_EN_MASK_SHIFT    (0x00u)   /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFOFULL_INT_EN_MASK_SHIFT      (0x00u)   /* Not available in Fixed Function Block */
    #define PWMI_STATUS_TC_INT_EN_MASK_SHIFT            (PWMI_STATUS_TC_SHIFT - 4)
    #define PWMI_STATUS_CMP2_INT_EN_MASK_SHIFT          (0x00u)   /* Not available in Fixed Function Block */
    #define PWMI_STATUS_CMP1_INT_EN_MASK_SHIFT          (PWMI_STATUS_CMP1_SHIFT - 4)
    /* Status Register Bit Masks */
    #define PWMI_STATUS_KILL            (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFONEMPTY      (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFOFULL        (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_TC              (0x01u << PWMI_STATUS_TC_SHIFT)
    #define PWMI_STATUS_CMP2            (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_CMP1            (0x01u << PWMI_STATUS_CMP1_SHIFT)
    /* Status Register Interrupt Bit Masks*/
    #define PWMI_STATUS_KILL_INT_EN_MASK            (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFONEMPTY_INT_EN_MASK      (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_FIFOFULL_INT_EN_MASK        (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_TC_INT_EN_MASK              (PWMI_STATUS_TC >> 4)
    #define PWMI_STATUS_CMP2_INT_EN_MASK            (0x00u) /* Not available in Fixed Function Block */
    #define PWMI_STATUS_CMP1_INT_EN_MASK            (PWMI_STATUS_CMP1 >> 4)

    /* Datapath Auxillary Control Register definitions */
    //#define PWMI_AUX_CTRL_FIFO0_CLR         0x01u   /* As defined by Register map */
    //#define PWMI_AUX_CTRL_FIFO1_CLR       0x02u   /* As defined by Register map */
    //#define PWMI_AUX_CTRL_FIFO0_LVL       0x04u   /* As defined by Register map */
    //#define PWMI_AUX_CTRL_FIFO1_LVL       0x08u   /* As defined by Register map */
    //#define PWMI_STATUS_ACTL_INT_EN_MASK    0x10u   /* As defined for the ACTL Register */
#else
    #define PWMI_STATUS                (*(reg8 *) PWMI_PWMUDB_sSTSReg_stsreg__STATUS_REG )
    #define PWMI_STATUS_MASK           (*(reg8 *) PWMI_PWMUDB_sSTSReg_stsreg__MASK_REG)
    #define PWMI_STATUS_AUX_CTRL       (*(reg8 *) PWMI_PWMUDB_sSTSReg_stsreg__STATUS_AUX_CTL_REG)
    #define PWMI_CONTROL               (*(reg8 *) PWMI_PWMUDB_sCTRLReg_ctrlreg__CONTROL_REG)
    /***********************************
    *     Constants
    ***********************************/
    /* Control Register definitions */
    #define PWMI_CTRL_ENABLE_SHIFT      0x07u
    #define PWMI_CTRL_RESET_SHIFT       0x06u
    #define PWMI_CTRL_CMPMODE2_SHIFT    0x03u
    #define PWMI_CTRL_CMPMODE1_SHIFT    0x00u
	#define PWMI_CTRL_DEAD_TIME_SHIFT   0x00u   /* No Shift Needed for UDB block */
    /* Control Register Bit Masks */
    #define PWMI_CTRL_ENABLE            (0x01u << PWMI_CTRL_ENABLE_SHIFT)
    #define PWMI_CTRL_RESET             (0x01u << PWMI_CTRL_RESET_SHIFT)
    #define PWMI_CTRL_CMPMODE2_MASK     (0x07u << PWMI_CTRL_CMPMODE2_SHIFT)
    #define PWMI_CTRL_CMPMODE1_MASK     (0x07u << PWMI_CTRL_CMPMODE1_SHIFT) 
    
    /* Status Register Bit Locations */
    #define PWMI_STATUS_KILL_SHIFT          0x05u
    #define PWMI_STATUS_FIFONEMPTY_SHIFT    0x04u
    #define PWMI_STATUS_FIFOFULL_SHIFT      0x03u  
    #define PWMI_STATUS_TC_SHIFT            0x02u
    #define PWMI_STATUS_CMP2_SHIFT          0x01u
    #define PWMI_STATUS_CMP1_SHIFT          0x00u
    /* Status Register Interrupt Enable Bit Locations - UDB Status Interrupt Mask match Status Bit Locations*/
    #define PWMI_STATUS_KILL_INT_EN_MASK_SHIFT          PWMI_STATUS_KILL_SHIFT          
    #define PWMI_STATUS_FIFONEMPTY_INT_EN_MASK_SHIFT    PWMI_STATUS_FIFONEMPTY_SHIFT    
    #define PWMI_STATUS_FIFOFULL_INT_EN_MASK_SHIFT      PWMI_STATUS_FIFOFULL_SHIFT        
    #define PWMI_STATUS_TC_INT_EN_MASK_SHIFT            PWMI_STATUS_TC_SHIFT            
    #define PWMI_STATUS_CMP2_INT_EN_MASK_SHIFT          PWMI_STATUS_CMP2_SHIFT          
    #define PWMI_STATUS_CMP1_INT_EN_MASK_SHIFT          PWMI_STATUS_CMP1_SHIFT   
    /* Status Register Bit Masks */
    #define PWMI_STATUS_KILL            (0x00u << PWMI_STATUS_KILL_SHIFT )
    #define PWMI_STATUS_FIFOFULL        (0x01u << PWMI_STATUS_FIFOFULL_SHIFT)
    #define PWMI_STATUS_FIFONEMPTY      (0x01u << PWMI_STATUS_FIFONEMPTY_SHIFT)
    #define PWMI_STATUS_TC              (0x01u << PWMI_STATUS_TC_SHIFT)
    #define PWMI_STATUS_CMP2            (0x01u << PWMI_STATUS_CMP2_SHIFT) 
    #define PWMI_STATUS_CMP1            (0x01u << PWMI_STATUS_CMP1_SHIFT)
    /* Status Register Interrupt Bit Masks  - UDB Status Interrupt Mask match Status Bit Locations */
    #define PWMI_STATUS_KILL_INT_EN_MASK            PWMI_STATUS_KILL
    #define PWMI_STATUS_FIFOFULL_INT_EN_MASK        PWMI_STATUS_FIFOFULL
    #define PWMI_STATUS_FIFONEMPTY_INT_EN_MASK      PWMI_STATUS_FIFONEMPTY
    #define PWMI_STATUS_TC_INT_EN_MASK              PWMI_STATUS_TC
    #define PWMI_STATUS_CMP2_INT_EN_MASK            PWMI_STATUS_CMP2
    #define PWMI_STATUS_CMP1_INT_EN_MASK            PWMI_STATUS_CMP1
                                                          
    /* Datapath Auxillary Control Register definitions */
    #define PWMI_AUX_CTRL_FIFO0_CLR     0x01u
    #define PWMI_AUX_CTRL_FIFO1_CLR     0x02u
    #define PWMI_AUX_CTRL_FIFO0_LVL     0x04u
    #define PWMI_AUX_CTRL_FIFO1_LVL     0x08u
    #define PWMI_STATUS_ACTL_INT_EN_MASK  0x10u /* As defined for the ACTL Register */
#endif /* PWMI_UsingFixedFunction */

#endif  /* CY_PWM_PWMI_H */
