/*******************************************************************************
* File Name: CG_SCL.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_CG_SCL_H) /* Pins CG_SCL_H */
#define CY_PINS_CG_SCL_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "CG_SCL_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    CG_SCL_Write(uint8 value) ;
void    CG_SCL_SetDriveMode(uint8 mode) ;
uint8   CG_SCL_ReadDataReg(void) ;
uint8   CG_SCL_Read(void) ;
uint8   CG_SCL_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define CG_SCL_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define CG_SCL_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define CG_SCL_DM_RES_UP          PIN_DM_RES_UP
#define CG_SCL_DM_RES_DWN         PIN_DM_RES_DWN
#define CG_SCL_DM_OD_LO           PIN_DM_OD_LO
#define CG_SCL_DM_OD_HI           PIN_DM_OD_HI
#define CG_SCL_DM_STRONG          PIN_DM_STRONG
#define CG_SCL_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define CG_SCL_MASK               CG_SCL__MASK
#define CG_SCL_SHIFT              CG_SCL__SHIFT
#define CG_SCL_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define CG_SCL_PS                     (* (reg8 *) CG_SCL__PS)
/* Data Register */
#define CG_SCL_DR                     (* (reg8 *) CG_SCL__DR)
/* Port Number */
#define CG_SCL_PRT_NUM                (* (reg8 *) CG_SCL__PRT) 
/* Connect to Analog Globals */                                                  
#define CG_SCL_AG                     (* (reg8 *) CG_SCL__AG)                       
/* Analog MUX bux enable */
#define CG_SCL_AMUX                   (* (reg8 *) CG_SCL__AMUX) 
/* Bidirectional Enable */                                                        
#define CG_SCL_BIE                    (* (reg8 *) CG_SCL__BIE)
/* Bit-mask for Aliased Register Access */
#define CG_SCL_BIT_MASK               (* (reg8 *) CG_SCL__BIT_MASK)
/* Bypass Enable */
#define CG_SCL_BYP                    (* (reg8 *) CG_SCL__BYP)
/* Port wide control signals */                                                   
#define CG_SCL_CTL                    (* (reg8 *) CG_SCL__CTL)
/* Drive Modes */
#define CG_SCL_DM0                    (* (reg8 *) CG_SCL__DM0) 
#define CG_SCL_DM1                    (* (reg8 *) CG_SCL__DM1)
#define CG_SCL_DM2                    (* (reg8 *) CG_SCL__DM2) 
/* Input Buffer Disable Override */
#define CG_SCL_INP_DIS                (* (reg8 *) CG_SCL__INP_DIS)
/* LCD Common or Segment Drive */
#define CG_SCL_LCD_COM_SEG            (* (reg8 *) CG_SCL__LCD_COM_SEG)
/* Enable Segment LCD */
#define CG_SCL_LCD_EN                 (* (reg8 *) CG_SCL__LCD_EN)
/* Slew Rate Control */
#define CG_SCL_SLW                    (* (reg8 *) CG_SCL__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define CG_SCL_PRTDSI__CAPS_SEL       (* (reg8 *) CG_SCL__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define CG_SCL_PRTDSI__DBL_SYNC_IN    (* (reg8 *) CG_SCL__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define CG_SCL_PRTDSI__OE_SEL0        (* (reg8 *) CG_SCL__PRTDSI__OE_SEL0) 
#define CG_SCL_PRTDSI__OE_SEL1        (* (reg8 *) CG_SCL__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define CG_SCL_PRTDSI__OUT_SEL0       (* (reg8 *) CG_SCL__PRTDSI__OUT_SEL0) 
#define CG_SCL_PRTDSI__OUT_SEL1       (* (reg8 *) CG_SCL__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define CG_SCL_PRTDSI__SYNC_OUT       (* (reg8 *) CG_SCL__PRTDSI__SYNC_OUT) 


#if defined(CG_SCL__INTSTAT)  /* Interrupt Registers */

    #define CG_SCL_INTSTAT                (* (reg8 *) CG_SCL__INTSTAT)
    #define CG_SCL_SNAP                   (* (reg8 *) CG_SCL__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins CG_SCL_H */


/* [] END OF FILE */
