/*******************************************************************************
* File Name: USBFS_1_Dp.h  
* Version 1.60
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_USBFS_1_Dp_H) /* Pins USBFS_1_Dp_H */
#define CY_PINS_USBFS_1_Dp_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "USBFS_1_Dp_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    USBFS_1_Dp_Write(uint8 value) ;
void    USBFS_1_Dp_SetDriveMode(uint8 mode) ;
uint8   USBFS_1_Dp_ReadDataReg(void) ;
uint8   USBFS_1_Dp_Read(void) ;
uint8   USBFS_1_Dp_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define USBFS_1_Dp_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define USBFS_1_Dp_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define USBFS_1_Dp_DM_RES_UP          PIN_DM_RES_UP
#define USBFS_1_Dp_DM_RES_DWN         PIN_DM_RES_DWN
#define USBFS_1_Dp_DM_OD_LO           PIN_DM_OD_LO
#define USBFS_1_Dp_DM_OD_HI           PIN_DM_OD_HI
#define USBFS_1_Dp_DM_STRONG          PIN_DM_STRONG
#define USBFS_1_Dp_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define USBFS_1_Dp_MASK               USBFS_1_Dp__MASK
#define USBFS_1_Dp_SHIFT              USBFS_1_Dp__SHIFT
#define USBFS_1_Dp_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define USBFS_1_Dp_PS                     (* (reg8 *) USBFS_1_Dp__PS)
/* Data Register */
#define USBFS_1_Dp_DR                     (* (reg8 *) USBFS_1_Dp__DR)
/* Port Number */
#define USBFS_1_Dp_PRT_NUM                (* (reg8 *) USBFS_1_Dp__PRT) 
/* Connect to Analog Globals */                                                  
#define USBFS_1_Dp_AG                     (* (reg8 *) USBFS_1_Dp__AG)                       
/* Analog MUX bux enable */
#define USBFS_1_Dp_AMUX                   (* (reg8 *) USBFS_1_Dp__AMUX) 
/* Bidirectional Enable */                                                        
#define USBFS_1_Dp_BIE                    (* (reg8 *) USBFS_1_Dp__BIE)
/* Bit-mask for Aliased Register Access */
#define USBFS_1_Dp_BIT_MASK               (* (reg8 *) USBFS_1_Dp__BIT_MASK)
/* Bypass Enable */
#define USBFS_1_Dp_BYP                    (* (reg8 *) USBFS_1_Dp__BYP)
/* Port wide control signals */                                                   
#define USBFS_1_Dp_CTL                    (* (reg8 *) USBFS_1_Dp__CTL)
/* Drive Modes */
#define USBFS_1_Dp_DM0                    (* (reg8 *) USBFS_1_Dp__DM0) 
#define USBFS_1_Dp_DM1                    (* (reg8 *) USBFS_1_Dp__DM1)
#define USBFS_1_Dp_DM2                    (* (reg8 *) USBFS_1_Dp__DM2) 
/* Input Buffer Disable Override */
#define USBFS_1_Dp_INP_DIS                (* (reg8 *) USBFS_1_Dp__INP_DIS)
/* LCD Common or Segment Drive */
#define USBFS_1_Dp_LCD_COM_SEG            (* (reg8 *) USBFS_1_Dp__LCD_COM_SEG)
/* Enable Segment LCD */
#define USBFS_1_Dp_LCD_EN                 (* (reg8 *) USBFS_1_Dp__LCD_EN)
/* Slew Rate Control */
#define USBFS_1_Dp_SLW                    (* (reg8 *) USBFS_1_Dp__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define USBFS_1_Dp_PRTDSI__CAPS_SEL       (* (reg8 *) USBFS_1_Dp__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define USBFS_1_Dp_PRTDSI__DBL_SYNC_IN    (* (reg8 *) USBFS_1_Dp__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define USBFS_1_Dp_PRTDSI__OE_SEL0        (* (reg8 *) USBFS_1_Dp__PRTDSI__OE_SEL0) 
#define USBFS_1_Dp_PRTDSI__OE_SEL1        (* (reg8 *) USBFS_1_Dp__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define USBFS_1_Dp_PRTDSI__OUT_SEL0       (* (reg8 *) USBFS_1_Dp__PRTDSI__OUT_SEL0) 
#define USBFS_1_Dp_PRTDSI__OUT_SEL1       (* (reg8 *) USBFS_1_Dp__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define USBFS_1_Dp_PRTDSI__SYNC_OUT       (* (reg8 *) USBFS_1_Dp__PRTDSI__SYNC_OUT) 


#if defined(USBFS_1_Dp__INTSTAT)  /* Interrupt Registers */

    #define USBFS_1_Dp_INTSTAT                (* (reg8 *) USBFS_1_Dp__INTSTAT)
    #define USBFS_1_Dp_SNAP                   (* (reg8 *) USBFS_1_Dp__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins USBFS_1_Dp_H */


/* [] END OF FILE */
