﻿using System;
using System.Windows.Forms;

namespace ABCDmatrix
{
    public partial class FixedParameterentry : Form
    {
            private Boolean polarFormat;
            private Tile tile;
        
        /// <summary>
        /// Allow entry of S- Z- Y- and ABCDparam matrix elements that
        /// are fixed with respect to frequency (i.e. are for single
        /// frequency analysis).
        /// 'tile' is the one that we will provide parameters for
        /// 'mode' is the network type we are entering parameters for.
        /// </summary>
        /// <param name="targettile"></param>
        public FixedParameterentry(Tile targettile)
        {
            InitializeComponent();
 
            tile = targettile;
            polarFormat = true;     // initial menu format

            switch ((int)tile.BlockType)
            {
                case (int)NetworkType.Sparam: label11.Text = "S11";
                    label21.Text = "S21";
                    label12.Text = "S12";
                    label22.Text = "S22";
                    //referenceZtextbox.Enabled = true;
                    break;
                case (int)NetworkType.Zparam: label11.Text = "Z11";
                    label21.Text = "Z21";
                    label12.Text = "Z12";
                    label22.Text = "Z22";
                    //referenceZtextbox.Enabled = false;
                    break;
                case (int)NetworkType.Yparam: label11.Text = "Y11";
                    label21.Text = "Y21";
                    label12.Text = "Y12";
                    label22.Text = "Y22";
                    //referenceZtextbox.Enabled = false;
                    break;
                case (int)NetworkType.ABCDparam: label11.Text = "A";
                    label21.Text = "B";
                    label12.Text = "C";
                    label22.Text = "D";
                    referenceZtextbox.Enabled = false;
                    break;
                default: throw new ArgumentException("FixedParameterEntry: unknown network type");
            }
            Refresh();
        }

        private void FormatToggled(object sender, EventArgs e)
        {
            if (RectangularButton.Checked)
            {
                polarFormat = false;
                FirstColumnLabel.Text = "Real, Linear units";
                SecondColumnLabel.Text = "Imaginary, Linear units";
            }
            else
            {
                polarFormat = true;
                FirstColumnLabel.Text = "Magnitude, dB.";
                SecondColumnLabel.Text = "Angle, Degrees";
            }
            Refresh();
        }

        private void OKClick(object sender, EventArgs e)
        {
            if (polarFormat)    //polar format data entry
            {
                Double mag, angle;

                try
                {
                    // convert mag from dB to linear
                    mag = Math.Pow(10,Convert.ToDouble(textBox11col1.Text)/20);
                    // convert degrees to radians
                    angle = Math.PI / 180 * Convert.ToDouble(textBox11col2.Text);
                    tile.FixedParam.P11A.real = mag * Math.Cos(angle);
                    tile.FixedParam.P11A.imag = mag * Math.Sin(angle);

                    mag = Math.Pow(10, Convert.ToDouble(textBox21col1.Text) / 20);
                    angle = Math.PI / 180 * Convert.ToDouble(textBox21col2.Text);
                    tile.FixedParam.P21C.real = mag * Math.Cos(angle);
                    tile.FixedParam.P21C.imag = mag * Math.Sin(angle);

                    mag = Math.Pow(10, Convert.ToDouble(textBox22col1.Text) / 20);
                    angle = Math.PI / 180 * Convert.ToDouble(textBox22col2.Text);
                    tile.FixedParam.P22D.real = mag * Math.Cos(angle);
                    tile.FixedParam.P22D.imag = mag * Math.Sin(angle);

                    mag = Math.Pow(10, Convert.ToDouble(textBox12col1.Text) / 20);
                    angle = Math.PI / 180 * Convert.ToDouble(textBox12col2.Text);
                    tile.FixedParam.P12B.real = mag * Math.Cos(angle);
                    tile.FixedParam.P12B.imag = mag * Math.Sin(angle);

                    tile.ReferenceResistance = Convert.ToDouble(referenceZtextbox.Text);

                    DialogResult = DialogResult.OK; // form can close with OK
                }
                catch (FormatException f)
                {
                    MessageBox.Show("Invalid numeric format", f.Message,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            else
            {
                // rectangular format data entry
                try
                {
                    tile.FixedParam.P11A.real = Convert.ToDouble(textBox11col1.Text);
                    tile.FixedParam.P11A.imag = Convert.ToDouble(textBox11col2.Text);
                    tile.FixedParam.P21C.real = Convert.ToDouble(textBox21col1.Text);
                    tile.FixedParam.P21C.imag = Convert.ToDouble(textBox21col2.Text);
                    tile.FixedParam.P22D.real = Convert.ToDouble(textBox22col1.Text);
                    tile.FixedParam.P22D.imag = Convert.ToDouble(textBox22col2.Text);
                    tile.FixedParam.P12B.real = Convert.ToDouble(textBox12col1.Text);
                    tile.FixedParam.P12B.imag = Convert.ToDouble(textBox12col2.Text);

                    tile.ReferenceResistance = Convert.ToDouble(referenceZtextbox.Text);

                    DialogResult = DialogResult.OK; // form can close with OK
                }
                catch (FormatException f)
                {
                    MessageBox.Show("Invalid numeric format",f.Message,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);    // Require user to correct entries,
                                                                        // form does not close
                }
            }
        }
    }
}
