#! /usr/bin/octave -qf
# Table 2
# Octave Code for SWR Circle Diagram
#
printf("\n\n    *** SWR CIRCLE DIAGRAM ***\n");

swr = input("\n\n ENTER SWR: ");
Zo = input("\n  ENTER Zo: ");

# Calculate an SWR circle for the specified SWR and Zo.

radius = Zo * (swr - 1 / swr) / 2;
center = Zo * swr - radius;
angl = linspace(0, 2 * pi, 100);
x = radius * cos(angl) + center;
y = radius * sin(angl);
y_center = 0;

# Set up plot parameters and plot SWR circle.

title "SWR CIRCLE";
xlabel "REAL Z";
ylabel "IMAG Z";
if ((Zo * (1.1 * swr)) < 220)
  gset xtics 5;
  gset ytics 5;
elseif((Zo * (1.1 * swr)) < 440)
  gset xtics 10;
  gset ytics 10;
elseif((Zo * (1.1 * swr)) < 660)
  gset xtics 20;
  gset ytics 20;
elseif((Zo * (1.1 * swr)) < 880)
  gset xtics 50;
  gset ytics 50;
endif
gset mxtics 5;
gset mytics 5;
grid("on");
axis([((Zo * 1.1 * swr) - 2.5 * radius), Zo * (1.1 * swr), \
  -abs(1.1 * max(y)), abs(1.1 * max(y))]);
plot(x, y, '-', center, y_center, '+');
pause;

