unit tgn_Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Extractor, showtraffic1, ExtCtrls, Buttons;

type
  TkiaCOM = class(TForm)
    gbStrigs: TGroupBox;
    lbLog: TListBox;
    btnPort: TButton;
    btnConnect: TButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    Button5: TButton;
    RadioGroup5: TRadioGroup;
    Button6: TButton;
    Edit1: TEdit;
    Image1: TImage;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure btnPortClick(Sender: TObject);
    procedure btnConnectClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure RadioGroup5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    Rig_Info : RigData;
    procedure AddString;
    procedure ShowInfo;

  public
    { Public declarations }
  end;

var
  kiaCOM: TkiaCOM;

implementation

{$R *.DFM}


procedure TkiaCOM.FormCreate(Sender: TObject);
begin
  Rig_Info := RigData.Create(Self, 'GPS_COM');
  Rig_Info.OnInputStr := AddString;
  Rig_Info.OnNewPosition := ShowInfo;
  Rig_Info.Active := True;
end;                                            

procedure TkiaCOM.RadioGroup5Click(Sender: TObject);
var
mode:integer;
begin
  if RadioGroup5.ItemIndex>=0  then
    begin
      mode :=RadioGroup5.ItemIndex + 1;
      Rig_Info.Comport.WriteStr('MD'+inttostr(mode)+';')
    end;
end;

procedure TkiaCOM.AddString;
begin
  with lbLog do ItemIndex := Items.Add(Rig_Info.InputStr);
end;

procedure TkiaCOM.ShowInfo;
begin
  label1.Caption:=Rig_Info.frequency;
end;

procedure TkiaCOM.btnPortClick(Sender: TObject);
begin
  Rig_Info.Comport.ShowSetupDialog;
end;

procedure TkiaCOM.Button1Click(Sender: TObject);
begin
  Rig_Info.Comport.WriteStr('FA;');
end;

procedure TkiaCOM.Button2Click(Sender: TObject);
begin
  Rig_Info.Comport.WriteStr('MD3;');
end;

procedure TkiaCOM.Button3Click(Sender: TObject);
begin
  Rig_Info.Comport.WriteStr('AI2;');
end;

procedure TkiaCOM.Button4Click(Sender: TObject);
begin
  Showtraffic.visible:=true;
end;

procedure TkiaCOM.Button5Click(Sender: TObject);
begin
  showinfo;
end;

procedure TkiaCOM.Button6Click(Sender: TObject);
var
Command:string;
begin
   Command:=trim(edit1.Text);
   Rig_Info.Comport.WriteStr(Command);
end;

procedure TkiaCOM.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TkiaCOM.btnConnectClick(Sender: TObject);
begin
  Rig_Info.Active := True;
  sleep(50);
  Rig_Info.Comport.WriteStr('AI2;');  //auto function in Kenwood
  Rig_Info.Comport.WriteStr('MD;');
  Rig_Info.Comport.WriteStr('FA;');
 // Rig_Info.Comport.WriteStr('FB;');    //to control Kenwood 'B' vfo
end;

end.
