VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.ocx"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "mscomm32.ocx"
Begin VB.Form Form1 
   AutoRedraw      =   -1  'True
   BorderStyle     =   1  'Fixed Single
   Caption         =   "VB Command and Control"
   ClientHeight    =   4590
   ClientLeft      =   150
   ClientTop       =   840
   ClientWidth     =   9510
   ForeColor       =   &H000000FF&
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   306
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   634
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox Picture1 
      Height          =   735
      Left            =   3120
      Picture         =   "CC.frx":0000
      ScaleHeight     =   675
      ScaleWidth      =   3075
      TabIndex        =   42
      Top             =   3000
      Width           =   3135
   End
   Begin VB.Frame Frame1 
      Caption         =   "Shift"
      Height          =   615
      Left            =   6360
      TabIndex        =   38
      ToolTipText     =   "Change frequency shift amount"
      Top             =   3000
      Width           =   2895
      Begin VB.OptionButton Option3 
         Caption         =   "Large"
         Height          =   255
         Left            =   1920
         TabIndex        =   41
         Top             =   240
         Width           =   735
      End
      Begin VB.OptionButton Option2 
         Caption         =   "Medium"
         Height          =   255
         Left            =   960
         TabIndex        =   40
         Top             =   240
         Width           =   855
      End
      Begin VB.OptionButton Option1 
         Caption         =   "Small"
         Height          =   255
         Left            =   240
         TabIndex        =   39
         Top             =   240
         Value           =   -1  'True
         Width           =   735
      End
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Decrease Freq"
      Height          =   495
      Left            =   6600
      TabIndex        =   37
      ToolTipText     =   "Manual Frequency Decrease"
      Top             =   3960
      Width           =   975
   End
   Begin VB.Timer Timer1 
      Interval        =   1000
      Left            =   2400
      Top             =   3600
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   4680
      TabIndex        =   35
      Text            =   "Text3"
      Top             =   3840
      Visible         =   0   'False
      Width           =   1215
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Command2"
      Height          =   255
      Left            =   5760
      TabIndex        =   34
      TabStop         =   0   'False
      Top             =   2760
      Visible         =   0   'False
      Width           =   375
   End
   Begin VB.TextBox Text2 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   24
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   570
      Left            =   2400
      TabIndex        =   32
      Text            =   "Text2"
      Top             =   1800
      Visible         =   0   'False
      Width           =   3135
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Increase Freq"
      Height          =   495
      Left            =   8160
      TabIndex        =   31
      ToolTipText     =   "Manual Frequency Increase"
      Top             =   3960
      Width           =   975
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   3000
      Top             =   3480
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
      BaudRate        =   57600
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   3840
      TabIndex        =   30
      Text            =   "Text1"
      Top             =   3360
      Visible         =   0   'False
      Width           =   1575
   End
   Begin VB.Frame Frame4 
      Caption         =   "Engine Creation"
      Height          =   615
      Left            =   7920
      TabIndex        =   28
      Top             =   480
      Width           =   1455
      Begin VB.OptionButton SharedRC 
         Caption         =   "Shared"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   240
         Value           =   -1  'True
         Width           =   975
      End
   End
   Begin VB.CheckBox ActivateMic 
      Caption         =   "Activate Mic"
      Height          =   255
      Left            =   7920
      TabIndex        =   27
      Top             =   120
      Value           =   1  'Checked
      Width           =   1335
   End
   Begin VB.CommandButton ClearTree 
      Caption         =   "Clear Recognized Commands"
      Height          =   495
      Left            =   1560
      TabIndex        =   21
      Top             =   3000
      Width           =   1455
   End
   Begin MSComctlLib.TreeView TreeView1 
      Height          =   1215
      Left            =   120
      TabIndex        =   26
      Top             =   0
      Width           =   6015
      _ExtentX        =   10610
      _ExtentY        =   2143
      _Version        =   393217
      LineStyle       =   1
      Style           =   7
      Appearance      =   1
   End
   Begin VB.CommandButton ExitBtn 
      Caption         =   "Exit"
      Height          =   495
      Left            =   5280
      TabIndex        =   22
      Top             =   3960
      Width           =   975
   End
   Begin VB.CommandButton ClearEvents 
      Caption         =   "Clear Events"
      Height          =   495
      Left            =   120
      TabIndex        =   20
      Top             =   3000
      Width           =   1335
   End
   Begin MSComDlg.CommonDialog ComDlg 
      Left            =   8760
      Top             =   1080
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame Frame2 
      Caption         =   "Recognition Type"
      Height          =   615
      Left            =   6240
      TabIndex        =   23
      Top             =   480
      Width           =   1575
      Begin VB.OptionButton CandC 
         Caption         =   "C&&C"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   240
         Value           =   -1  'True
         Width           =   735
      End
   End
   Begin VB.CommandButton Recognition 
      Caption         =   "Recognition ON"
      Height          =   375
      Left            =   6240
      TabIndex        =   1
      ToolTipText     =   "Turn On/Off Voice Command"
      Top             =   0
      Width           =   1575
   End
   Begin VB.TextBox EventTextField 
      Height          =   1335
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   1440
      Width           =   6015
   End
   Begin VB.Frame Frame3 
      Caption         =   "Event Interests"
      Height          =   2655
      Left            =   6240
      TabIndex        =   25
      Top             =   1800
      Visible         =   0   'False
      Width           =   3135
      Begin VB.CheckBox StreamStart 
         Caption         =   "Stream Start"
         Height          =   255
         Left            =   1560
         TabIndex        =   19
         Top             =   2160
         Width           =   1215
      End
      Begin VB.CheckBox StreamEnd 
         Caption         =   "Stream End"
         Height          =   255
         Left            =   1560
         TabIndex        =   18
         Top             =   1920
         Width           =   1215
      End
      Begin VB.CheckBox StateChange 
         Caption         =   "State Change"
         Height          =   255
         Left            =   1560
         TabIndex        =   17
         Top             =   1680
         Width           =   1455
      End
      Begin VB.CheckBox SoundStart 
         Caption         =   "Sound Start"
         Height          =   255
         Left            =   1560
         TabIndex        =   16
         Top             =   1440
         Width           =   1215
      End
      Begin VB.CheckBox SoundEnd 
         Caption         =   "Sound End"
         Height          =   255
         Left            =   1560
         TabIndex        =   15
         Top             =   1200
         Width           =   1215
      End
      Begin VB.CheckBox RequestUI 
         Caption         =   "Request UI"
         Height          =   255
         Left            =   1560
         TabIndex        =   14
         Top             =   960
         Width           =   1215
      End
      Begin VB.CheckBox Reco 
         Caption         =   "Recognition"
         Height          =   255
         Left            =   1560
         TabIndex        =   12
         Top             =   360
         Width           =   1215
      End
      Begin VB.CheckBox PropertyStringChange 
         Caption         =   "Property String Change"
         Height          =   375
         Left            =   120
         TabIndex        =   11
         Top             =   2160
         Width           =   1335
      End
      Begin VB.CheckBox PhraseStart 
         Caption         =   "Phrase Start"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   1680
         Width           =   1215
      End
      Begin VB.CheckBox Interference 
         Caption         =   "Interference"
         Height          =   255
         Left            =   120
         TabIndex        =   8
         Top             =   1440
         Width           =   1215
      End
      Begin VB.CheckBox FalseReco 
         Caption         =   "False Recognition"
         Height          =   375
         Left            =   120
         TabIndex        =   6
         Top             =   840
         Width           =   1335
      End
      Begin VB.CheckBox Bookmark 
         Caption         =   "Bookmark"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   600
         Width           =   1215
      End
      Begin VB.CheckBox Adaption 
         Caption         =   "Adaptation"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         Top             =   360
         Width           =   1215
      End
      Begin VB.CheckBox RecoOther 
         Caption         =   "Reco Other Context"
         Height          =   375
         Left            =   1560
         TabIndex        =   13
         Top             =   600
         Width           =   1215
      End
      Begin VB.CheckBox Hypothesis 
         Caption         =   "Hypothesis"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   1200
         Width           =   1335
      End
      Begin VB.CheckBox PrivateEng 
         Caption         =   "Private"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   1920
         Width           =   1215
      End
   End
   Begin VB.Label Label4 
      BackColor       =   &H80000018&
      Caption         =   "Label4"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   24
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   6240
      TabIndex        =   43
      Top             =   2160
      Width           =   3135
   End
   Begin VB.Label Label3 
      Caption         =   "Only the frequency and color commands work with this example"
      ForeColor       =   &H000000FF&
      Height          =   495
      Left            =   6360
      TabIndex        =   36
      Top             =   1440
      Width           =   2895
   End
   Begin VB.Label Label2 
      Caption         =   "recognition"
      Height          =   255
      Left            =   240
      TabIndex        =   33
      Top             =   4320
      Width           =   3615
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "command"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   14.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   330
      Left            =   240
      TabIndex        =   29
      Top             =   3840
      Width           =   1260
   End
   Begin VB.Label CCLabel 
      Caption         =   "Current C&C Grammar:"
      Height          =   495
      Left            =   6240
      TabIndex        =   24
      Top             =   1200
      Width           =   3015
   End
   Begin VB.Menu File 
      Caption         =   "&File"
      Begin VB.Menu Exit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu Help 
      Caption         =   "&Help"
      Begin VB.Menu About 
         Caption         =   "&About"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=============================================================================
'
' This Command and Control example demonstrates most of the SR functionalities
' supported in SAPI 5.1 and a simple interface to Kenwood radios.
' The main object used here for the RecoContext is RC.
' Certain parts of this demonstration was derived from RecoVB App; an example from the
' Microsoft SDK
' Copyright @ 2001 Microsoft Corporation All Rights Reserved.
'
'=============================================================================

Option Explicit

Public WithEvents RC As SpSharedRecoContext 'The main shared Recognizer Context
Attribute RC.VB_VarHelpID = -1
Public Grammar As ISpeechRecoGrammar        'Command and Control interface
Dim indent As Integer                       'Sets indent level for small output window
Dim fRecoEnabled As Boolean                 'Is recognition enabled
Dim fGrammarLoaded As Boolean               'Is a grammar loaded
Dim RecoResult As ISpeechRecoResult         'Recognition result interface

Dim LastMode As String
Dim LastBand As Byte
Dim LastX As Integer
Dim DisableTimer As String 'Boolean
Dim ComPort As String
Dim xx As String
Dim xxx As String
Const XOFS = 360
Const XFAC = 20

Private Sub Dict_Click()
End Sub
Private Sub Command1_Click()

Dim Freq, F As Double
Dim Counter As Integer
Dim CommandString As String
Dim freq2 As Long
Dim freq3 As String

    MSComm1.RTSEnable = True
    MSComm1.InBufferCount = 0
        
    CommandString = "FA"
    
    If (Form1.Option1.Value) Then
      freq2 = Val(Text2.Text) + 1000  'add 1 Khz
    End If
    If (Form1.Option2.Value) Then
      freq2 = Val(Text2.Text) + 10000 'add 10 Khz
    End If
    If (Form1.Option3.Value) Then
      freq2 = Val(Text2.Text) + 100000 'add 100 Khz
    End If
     
    freq3 = Format(freq2, "###########")
    
    Do While Len(freq3) < 11 'ensure that 11 digits are present
    freq3 = "0" + freq3
    Loop
    
    CommandString = CommandString + freq3 + ";"
    
    MSComm1.RTSEnable = True
    MSComm1.InBufferCount = 0
    MSComm1.Output = CommandString
    
   Counter = 0
    Do
      Counter = Counter + 1
    Loop Until MSComm1.InBufferCount > 13 Or Counter > 20000
     If Counter >= 20000 Then
        GoTo skip
    End If
    
    xx = MSComm1.Input      ' get the data
    Freq = Mid$(xx, 1, 20)
    Freq = xx
    Text2.Text = Freq   ' display the Freq.
    Text2.Text = Mid$(Freq, 3, 11)
    Label4.Caption = Str(Val(Text2.Text) * 0.000001)
skip:

End Sub

Private Sub Command2_Click()

 If MSComm1.PortOpen = False Then
    MSComm1.CommPort = 1
 End If
    ' 57600 baud, no parity, 8 data, and 1 stop bit.
 MSComm1.Settings = "57600,N,8,1"
    ' Tell the control to read entire buffer when Input
    ' is used.
 MSComm1.InputLen = 0
    ' Open the port.
 If MSComm1.PortOpen = False Then
   MSComm1.PortOpen = True
 End If
    
 DoEvents
    
End Sub

Private Sub Command4_Click()
Dim Freq, F As Double
Dim Counter As Integer
Dim CommandString As String
Dim freq2 As Long
Dim freq3 As String

    MSComm1.RTSEnable = True
    MSComm1.InBufferCount = 0
        
    CommandString = "FA"
    
    If (Form1.Option1.Value) Then
      freq2 = Val(Text2.Text) - 1000  'subtract 1 Khz
    End If
    If (Form1.Option2.Value) Then
      freq2 = Val(Text2.Text) - 10000 'subtract 10 Khz
    End If
    If (Form1.Option3.Value) Then
      freq2 = Val(Text2.Text) - 100000 'subtract 100 Khz
    End If
     
    freq3 = Format(freq2, "###########")
    
    Do While Len(freq3) < 11 'ensure that 11 digits are present
    freq3 = "0" + freq3
    Loop
    
    CommandString = CommandString + freq3 + ";"
    
    MSComm1.RTSEnable = True
    MSComm1.InBufferCount = 0
    MSComm1.Output = CommandString
    
   Counter = 0
    Do
      Counter = Counter + 1
    Loop Until MSComm1.InBufferCount > 13 Or Counter > 20000
     If Counter >= 20000 Then
        GoTo skip
    End If
    
    xx = MSComm1.Input      ' get the data
    Freq = Mid$(xx, 1, 20)
    Freq = xx
    Text2.Text = Freq   ' display the Freq.
    Text2.Text = Mid$(Freq, 3, 11)
    Label4.Caption = Str(Val(Text2.Text) * 0.000001)
skip:

End Sub

Private Sub Form_Load()
 If MSComm1.PortOpen = False Then
    MSComm1.CommPort = 1
 End If
    ' 57600 baud, no parity, 8 data, and 1 stop bit.
 MSComm1.Settings = "57600,N,8,1"
    ' Tell the control to read entire buffer when Input
    ' is used.
 MSComm1.InputLen = 0
    ' Open the port.
 If MSComm1.PortOpen = False Then
   MSComm1.PortOpen = True
 End If
    
 DoEvents

'   Set up error handler
    On Error GoTo Err_SAPILoad
    
'   Initialize globals
    indent = 0
    fRecoEnabled = False
    fGrammarLoaded = False
    
'   Create the Shared Reco Context by default
    Set RC = New SpSharedRecoContext
    
        
'   Call the InitEventInterestCheckBoxes subroutine which uses the SR engine
'   default event interests to initialize the event interest checkboxes.
   'InitEventInterestCheckBoxes
'do the following instead
'''''''''''''''''
'   Adaption event interest
''   Audio Level event interest
'    SetEventInterest SREAudioLevel, AudioLevel
'   False Recognition event interest
'    SetEventInterest SREFalseRecognition, FalseReco
'   Hypothesis event interest
'    SetEventInterest SREHypothesis, Hypothesis
'   Interference event interest
''   Phrase Start event interest
''   Engine Private event interest
'    SetEventInterest SREPrivate, PrivateEng
'   Property String Change event interest
'    SetEventInterest SREPropertyStringChange, PropertyStringChange
'   Recognition event interest
'    SetEventInterest SRERecognition, Reco
'   Recognition on Other Context event interest
'    SetEventInterest SRERecoOtherContext, RecoOther
'   Request UI event interest
'    SetEventInterest SRERequestUI, RequestUI
'   Sound End event interest
'    SetEventInterest SRESoundEnd, SoundEnd
'   Sound Start event interest
'    SetEventInterest SRESoundStart, SoundStart
'   State Change event interest
'    SetEventInterest SREStateChange, StateChange
'   Stream Start event interest
'    SetEventInterest SREStreamStart, StreamStart
'   Stream End event interest
'    SetEventInterest SREStreamEnd, StreamEnd
    

'   Create grammar objects
    LoadGrammarObj
    
 '  load the example Command and Control grammar
'   First load attempt
    On Error Resume Next
    Grammar.CmdLoadFromFile "C and C Grammar.xml", SLODynamic
   
    '   Second load attempt
    If Err Then
    On Error GoTo Err_CFGLoad
    Grammar.CmdLoadFromFile "..\\C and C Grammar.xml", SLODynamic
    End If
    
'   Set rule state to inactive until user clicks Recognition button
    Grammar.CmdSetRuleIdState 0, SGDSInactive
    
'   Set the Label to indictate which .xml file is loaded.
    CCLabel.Caption = "C and C Grammar.xml"
    
    fGrammarLoaded = True
    
    'Kenwood stuff....load come control etc.
    MSComm1.CommPort = 1
    ' 57600 baud, no parity, 8 data, and 1 stop bit.
    MSComm1.Settings = "57600,N,8,1"
    ' Tell the control to read entire buffer when Input
    ' is used.
  '  MSComm1.InputLen = 0
    ' Open the port.
    MSComm1.PortOpen = True
    
    Exit Sub
    
Err_CFGLoad:
    fGrammarLoaded = False
    CCLabel.Caption = "Current C+C Grammar: NULL"
    Exit Sub

Err_SAPILoad:
    MsgBox "Error loading SAPI objects! Please make sure SAPI5.1 is correctly installed.", vbCritical
    Exit_Click
    Exit Sub
End Sub

'   This subroutine creates the Grammar object and sets the states to inactive
'   until the user is ready to begin recognition.
Private Sub LoadGrammarObj()
    Set Grammar = RC.CreateGrammar(1)
    
'   Load Dictation but set it to Inactive until user selects "Dictation" radio
'   button.
    Grammar.DictationLoad "", SLOStatic
    Grammar.DictationSetState SGDSInactive
End Sub



'   Activates or Deactivates Command and Control based on the
'   current state of the Recognition button.
Private Sub Recognition_Click()
    ActivateMic.Value = Checked
    
'   First make sure a valid .xml file is loaded for C&C
   
    '   If recognition is currently not enabled, enable it.
       If Not fRecoEnabled Then
            Grammar.CmdSetRuleIdState 0, SGDSActive
            fRecoEnabled = True
    '       Update caption on button.
            Recognition.Caption = "Stop Recognition"
    '       Allow user to activate/deactivate mute
            ActivateMic.Enabled = True
    '       Disable radio buttons and engines combo while recognizing so user doesn't
    '       switch modes during recognition.
           CandC.Enabled = False
           SharedRC.Enabled = True
    '   If recognition is currently enabled, disable it.
        Else
    '       Deactivate Command and Control.
            Grammar.CmdSetRuleIdState 0, SGDSInactive

            fRecoEnabled = False
    '       Update caption on button.
            Recognition.Caption = "Start Recognition"
    '       Disallow user to activate/deactivate mute
            ActivateMic.Enabled = False
    '       Reenable radio buttons while not recognizing so user can switch modes
           CandC.Enabled = True
          
           SharedRC.Enabled = True
    End If
    
End Sub


'   This subroutine is called by the event handler subroutines to update
'   the small edit window with the events that were received.
Private Sub UpdateEventList(StreamNum As Long, StreamPos As Variant, szEvent As String, szEventInfo As String)
    Dim szIndent As String
    Dim szStreamInfo As String
    Dim i As Integer
    
    For i = 0 To indent - 1
        szIndent = szIndent & "    "
    Next
   '' If ShowStreamInfo.Value = Checked Then
        szStreamInfo = " (StreamNum=" & StreamNum & " StreamPos=" & StreamPos & ")"
   ''  End If
    EventTextField.Text = EventTextField.Text & szIndent & szEvent & szStreamInfo & szEventInfo & vbCrLf
    EventTextField.SelStart = Len(EventTextField)
    EventTextField.SelLength = 0
    
    Label2 = szEvent
End Sub

'   The following subroutines are event handlers that get called when the SR engine
'   fires events.

'   Adaption event handler
Private Sub RC_Adaption(ByVal StreamNumber As Long, ByVal StreamPosition As Variant)
    UpdateEventList StreamNumber, StreamPosition, "Adaptation", ""
End Sub
'   Audio Level event handler
Private Sub RC_AudioLevel(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal AudioLevel As Long)
    UpdateEventList StreamNumber, StreamPosition, "AudioLevel", " [Level=" & AudioLevel & "]"
End Sub
'   Bookmark event handler
Private Sub RC_Bookmark(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal EventData As Variant, ByVal Options As SpeechLib.SpeechBookmarkOptions)
    UpdateEventList StreamNumber, StreamPosition, "Bookmark", " [Data=" & EventData & " Option=" & Options & "]"
End Sub
'   End Stream event handler
Private Sub RC_EndStream(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal StreamReleased As Boolean)
    indent = 0
    UpdateEventList StreamNumber, StreamPosition, "EndStream", " [Stream Released=" & StreamReleased & "]"
End Sub
'   Engine Private event handler
Private Sub RC_EnginePrivate(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal lParam As Variant)
    UpdateEventList StreamNumber, StreamPosition, "EnginePrivate", ""
End Sub
'   False Recognition event handler
Private Sub RC_FalseRecognition(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal Result As SpeechLib.ISpeechRecoResult)
    UpdateEventList StreamNumber, StreamPosition, "FalseRecognition", " [Text=" & Result.PhraseInfo.GetText() & "]"
    Set RecoResult = Result
    
    Label1.Caption = "" 'blank if the result is incorrect
End Sub
'   Hypothesis event handler
Private Sub RC_Hypothesis(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal Result As SpeechLib.ISpeechRecoResult)
    UpdateEventList StreamNumber, StreamPosition, "Hypothesis", " [Text=" & Result.PhraseInfo.GetText() & "]"
End Sub
'   Interference event handler
Private Sub RC_Interference(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal Interference As SpeechLib.SpeechInterference)
    UpdateEventList StreamNumber, StreamPosition, "Interference", " [Value=" & Interference & "]"
End Sub
'   Phrase Start event handler
Private Sub RC_PhraseStart(ByVal StreamNumber As Long, ByVal StreamPosition As Variant)
    UpdateEventList StreamNumber, StreamPosition, "PhraseStart", ""
End Sub
'   Property Number Change event handler
Private Sub RC_PropertyNumberChange(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal PropertyName As String, ByVal NewNumberValue As Long)
    UpdateEventList StreamNumber, StreamPosition, "PropertyNumberChange", " [Name=" & PropertyName & " Value=" & NewNumberValue & "]"
    
End Sub
'   Property String Change event handler
Private Sub RC_PropertyStringChange(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal PropertyName As String, ByVal NewStringValue As String)
    UpdateEventList StreamNumber, StreamPosition, "PropertyStringChange", " [Name=" & PropertyName & " Value=" & NewStringValue & "]"
End Sub
'   Recognition event handler
Private Sub RC_Recognition(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal RecognitionType As SpeechLib.SpeechRecognitionType, ByVal Result As SpeechLib.ISpeechRecoResult)
    Dim RecoNode As Node
    Static i As Integer
    
'   Update Event List window first
    UpdateEventList StreamNumber, StreamPosition, "Recognition", " [Text=" & Result.PhraseInfo.GetText() & ", RecoType=" & RecognitionType & "]"
'   Increment unique value for RecoNode's key name.
    i = i + 1
   
'   Add top level node
    Set RecoNode = TreeView1.Nodes.Add(, , "Reco" & i, "Recognition (" & Result.PhraseInfo.GetText() & ")")
'   Call the BuildResultTree subroutine to build up the Result tree
    BuildResultTree Result.PhraseInfo, Result.Alternates(5), RecoNode

'   Save the recognition Result to the global RecoResult
    Set RecoResult = Result
    
    
    
    
  ' This is where you can make the recognition results do something useful.
  
   Label1.Caption = " " & Result.PhraseInfo.GetText() & ""
   Text1.Text = Trim(Label1.Caption)   'the change event handler of Text1 is used to evoke a response
    
End Sub
'   Recognition For Other Context event handler
Private Sub RC_RecognitionForOtherContext(ByVal StreamNumber As Long, ByVal StreamPosition As Variant)
    UpdateEventList StreamNumber, StreamPosition, "RecognitionForOtherContext", ""
End Sub
'   Recognizer State Change event handler
Private Sub RC_RecognizerStateChange(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal NewState As SpeechLib.SpeechRecognizerState)
    UpdateEventList StreamNumber, StreamPosition, "RecognitionStateChange", " [NewState=" & NewState & "]"
End Sub
'   Request UI event handler
Private Sub RC_RequestUI(ByVal StreamNumber As Long, ByVal StreamPosition As Variant, ByVal UIType As String)
    UpdateEventList StreamNumber, StreamPosition, "RequestUI", " [Type=" & UIType & "]"
End Sub
'   Sound End event handler
Private Sub RC_SoundEnd(ByVal StreamNumber As Long, ByVal StreamPosition As Variant)
    indent = 1
    UpdateEventList StreamNumber, StreamPosition, "SoundEnd", ""
End Sub
'   Sound Start event handler
Private Sub RC_SoundStart(ByVal StreamNumber As Long, ByVal StreamPosition As Variant)
    indent = 1
    UpdateEventList StreamNumber, StreamPosition, "SoundStart", ""
    indent = 2
End Sub
'   Stream Start event handler
Private Sub RC_StartStream(ByVal StreamNumber As Long, ByVal StreamPosition As Variant)
    indent = 0
    UpdateEventList StreamNumber, StreamPosition, "StartStream", ""
    indent = 1
End Sub

'   The following subroutine enables the event interest check boxes based on the
'   SR engine's default event interests.
Private Sub InitEventInterestCheckBoxes()
    If RC.EventInterests And SREAdaptation Then
        Adaption.Value = Checked
    End If
    
 '   If RC.EventInterests And SREAudioLevel Then
 '       AudioLevel.Value = Checked
 '   End If
    
    If RC.EventInterests And SREBookmark Then
        Bookmark.Value = Checked
    End If
    
    If RC.EventInterests And SREFalseRecognition Then
        FalseReco.Value = Checked
    End If
    
    If RC.EventInterests And SREHypothesis Then
        Hypothesis.Value = Checked
    End If
    
    If RC.EventInterests And SREInterference Then
        Interference.Value = Checked
    End If
    
    If RC.EventInterests And SREPhraseStart Then
        PhraseStart.Value = Checked
    End If
    
    If RC.EventInterests And SREPrivate Then
        PrivateEng.Value = Checked
    End If
    
    If RC.EventInterests And SREPropertyNumChange Then
     ''   PropertyNumChange.Value = Checked
    End If
    
    If RC.EventInterests And SREPropertyStringChange Then
        PropertyStringChange.Value = Checked
    End If
    
    If RC.EventInterests And SRERecognition Then
        Reco.Value = Checked
    End If
    
    If RC.EventInterests And SRERecoOtherContext Then
        RecoOther.Value = Checked
    End If
    
    If RC.EventInterests And SRERequestUI Then
        RequestUI.Value = Checked
    End If
    
    If RC.EventInterests And SRESoundEnd Then
        SoundEnd.Value = Checked
    End If
    
    If RC.EventInterests And SRESoundStart Then
        SoundStart.Value = Checked
    End If
        
    If RC.EventInterests And SREStateChange Then
        StateChange.Value = Checked
    End If
    
    If RC.EventInterests And SREStreamEnd Then
        StreamEnd.Value = Checked
    End If
    
    If RC.EventInterests And SREStreamStart Then
        StreamStart.Value = Checked
    End If
End Sub

'   The following subroutines handle turning on/off the event interests when
'   The user checks/unchecks them.

Private Sub SetEventInterest(EventInterest As SpeechRecoEvents, EventCheckBox As CheckBox)
    If EventCheckBox.Value = Checked Then
        RC.EventInterests = RC.EventInterests Or EventInterest
    Else
        RC.EventInterests = RC.EventInterests And Not EventInterest
    End If
End Sub

'   Adaption event interest
Private Sub Adaption_Click()
    SetEventInterest SREAdaptation, Adaption
End Sub
'   Audio Level event interest
Private Sub AudioLevel_Click()
 '   SetEventInterest SREAudioLevel, AudioLevel
End Sub
'   Bookmark event interest
Private Sub Bookmark_Click()
    SetEventInterest SREBookmark, Bookmark
End Sub
'   False Recognition event interest
Private Sub FalseReco_Click()
    SetEventInterest SREFalseRecognition, FalseReco
End Sub
'   Hypothesis event interest
Private Sub Hypothesis_Click()
    SetEventInterest SREHypothesis, Hypothesis
End Sub
'   Interference event interest
Private Sub Interference_Click()
    SetEventInterest SREInterference, Interference
End Sub
'   Phrase Start event interest
Private Sub PhraseStart_Click()
    SetEventInterest SREPhraseStart, PhraseStart
End Sub
'   Engine Private event interest
Private Sub PrivateEng_Click()
    SetEventInterest SREPrivate, PrivateEng
End Sub
'   Property Number Change event interest
Private Sub PropertyNumChange_Click()
 '   SetEventInterest SREPropertyNumChange, PropertyNumChange
End Sub
'   Property String Change event interest
Private Sub PropertyStringChange_Click()
    SetEventInterest SREPropertyStringChange, PropertyStringChange
End Sub
'   Recognition event interest
Private Sub Reco_Click()
    SetEventInterest SRERecognition, Reco
End Sub
'   Recognition on Other Context event interest
Private Sub RecoOther_Click()
    SetEventInterest SRERecoOtherContext, RecoOther
End Sub
'   Request UI event interest
Private Sub RequestUI_Click()
    SetEventInterest SRERequestUI, RequestUI
End Sub

Private Sub ShowStreamInfo_Click()
End Sub

'   Sound End event interest
Private Sub SoundEnd_Click()
    SetEventInterest SRESoundEnd, SoundEnd
End Sub
'   Sound Start event interest
Private Sub SoundStart_Click()
    SetEventInterest SRESoundStart, SoundStart
End Sub
'   State Change event interest
Private Sub StateChange_Click()
    SetEventInterest SREStateChange, StateChange
End Sub
'   Stream Start event interest
Private Sub StreamStart_Click()
    SetEventInterest SREStreamStart, StreamStart
End Sub
'   Stream End event interest
Private Sub StreamEnd_Click()
    SetEventInterest SREStreamEnd, StreamEnd
End Sub

'   The following subroutines use the Recognition Result object to build up the
'   TreeView display in the main window.

'   This subroutine builds up the result tree in the main treeview window. It uses
'   the main ISpeechRecoResult object to build up this information. Additionally it
'   also shows the alternates from the recognition.
Private Sub BuildResultTree(ByVal ResultPhraseInfo As ISpeechPhraseInfo, ByVal Alternates As ISpeechPhraseAlternates, ParentNode As Node, Optional DontDoAlternates As Boolean = False)
    Dim id As Integer
    id = TreeView1.Nodes.Count
    Dim PhraseInfoNode As Node
    Dim PropertiesNode As Node
    
'   Add the top level nodes for the result tree
    Set PhraseInfoNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, "PhraseInfo" & id, "Phrase Info")
    Set PropertiesNode = TreeView1.Nodes.Add(PhraseInfoNode.Key, tvwChild, "Properties" & id, "Properties")
    
'   Call subroutines to build up lower level nodes for the Result rules, Result properties,
'   and Result elements.
    BuildPhraseRuleTree ResultPhraseInfo.Rule, PhraseInfoNode
    BuildPhrasePropertyTree ResultPhraseInfo.Properties, PropertiesNode
    BuildPhraseElementsTree ResultPhraseInfo.Elements, PhraseInfoNode, ResultPhraseInfo.LanguageId
    
'   Call subroutine to build up lower level nodes for the alternates.
    If Not DontDoAlternates And Not Alternates Is Nothing Then
        Dim AltNode As Node
        Set AltNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, "Alternates" & id, "Alternates")
        BuildAlternatesTree Alternates, AltNode
    End If
End Sub
'   This subroutine is called by the BuildResultTree subroutine to build up the Result
'   rules.
Private Sub BuildPhraseRuleTree(ByVal PhraseRule As ISpeechPhraseRule, ParentNode As Node, Optional i As Integer = 0)
    Dim Rule As ISpeechPhraseRule
    Dim RuleNode As Node
    
    Set RuleNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, "RuleNode" & ParentNode.Key & i, "Rule (" & PhraseRule.Name & ")")
                
'   Call the subroutine recusively if you have child rules
    If Not PhraseRule.Children Is Nothing Then
        For Each Rule In PhraseRule.Children
            i = i + 1
            BuildPhraseRuleTree Rule, RuleNode, i
        Next
    End If
End Sub
'   This subroutine is called by the BuildResultTree subroutine to build up the Result
'   properties.
Private Sub BuildPhrasePropertyTree(ByVal Properties As ISpeechPhraseProperties, ParentNode As Node)
    Dim Property As ISpeechPhraseProperty
    Dim i As Integer
    i = 0
    
    If Not Properties Is Nothing Then
        If Properties.Count > 0 Then
            For Each Property In Properties
                Dim PropertyNode As Node
                Dim DisplayString As String
                i = i + 1
                                
                If Property.Value = Empty Then
                    DisplayString = "Property (" & Property.Name & ")"
                Else
                    DisplayString = "Property (" & Property.Name & ") (" & Property.Value & ")"
                End If
                Set PropertyNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, ParentNode.Key & i, DisplayString)
                
'               Call the subroutine recusively if you have child properties
                If Not Property.Children Is Nothing Then
                    BuildPhrasePropertyTree Property.Children, PropertyNode
                End If
            Next
        End If
    Else
        ParentNode.Text = "Properties - No Properties"
    End If
End Sub
'   This subroutine is called by the BuildResultTree subroutine to build up the Result
'   elements.
Private Sub BuildPhraseElementsTree(ByVal Elements As ISpeechPhraseElements, ParentNode As Node, LangId As Long)
    Dim Element As ISpeechPhraseElement
    Dim ElementsNode As Node
    Dim i As Integer
    i = 0
    
    If Not Elements Is Nothing Then
        If Elements.Count > 0 Then
            Set ElementsNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, "Elements" & ParentNode.Key, "Elements")
            For Each Element In Elements
                i = i + 1
                Dim ElementNode As Node
                Set ElementNode = TreeView1.Nodes.Add(ElementsNode.Key, tvwChild, "Element" & ParentNode.Key & i, "Element (" & Element.DisplayText & ")")
                If Not IsEmpty(Element.Pronunciation) Then
                    BuildPronunciationTree Element.Pronunciation, ElementNode, LangId
                End If
            Next
        End If
    Else
        Set ElementNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, "Elements" & ParentNode.Key, "Elements - No Elements")
    End If
End Sub
'   This subroutine is called by the BuildPhraseElementsTree subroutine to build up the
'   Result pronunciations for each of the Result elements.
Private Sub BuildPronunciationTree(ByVal Pronunciation As Variant, ParentNode As Node, LangId As Long)
    Dim PronunciationNode As Node
    Dim PC As New SpPhoneConverter
    Dim i As Integer
    i = 0
    
'   Initialize the Phone Converter
'''    PC.LanguageId = 809  'LangId
    
    Set PronunciationNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, "Pronunciations" & ParentNode.Key, "Pronunciations")
    
    For i = 0 To UBound(Pronunciation)
        Dim Phone As String
     '''   Phone = PC.IdToPhone(Pronunciation(i))
        Call TreeView1.Nodes.Add(PronunciationNode.Key, tvwChild, "Pronunciation" & ParentNode.Key & i, "Pronunciation (" & Phone & ")")
    Next
End Sub

'   This subroutine is called by the BuildResultTree subroutine to build up the
'   Result alternates if there are any.
Private Sub BuildAlternatesTree(ByVal Alternates As ISpeechPhraseAlternates, ParentNode As Node)
    Dim alt As ISpeechPhraseAlternate
    Dim i As Integer
    i = 0
    
    For Each alt In Alternates
        i = i + 1
        Dim AltNode As Node
        Set AltNode = TreeView1.Nodes.Add(ParentNode.Key, tvwChild, ParentNode.Key & i, "Alternate" & i)
        BuildResultTree alt.PhraseInfo, Nothing, AltNode, True
    Next
End Sub

'   The following 2 subroutines destroy/create Inproc and Shared RecoContext's depending
'   on what the user has checked.

'   This subroutine destroys the Inproc RecoContext and creates and Shared RecoContext
Private Sub SharedRC_Click()
'   Destroy the Inproc RecoContext
    Set RC = Nothing
    
'   Create the Shared RecoContext
    Set RC = New SpSharedRecoContext
    
'   Call the InitEventInterestCheckBoxes subroutine which uses the SR engine
'   default event interests to initialize the event interest checkboxes.
    InitEventInterestCheckBoxes

'   Create grammar objects
    LoadGrammarObj
   
'   Attempt to load the default .xml file and set the RuleId State to Inactive until
'   the user starts recognition.
 ''   LoadDefaultCnCGrammar
    
'   Disable the engine selection drop down box and reset to the default shared engine.
   ' SREngines.ListIndex = 0
    'SREngines.Enabled = False
End Sub
Private Sub Inproc_Click()
End Sub

'   The remaining subroutines handle simple UI and exiting.

'   This subroutine activates/deactivates the microphone.
Private Sub ActivateMic_Click()
    If ActivateMic.Value = Checked Then
            Grammar.CmdSetRuleIdState 0, SGDSActive
        End If
End Sub
'   This subroutine clears the event text box
Private Sub ClearEvents_Click()
    EventTextField.Text = ""
End Sub
'   This subroutine clears the TreeView window
Private Sub ClearTree_Click()
    TreeView1.Nodes.Clear
End Sub

'   About box
Private Sub About_Click()
    MsgBox "(c) 2006 WB5KIA", vbInformation, "About VB Command and Control"
End Sub
Private Sub ExitBtn_Click()
    Unload Form1
End Sub
Private Sub Exit_Click()
   '  MSComm1.PortOpen = False
    Unload Form1
End Sub

Private Sub Text1_Change() 'this is one way to evoke responses
                           ' it should also be possible to capture the grammar
                           ' P VAL data ... property value   ie. red is 1, blue 2 etc.
                           'having that data as in the Delphi example would make coding
                           ' recognition of identified commands to desired repsponse easier
                           
Dim Freq, F As Double
Dim Counter As Integer
Dim CommandString As String
Dim freq2 As Long
Dim freq3 As String
                          
   Counter = 0
   CommandString = 0
   
   
   If (Text1.Text = Trim("command color red")) Or (Text1.Text = Trim("command color red please")) Then  'to change screen colors
     Form1.Label3.BackColor = RGB(255, 0, 0)
   ElseIf (Text1.Text = "command color blue") Or (Text1.Text = "command color blue please") Then
     Form1.Label3.BackColor = RGB(0, 0, 255)
   ElseIf (Text1.Text = "command color black") Or (Text1.Text = "command color black please") Then
     Form1.Label3.BackColor = RGB(0, 0, 0)
   ElseIf (Text1.Text = "command color green") Or (Text1.Text = "command color green please") Then
     Form1.Label3.BackColor = RGB(0, 255, 0)
   ElseIf (Text1.Text = "command color yellow") Or (Text1.Text = "command color yellow please") Then
     Form1.Label3.BackColor = RGB(255, 255, 0)
   ElseIf (Text1.Text = "command color navy") Or (Text1.Text = "command color navy please") Then 'actually this is cyan; this is navy: &H00800000&
     Form1.Label3.BackColor = RGB(0, 255, 255)
   Else
   '  Form1.Label3.BackColor = &H8000000F  'button face color
   End If
   
   If (Text1.Text = Trim("command frequency increase")) Or (Text1.Text = Trim("command frequency increase please")) Then 'to go up frequency
     'routine to increase frequency goes here
     
     Form1.Label3.BackColor = &H8000000F  'button face color
  
     MSComm1.RTSEnable = True
     MSComm1.InBufferCount = 0
        
     CommandString = "FA"   'command only the VFO A
    
    If (Form1.Option1.Value) Then
      freq2 = Val(Text2.Text) + 1000  'add 1 Khz
    End If
    If (Form1.Option2.Value) Then
      freq2 = Val(Text2.Text) + 10000 'add 10 Khz
    End If
    If (Form1.Option3.Value) Then
      freq2 = Val(Text2.Text) + 100000 'add 100 Khz
    End If
     
    freq3 = Format(freq2, "###########")
    
    Do While Len(freq3) < 11 'ensure that 11 digits are present
    freq3 = "0" + freq3
    Loop
    
    CommandString = CommandString + freq3 + ";"
    MSComm1.Output = CommandString
    
   Counter = 0
    Do
      Counter = Counter + 1
    Loop Until MSComm1.InBufferCount > 13 Or Counter > 20000
     If Counter >= 20000 Then
        GoTo skip
    End If
    
    xx = MSComm1.Input      ' get the data
    Freq = Mid$(xx, 1, 20)
    Freq = xx
    Text2.Text = Freq   ' display the Freq.
    Text2.Text = Mid$(Freq, 3, 11)
skip:

     
    
   ElseIf (Text1.Text = Trim("command frequency decrease")) Or (Text1.Text = Trim("command frequency decrease please ")) Then 'to go down frequency
    ' routine to decreae frequency goes here
    Form1.Label3.BackColor = &H8000000F  'button face color
  
    MSComm1.RTSEnable = True
    MSComm1.InBufferCount = 0
        
    CommandString = "FA"
    
    If (Form1.Option1.Value) Then
      freq2 = Val(Text2.Text) - 1000  'subtract 1 Khz
    End If
    If (Form1.Option2.Value) Then
      freq2 = Val(Text2.Text) - 10000 'subtract 10 Khz
    End If
    If (Form1.Option3.Value) Then
      freq2 = Val(Text2.Text) - 100000 'subtract 100 Khz
    End If
     
    freq3 = Format(freq2, "###########")
    
    Do While Len(freq3) < 11 'ensure that 11 digits are present
    freq3 = "0" + freq3
    Loop
    
    CommandString = CommandString + freq3 + ";"
    
    MSComm1.Output = CommandString
    
   Counter = 0
    Do
      Counter = Counter + 1
    Loop Until MSComm1.InBufferCount > 13 Or Counter > 20000
     If Counter >= 20000 Then
        GoTo skip2
    End If
    
    xx = MSComm1.Input      ' get the data
    Freq = Mid$(xx, 1, 20)
    Freq = xx
    Text2.Text = Freq   ' display the Freq.
    Text2.Text = Mid$(Freq, 3, 11)
skip2:

   End If
   
DoEvents
Text1.Text = "" ' to reset this event handler... won't change freq if this is not done
Label4.Caption = Str(Val(Text2.Text) * 0.000001)
End Sub

Private Sub Timer1_Timer()
  Dim ModeX As String
Dim PP As String
Dim Freq, F As Double
Dim Mode As String
Dim Counter As Integer
Dim CommandString As String

    MSComm1.RTSEnable = True   'this will read the Kenwood VFO A frequency when you spin the manual dial
    MSComm1.InBufferCount = 0  'it updates once a second. Set the Timer1.Interval = 1000 or what ever interval you
                               'want to poll.
  
    CommandString = "FA;"
  
    MSComm1.RTSEnable = True
    MSComm1.InBufferCount = 0
    
    MSComm1.Output = CommandString
    
   Counter = 0
    Do
        Counter = Counter + 1
    Loop Until MSComm1.InBufferCount > 13 Or Counter > 20000
     If Counter >= 20000 Then
        GoTo skip
    End If
    
    xx = MSComm1.Input      ' get the data
    Freq = Mid$(xx, 1, 20)
    Freq = xx

    Text2.Text = Freq   ' display the Freq.
    Text2.Text = Mid$(Freq, 3, 11)
    Label4.Caption = Str(Val(Text2.Text) * 0.000001)
skip:

End Sub
   
