///////////////////////////////////////////////////////////////////////////
// Project:   Radio
// Program:   radiou.pas
// Language:  Object Pascal - Delphi ver 3.0
// Support:   David Fahey
// Date:      07Nov97
// Purpose:   This program opperates an ICOM R8500 radio receiver via its
//            serial interface.
// History:   07Nov97  Initial coding                              DAF
// Notes:     None
///////////////////////////////////////////////////////////////////////////

unit radiou;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Gauges, Spin, ComCtrls, Buttons, TR85u,
  ExtCtrls,  OoMisc, AdPort, AdPacket, ADTrmEmu ;

type
  TRadio = class(TForm)
    Freq: TSpinEdit;
    Step: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    Mode: TComboBox;
    Label4: TLabel;
    NB: TCheckBox;
    Status: TStatusBar;
    Log: TMemo;
    DspLog: TButton;
    comm: TApdComPort;
    Memo1: TMemo;
    DataPacket1: TApdDataPacket;
    Label3: TLabel;
    Button1: TButton;
    Edit1: TEdit;
    Label5: TLabel;
    Button2: TButton;
    Label6: TLabel;
    Button3: TButton;
    ComboBox1: TComboBox;
    Button4: TButton;
    procedure FormShow(Sender: TObject);
    procedure CommReceive(const Sender: TObject; const RxBytes: Word);
    procedure FreqChange(Sender: TObject);
    procedure StepChange(Sender: TObject);
    procedure NBClick(Sender: TObject);
    procedure ModeChange(Sender: TObject);
    procedure HexLog(p: pointer; len: integer; cm: string) ;
    procedure FormCreate(Sender: TObject);
    procedure DspLogClick(Sender: TObject);
    procedure DataPacket1StringPacket(Sender: TObject; Data: String);
    procedure DataPacket1Packet(Sender: TObject; Data: Pointer;
      Size: Integer);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Radio: TRadio ;            { main form }
  ICOMS: Icom ;              { radio state }
  ts: string ;               { temp string }

implementation


{$R *.DFM}

procedure MemPCopy(p: PChar; s: string) ;
var
  i: integer ;
  q: PChar ;
begin
  q := p ;
  for i := 1 to length(s) do
    begin
      q^ := s[i] ;
      inc(q) ;
    end ;
end ;

function MemCopy(p: PChar; len: integer): string ;
var
  i: integer ;
  s: string ;
begin
  SetLength(s,len) ;
  for i := 1 to len do
    s[i] := p[i-1] ;
  result := s ;
end ;

procedure TRadio.HexLog(p: pointer; len: integer; cm: string) ;
var
  c: byte ;
  i: integer ;
  t: string ;
  pc: PChar ;
  frequency:string;
begin
  /// Log.Lines.Add(Format('%s (%d bytes follow): ',[cm,len])) ;
  pc := PChar(p) ;
  t := '' ;
  for i := 0 to len-1 do
    begin
      c := ord(pc[i]) ;
      t := t + format('%.2x ',[c]) ;
     /// if length(t) > 48 then
     ///   begin
     ///     Log.Lines.Add(t) ;
     ///     t := '' ;
     ///   end ;
    end ;
  //   if pos('FE FE 58 E0',t)<>0 then
  //     frequency:= copy(t,pos('FE FE 58 e0',t),20);

   //   Log.Lines.Add(frequency) ;
   Log.Lines.Add(t);
  //Log.Lines.Add(' ') ;
  edit1.text:=t;
end ;

procedure TRadio.FormCreate(Sender: TObject);
begin   
  ICOMS := Icom.Create ;  //required to creat functions for radio state
  // Radio.Height := 217 ;
  Radio.Comm.ComNumber:= 1;
  combobox1.itemindex:=4;
end;

procedure TRadio.FormShow(Sender: TObject);
begin
  Comm.ComNumber := 1;
  Comm.Baud := 19200;
  Comm.DataBits := 8;
  Comm.StopBits :=  1;
  Comm.Parity := pNone ;
 // Comm.FlowControl := tfcCTSRTS ;
  Status.Panels[0].Text := 'Connection opened (19200 bps).' ;
end;

procedure TRadio.CommReceive(const Sender: TObject;
  const RxBytes: Word);
var
  RxText: PChar ;
  tmp: string ;
  n: integer ;
begin
{  GetMem(RxText,RxBytes) ;
//  Comm.Read(RxText,RxBytes) ;

  tmp := MemCopy(RxText,RxBytes) ;
  HexLog(RxText,RxBytes,'Receive data') ;
  ICOMS.DecodeInputStream(tmp) ;
  FreeMem(RxText,RxBytes) ;   }

end;

procedure TRadio.FreqChange(Sender: TObject);
begin
  ts := ICOMS.SetFreq(Freq.Value) ;
  HexLog(addr(ts[1]),length(ts),'Set freq') ;
  // Comm.Putstring(addr(ts[1]),length(ts)) ;
  Comm.PutString(ts);
  Comm.PutString(ts);
end;

procedure TRadio.StepChange(Sender: TObject);
begin
//  ts := ICOMS.SetStep(Step.Value) ;
//  HexLog(addr(ts[1]),length(ts),'Set step') ;
//  Comm.Write(addr(ts[1]),length(ts)) ;
//  Freq.Increment := ICOMS.GetStepValue ;
end;

procedure TRadio.NBClick(Sender: TObject);
begin
  if NB.State = cbChecked then
    begin
      ts := ICOMS.SetNB(trmON) ;
      HexLog(addr(ts[1]),length(ts),'Set NB on') ;
     // Comm.Write(addr(ts[1]),length(ts)) ;
     Comm.PutString (ts) ;
    end
  else
    begin
      ts := ICOMS.SetNB(trmOFF) ;       
      HexLog(addr(ts[1]),length(ts),'Set NB off') ;
    //  Comm.Write(addr(ts[1]),length(ts)) ;
       Comm.Putstring(ts) ;
    end ;
end;

procedure TRadio.ModeChange(Sender: TObject);
begin
  if Mode.Text = 'LSB' then
    ts := ICOMS.SetMode(trmLSB)
  else if Mode.Text = 'USB' then
    ts := ICOMS.SetMode(trmUSB)
  else if Mode.Text = 'AM' then
    ts := ICOMS.SetMode(trmAM)  
 else if Mode.Text = 'AM Narrow' then
    ts := ICOMS.SetMode(trmAMNarrow)
  else if Mode.Text = 'AM Wide' then
    ts := ICOMS.SetMode(trmAMWide)
  else if Mode.Text = 'CW' then
    ts := ICOMS.SetMode(trmCW) 
  else if Mode.Text = 'CW Narrow' then
    ts := ICOMS.SetMode(trmCWNarrow)  
  else if Mode.Text = 'FM' then
    ts := ICOMS.SetMode(trmFM) 
 else if Mode.Text = 'FM Narrow' then
    ts := ICOMS.SetMode(trmFMNarrow)
  else if Mode.Text = 'WFM' then
    ts := ICOMS.SetMode(trmWFM) ;
  HexLog(addr(ts[1]),length(ts),'Set mode') ;
 // Comm.Write(addr(ts[1]),length(ts)) ;
  Comm.PutString(ts) ;
  Comm.PutString(ts) ;
end;

procedure TRadio.DspLogClick(Sender: TObject);
begin
  if Log.Visible then
    begin
      Log.Visible := False ;
      Radio.Height := 217 ;
    end
  else
    begin
      Log.Visible := True ;
      Radio.Height := 433 ;
    end ;
end;



procedure TRadio.DataPacket1StringPacket(Sender: TObject; Data: String);
begin
  // ICOMS.DecodeInputStream(data) ;
  // Memo1.Lines.Add(data);
end;

procedure TRadio.DataPacket1Packet(Sender: TObject; Data: Pointer;
  Size: Integer);
var
  RxText: PChar ;
  tmp: string ;
  n: integer ;
  freq:string;
begin
  // GetMem(data,size) ;
  //  Comm.Read(RxText,RxBytes) ;
  tmp := MemCopy(data,Size) ;
  HexLog(data,size,'Receive data') ;
  //  ICOMS.DecodeInputStream(tmp) ;

  // FreeMem(data,size) ;
  //  if pos('FE FE 58 E0',tmp)<>0 then
  // freq:= copy(tmp,pos('FE FE 58 E0',tmp),10);

  //Memo1.lines.add(tmp);         }
  //   Memo1.lines.add(freq);
end;

procedure TRadio.Edit1Change(Sender: TObject);
var
frequency :string;
first,second,third,fourth,fifth:string;
begin
  frequency:= copy(edit1.text,pos('FE FE',edit1.text)+12,21);
  trim(frequency);
  // if (length(frequency)=32) and (pos('FD',frequency)=30) then
  if (pos('FD',frequency)=19) then
    begin
      first:=copy(frequency,16,2);
      second:=copy(frequency,13,2);
      third:=copy(frequency,10,2);
      fourth:=copy(frequency,7,2);
      fifth:=copy(frequency,4,2);

      // label5.caption:=frequency;
      label5.caption:= first+second+third+fourth+fifth;
      // freq.value:=strtoint(label5.caption);
     end;
end;

procedure TRadio.Button1Click(Sender: TObject);
begin
  // Comm.PutString('FE FE 58 05 00 90 99 09 00 FD');
  ts:=Icoms.SetFreq(strtoint(label5.caption)+1000) ;  //shift 1000
  Comm.PutString(ts);
  Comm.PutString(ts);
  label5.caption:=  inttostr(strtoint(label5.caption)+1000);
  Edit1.text:='';
end;

procedure TRadio.Button2Click(Sender: TObject);
begin
  ts:=Icoms.SetFreq(strtoint(label5.caption)-1000) ;
  Comm.PutString(ts);
  Comm.PutString(ts);
  label5.caption:=  inttostr(strtoint(label5.caption)-1000);
  Edit1.text:='';
end;

procedure TRadio.Button3Click(Sender: TObject);
begin
  ts:=Icoms.SetFreq(strtoint(label5.caption)) ;
  Comm.PutString(ts);
  Comm.PutString(ts);
  label5.caption:=  inttostr(strtoint(label5.caption));
  Edit1.text:='';
end;

procedure TRadio.ComboBox1Change(Sender: TObject);
begin
  case Combobox1.ItemIndex of
    0: label5.caption:= '1800000'; ///1000000 is 10.0 mhz
    1: label5.caption:= '3850000';
    2: label5.caption:= '7225000';
    3: label5.caption:= '10100000';
    4: label5.caption:= '14225000';
    5: label5.caption:= '18110000';
    6: label5.caption:= '21300000';
    7: label5.caption:= '24930000';
    8: label5.caption:= '28500000';
    9: label5.caption:= '14420000';
    10: label5.caption:= '43210000';
  end; //case
  button3.click; //to set freq
end;

procedure TRadio.Button4Click(Sender: TObject);
begin
 // ICOMs.ResetToDefaults;
end;

end.

