/*
** CPLX.C
** A collection of complex number routines.
**
**	struct Complex C_add (struct Complex a, struct Complex b)
**	struct Complex C_sub (struct Complex a, struct Complex b)
**	struct Complex C_mul (struct Complex a, struct Complex b)
**	struct Complex C_div (struct Complex a, struct Complex b)
**	struct Complex C_para (struct Complex a, struct Complex b)
**	   return sum, difference, product, quotient or parallel
**	   of complex quantities a and b.
**
**	struct Complex C_conj (struct Complex a)
**	struct Complex C_inv (struct Complex a)
**	   return complex conj or invert of complex quantity a
**
**	float C_mag (struct Complex a)
**	float C_ang (struct Complex a)
**	   return mag or angle (in rads) of complex quantity a
**
** copyright P. H. Anderson, Morgan State University, 5 May 96
*/


struct Complex
{
   float r;  /*real part*/
   float i;  /*imag part*/
};

struct Complex C_conj (struct Complex a)
{
   struct Complex result;
   result.r = a.r;
   result.i = -a.i;
   return(result);
}

struct Complex C_add (struct Complex a, struct Complex b)
{
   struct Complex result;
   result.r = a.r + b.r;
   result.i = a.i + b.i;
   return(result);
}

struct Complex C_sub (struct Complex a, struct Complex b)
{
   struct Complex result;
   result.r = a.r - b.r;
   result.i = a.i - b.i;
   return(result);
}

struct Complex C_mul (struct Complex a, struct Complex b)
{
   struct Complex result;
   result.r = a.r*b.r - a.i*b.i;
   result.i = a.r*b.i + b.r*a.i;
   return(result);
}

struct Complex C_div (struct Complex a, struct Complex b)
{
   struct Complex c, result, num;
   float denom;

   c = C_conj(b);
   num = C_mul (a, c);
   denom = b.r*b.r + b.i*b.i + 1.2e-63;  /*to prevent division by zero*/

   result.r = num.r / denom;
   result.i = num.i / denom;
   return(result);
}

struct Complex C_para (struct Complex a, struct Complex b)
{
   struct Complex result, num, denom;

   num = C_mul (a, b);
   denom = C_add(a, b);

   result = C_div (num, denom);
   return(result);
}

struct Complex C_inv (struct Complex a)
{
   struct Complex result, num;
   num.r = 1.0;
   num.i = 0.0;
   result = C_div (num, a);
   return(result);
}

 float C_ang (struct Complex a)
 {
    float result;
    result = (float) atan2 ((double) a.i, (double) a.r + 1e-99);
    /* Note that 1e-99 is added to avoid computing the atan of
    ** 90 degrees
    */
    return (result);
 }

 float C_mag (struct Complex a)
 {
    float result;
    result = (float) sqrt ( (double) (a.r*a.r + a.i*a.i));
    return (result);
 }
 
 
 