/* AC Current and Kilowatt/Hr calculator

by Glen Popiel - KW5GP

 */
#include <Wire.h> // Library needed for I2C LCD Display
#include <LiquidCrystal_I2C.h>  // The LCD Library

#define Current_Pin A0  // Define the Current Sense pin
#define zero_point 430  // Define the Zero Setpoint
#define max_point 509 // Define the High (15A) setpoint

float watts, amps, cost_day;  // Variables for wattage, amperage, and the estimated cost per day
int count;  // The A/D count of the Current Sense pin

// Change these for your location
const float voltage = 116.5;  // The AC Line voltage
const float cost_kwh = 0.065; // Cost per Kilowatt/Hour

// Instantiate the LCD Display object 
LiquidCrystal_I2C lcd(0x27,16,2);  // set the LCD address to 0x27 for a 16 chars and 2 line display

void setup()
{
  lcd.init(); // initialize the LCD 
  lcd.backlight();  // Turn on the LCD Backlight 
  lcd.home(); // Move the LCD Cursor to home position
  lcd.clear();  // Clear the LCD screen
  lcd.setCursor(6,0); // Display the Startup screen
  lcd.print("KW5GP");
  lcd.setCursor(0, 1);
  lcd.print("AC Current Meter");
  delay(5000);  
}

void loop()
{

  lcd.home(); // Home and clear the LCD display
  lcd.clear();
  count = analogRead(Current_Pin);  // Read the incoming current sense voltage
  count = count - zero_point; // Subtract the zero point value
 
  if(count <0)  // Our count should be zero, but if it's negative, make it zero
  {
    count = 0;
  }
  
  amps = map(count,0,max_point,0,1500); // Map the current sense voltage to hundredths of an Amp
  amps = amps/100;  // Divide the current by 100 to place the decimal point
  lcd.print("Amps: ");  // Display the Amperage to 1/10 of an Amp
  lcd.print(amps,1);
  lcd.setCursor(0,1);
  lcd.print("Watts: ");
  watts = (amps*voltage); // Calculate and display the wattage
  lcd.print(watts,1);
  delay(5000); // Wait 5 seconds
  lcd.clear();  // Clear the LCD display
  lcd.print("Amps: ");  // Display the amperage again on top line
  lcd.print(amps,1);
  lcd.setCursor(0,1);

  // KW/hrs = cost per KW/h * power
  lcd.print("Cost/day: ");
  cost_day = ((watts/1000) * cost_kwh) *24; // Calculate and display the estimated Kilowatt/Hour cost per day
  lcd.print(cost_day,2);
  delay(5000);  

}

